/*
 * Decompiled with CFR 0.152.
 */
package servermate.updatemate;

import au.com.ordermate.util.DateTimeUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.security.impl.SecurityManager;
import updatemate.client.SiteDataInterface;
import updatemate.util.XmlDateUtil;
import updatemate.ws.SiteData;

public class ServerMateSiteDataInterfaceImpl
implements SiteDataInterface {
    public static final long ONE_DAY = 86400000L;
    public static final long startDate = new Date().getTime();

    public SiteData getData() {
        SiteData siteData = null;
        siteData = new SiteData();
        long updatemateId = SystemCurrentInfo.getInstance().getUpdatemateId();
        if (updatemateId > 0L) {
            siteData.setId(Long.valueOf(updatemateId));
        }
        siteData.setAbn(BusinessInfo.getInstance().getAbn());
        siteData.setBusinessName(BusinessInfo.getInstance().getName());
        siteData.setLocation(BusinessInfo.getInstance().getLocation());
        siteData.setFtpMenuFolder(BusinessInfo.getInstance().getMenuImportFtpFolder());
        siteData.setDatabaseLevel(SystemCurrentInfo.getInstance().getDatabaseRevision());
        siteData.setVersion(OrderMate.VERSION);
        siteData.setDaysSinceRestart((int)((new Date().getTime() - startDate) / 86400000L));
        siteData.setIpAddress("");
        GregorianCalendar lastBackup = this.getLastBackupDate();
        if (lastBackup != null) {
            siteData.setLastBackup(XmlDateUtil.cvtCalToXmlCal((Calendar)lastBackup));
        } else {
            siteData.setLastBackup(null);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(SecurityManager.getSecurityDetails().getExpiryDate());
        siteData.setExpiryDate(XmlDateUtil.cvtCalToXmlCal((Calendar)cal));
        return siteData;
    }

    private GregorianCalendar getLastBackupDate() {
        GregorianCalendar retValue = new GregorianCalendar();
        File file = new File("C:\\Backup");
        if (file.exists()) {
            retValue.setTimeInMillis(file.lastModified());
        } else {
            retValue = null;
        }
        return retValue;
    }

    public void updateExpiryDate(long time) {
        Calendar reqCal = Calendar.getInstance();
        reqCal.setTimeInMillis(time);
        DateTimeUtils.clearTimePart((Calendar)reqCal);
        Calendar myCal = Calendar.getInstance();
        myCal.setTime(SecurityManager.getSecurityDetails().getExpiryDate());
        DateTimeUtils.clearTimePart((Calendar)myCal);
        if (!reqCal.equals(myCal)) {
            OrderMate.LOG.info("Setting expiry date from :" + myCal.getTime() + " to " + reqCal.getTime());
            SecurityManager.getSecurityDetails().setExpiryDate(reqCal.getTime());
        }
    }

    public String getUpdateMateScriptsDir() {
        return SystemProperty.getInstance().getUpdateMateScriptDir();
    }

    public void siteUpdated(SiteData sd) {
        if (sd != null && sd.getId() != null) {
            long currentId = SystemCurrentInfo.getInstance().getUpdatemateId();
            if (currentId <= 0L) {
                SystemCurrentInfo info = SystemCurrentInfo.getInstance();
                info.setUpdatemateId(sd.getId().longValue());
                info.save();
                OrderMate.LOG.info("Set updatemate id to new " + info.getUpdatemateId());
            } else if (currentId != sd.getId()) {
                OrderMate.LOG.warn("Will not set updatemate id. Current is " + currentId + " new is " + sd.getId());
            }
        }
    }
}

