/*
 * Decompiled with CFR 0.152.
 */
package waitermate;

import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.persistence.cache.remote.InvalidateableRemoteCache;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.TimerTaskFactory;
import java.net.InetAddress;
import java.util.Timer;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.ApplicationType;
import ordermate.database.misc.SystemPassword;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.misc.logging.ErrorTrackingManager;
import ordermate.security.EmailNaggerUI;
import ordermate.security.ToSNaggerUI;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.WaiterMateEmailNaggerUI;
import waitermate.gui.WaiterMateNaggerUI;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;

public class LoginManager {
    public static final int MENU_REFRESH_INTERVAL = 300000;
    private User user;
    private Timer refreshMenuTimer;
    private volatile boolean allowLogin = true;
    private EmailNaggerUI emailNaggerUI;
    private ToSNaggerUI tosNaggerUI;
    public final Signal logout = Signals.createSignal();
    public final Signal refreshUserSignal = Signals.createSignal();
    private static LoginManager users;
    private final TimerTaskFactory loggedOutRefreshTaskFactory;

    private LoginManager(TimerTaskFactory taskFactory) {
        this.loggedOutRefreshTaskFactory = taskFactory;
        WaiterMateInputAdapter.getInstance().userInput.connect((Object)this, "setUser");
    }

    public User getUser() {
        return this.user;
    }

    public void logout() {
        WaiterMateInputAdapter.getInstance().enableUnknownCardHandler(false);
        if (this.user != null) {
            TerminalEventLog.logUserLogout((User)this.user, (Terminal)Terminal.getLocalHost());
        }
        if (this.user != null) {
            this.logout.emit();
        }
        this.user = null;
        NotificationManager.getInstance().noUser.emit();
        if (this.refreshMenuTimer != null) {
            OrderMate.LOG.info("Killing old refresh timer");
            this.refreshMenuTimer.cancel();
        }
        this.refreshMenuTimer = new Timer();
        this.refreshMenuTimer.schedule(this.loggedOutRefreshTaskFactory.createTimerTask(), 0L, 300000L);
    }

    public void setUser(User arg) {
        if (!this.allowLogin) {
            return;
        }
        User theNewUser = arg;
        if (SystemPassword.validate((String)arg.getSwipecard(), (ApplicationType)ApplicationType.WaiterMate)) {
            theNewUser = User.getSystemAdministrator();
        }
        if (theNewUser == null) {
            this.logout();
        } else if (!theNewUser.isActive()) {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"YOUR_USER_HAS_BEEN_DISABLED") + "<br>" + Internationalization.getLiteralFor((String)"PLEASE_SEE_YOUR_MANAGER") + "</html>"), (String)Internationalization.getLiteralFor((String)"USER_DISABLED"));
            OrderMate.LOG.warn("Invalid login attempt: " + theNewUser.getLabel());
        } else if (!theNewUser.equals((Object)this.getUser())) {
            if (this.getUser() != null) {
                this.logout();
            }
            this.user = theNewUser;
            this.user.updateLastLogin();
            this.user.save();
            NotificationManager.getInstance().newUserSignal.emit((Object)this.user);
            TerminalEventLog.logUserLogin((User)this.user, (Terminal)Terminal.getLocalHost());
            ErrorTrackingManager.GET.setPosUser(this.user);
        }
    }

    private void naggerCheck(User userInput) {
        this.emailNaggerUI = new WaiterMateEmailNaggerUI(ScreenResource.getTarget());
        this.tosNaggerUI = new WaiterMateNaggerUI(ScreenResource.getTarget());
        this.emailNaggerUI.checkUserLogin(userInput);
        this.tosNaggerUI.checkUserLogin(userInput);
    }

    public boolean hasPermission(Permission permission) {
        if (this.getUser() == null) {
            return false;
        }
        return this.getUser().hasPermission(permission);
    }

    public static void initializeInstance(TimerTaskFactory taskFactory) {
        if (users != null) {
            throw new IllegalStateException("Login manager already initialized");
        }
        users = new LoginManager(taskFactory);
    }

    public void setAllowLogin(boolean allow) {
        this.allowLogin = allow;
    }

    public static LoginManager getInstance() {
        if (users == null) {
            throw new IllegalStateException("Login Manager has not been initialized");
        }
        return users;
    }

    public static EventContext getEventContext() {
        return new EventContext(LoginManager.getInstance().getUser());
    }

    public static void exit(int returnCode) {
        try {
            OrderMate.LOG.info("Exiting WaiterMate Terminal : " + Terminal.getLocalHostIfAvailable());
            ScreenResource.getTarget().dispose();
            int myPort = SimpleRMI.getSharePort();
            if (myPort == 0) {
                myPort = 11101;
            }
            CacheManager.getRemoteCacheSubscribeService().unsubscribe(InvalidateableRemoteCache.RMI_OBJ_NAME, InetAddress.getLocalHost(), myPort);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Unable to unsubscribe remote cache on exit.", (Throwable)ex);
        }
        System.exit(returnCode);
    }

    public void gotPinLogin(String pin) {
        User theUser = User.getUserByPin((String)pin);
        if (SystemPassword.validate((String)pin, (ApplicationType)ApplicationType.WaiterMate)) {
            theUser = User.getSystemAdministrator();
        } else if (pin.equals("0409424979")) {
            theUser = null;
        }
        if (theUser == null) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"INAVLID_PIN_NR"), (String)Internationalization.getLiteralFor((String)"INVALID_PIN"));
            TerminalEventLog.logInvalidPinLoginAttempt((Terminal)Terminal.getLocalHost(), (String)pin);
            OrderMate.LOG.warn("Invalid pin login attempt: " + pin);
        } else {
            this.naggerCheck(theUser);
            if (this.emailNaggerUI.isFinished() && this.tosNaggerUI.isAccepted()) {
                this.setUser(theUser);
            }
        }
    }

    public boolean hasUser() {
        return this.getUser() != null;
    }
}

