/*
 * Decompiled with CFR 0.152.
 */
package waitermate;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertyValue;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import ordermate.OrderMate;
import ordermate.database.integration.LoyaltyIntegrationConfig;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Customer;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.database.users.AllPermissions;
import ordermate.database.web.CustomerWebInfo;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.SingletonSignal;
import waitermate.WaiterMateInputAdapter;
import waitermate.gui.screens.customer.add.AddCustomer;
import waitermate.gui.screens.login.NetworkStatus;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

public class UnknownCardSwipedHandler {
    public final Signal<?, ?, ?, ?, ?> done = new SingletonSignal();
    public static final String NEW_CUST_NAME = "New Customer";
    private boolean allowAddNewCustomer = false;
    private String swipedCardNo = "";

    public void setAllowAddNewCustomer(boolean allowAddNewCustomer) {
        this.allowAddNewCustomer = allowAddNewCustomer;
    }

    public void handleUnknownCard(String cardNo) {
        this.swipedCardNo = cardNo;
        OrderMate.LOG.info("Card is unknown:" + cardNo);
        if (this.allowAddNewCustomer) {
            if (SystemProperty.getInstance().isLoyaltyEnabled()) {
                if (LoyaltyIntegrationConfig.LoyaltyIntegrationType.HO.equals((Object)LoyaltyIntegrationConfig.getInstance().getType()) && HOConfig.getInstance().isEnabled() && HOConfig.getInstance().isMultisiteCustomers() && NetworkStatus.getInstance() != null && !NetworkStatus.getInstance().isWanConnected()) {
                    Dialogs.displayOkDialog((String)("<HTML>" + Internationalization.getLiteralFor((String)"SWIPECARD_NOT_RECOGNISED") + "<BR><BR>" + Internationalization.getLiteralFor((String)"CANNOT_ADD_CUSTOMER_CARD_WHILE_OFFLINE") + "</HTML>"), (String)Internationalization.getLiteralFor((String)"UNKNOWN_SWIPECARD"));
                } else {
                    this.LoyaltyCustomerHandler(cardNo);
                }
            } else {
                this.newCustomerHandler(cardNo);
            }
        } else {
            this.defaultHandler();
        }
    }

    private void defaultHandler() {
        Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"SWIPECARD_NOT_RECOGNISED"), (String)Internationalization.getLiteralFor((String)"UNKNOWN_SWIPECARD"));
    }

    private void LoyaltyCustomerHandler(String cardNo) {
        FetchCustomerDetailsTask fetchCustomerTask = new FetchCustomerDetailsTask(this.swipedCardNo);
        ProgressDialog.doProgressDialog((Task)fetchCustomerTask);
        if (fetchCustomerTask.getNewCustomer() != null) {
            this.gotCustomerSaved(fetchCustomerTask.getNewCustomer());
        } else {
            this.newCustomerHandler(cardNo);
        }
    }

    private void newCustomerHandler(String cardNo) {
        List<BasicAction> options = Arrays.asList(new BasicAction[]{new AddNewEnterDetails(cardNo), new AddNewQuickAssign(cardNo)});
        Dialogs.displayOptionsDialog((String)Internationalization.getLiteralFor((String)"UNKNOWN_SWIPECARD"), (String)Internationalization.getLiteralFor((String)"UNREGISTERED_CARD_HAS_BEEN_SWIPED_WHAT_DO"), options, (boolean)true);
    }

    private void addNewCustomerWithDetails(String cardNo) {
        ArrayList<PropertyValue> defaultValues = new ArrayList<PropertyValue>();
        defaultValues.add(new PropertyValue(Customer.Properties.CARD_ID, (Object)cardNo));
        AddCustomer addCustomer = new AddCustomer(Customer.REQUIRE_BASIC);
        addCustomer.customerSaved.connect((Object)this, "gotCustomerSaved");
        addCustomer.back.connect(this.done);
        addCustomer.add(defaultValues, Customer.REQUIRE_BASIC);
    }

    private void quickAddNewCustomer(String cardNo) {
        Customer newCust = new Customer();
        newCust.setFirstName(NEW_CUST_NAME);
        newCust.setCardID(cardNo);
        newCust.save();
        newCust = (Customer)PersistenceManager.reacquire((PersistentObjectI)newCust);
        this.gotCustomerSaved(newCust);
        if (!LoyaltyIntegrationConfig.LoyaltyIntegrationType.IGT.equals((Object)LoyaltyIntegrationConfig.getInstance().getType()) && SystemProperty.getInstance().isPrintCustPwdOnQuickAdd()) {
            CustomerWebInfo.printPasswordDocketText((Customer)newCust);
        }
    }

    private void gotCustomerSaved(Customer newCustomer) {
        if (newCustomer.getCardID() == null || newCustomer.getCardID().isEmpty()) {
            newCustomer.setCardID(this.swipedCardNo);
            newCustomer.save();
        }
        this.done.emit();
        WaiterMateInputAdapter.getInstance().customerInput.emit((Object)newCustomer);
    }

    private static class FetchCustomerDetailsTask
    extends AbstractTask {
        private Customer newCustomer;
        private String cardNo;

        public FetchCustomerDetailsTask(String cardNo) {
            this.cardNo = cardNo;
        }

        public String getName() {
            return Internationalization.getLiteralFor((String)"CHECKING_SERVER_FOR_CUSTOMER_INFO");
        }

        protected void performTask() throws Exception {
            this.newCustomer = LoyaltyPointAdministrator.getInstance().fetchCustomerInfoFromAuthority(this.cardNo, null);
        }

        protected int getTotalSubTasks() {
            return 0;
        }

        protected Customer getNewCustomer() {
            return this.newCustomer;
        }
    }

    private class AddNewQuickAssign
    extends BasicAction {
        private final String cardNo;

        public AddNewQuickAssign(String cardNo) {
            super(Internationalization.getLiteralFor((String)"QUICK_ASSIGN"), (Icon)IconLoader.get((String)"/waitermate/images/customerSingle.png"));
            this.setPermission(AllPermissions.CUSTOMER_ADMIN);
            this.cardNo = cardNo;
        }

        public void actionPerformed(ActionEvent e) {
            UnknownCardSwipedHandler.this.quickAddNewCustomer(this.cardNo);
        }
    }

    private class AddNewEnterDetails
    extends BasicAction {
        private final String cardNo;

        public AddNewEnterDetails(String cardNo) {
            super(Internationalization.getLiteralFor((String)"ENTER_DETAILS"), (Icon)IconLoader.get((String)"/waitermate/images/customerSingle.png"));
            this.setPermission(AllPermissions.CUSTOMER_ADMIN);
            this.cardNo = cardNo;
        }

        public void actionPerformed(ActionEvent e) {
            UnknownCardSwipedHandler.this.addNewCustomerWithDetails(this.cardNo);
        }
    }
}

