/*
 * Decompiled with CFR 0.152.
 */
package waitermate;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import com.digitalpersona.onetouch.DPFPSample;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.ProximityReader;
import ordermate.database.integration.BarcodePrefix;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.BarcodeUtils;
import ordermate.database.misc.CustomerCard;
import ordermate.database.misc.HOConfig;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCardHelper;
import ordermate.database.users.User;
import ordermate.gui.InputAdapter;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.hom.synchronisation.customer.CustomerUpdateProcessor;
import ordermate.internationalization.Internationalization;
import ordermate.services.misc.CallMethod;
import ordermate.services.misc.CallMethodOnClassExecutable;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.UnknownCardSwipedHandler;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.dialogs.OnePressPopupWindow;

public class WaiterMateInputAdapter
extends InputAdapter {
    public final Signal<User, ?, ?, ?, ?> userInput = Signals.createSignal(User.class, (String)"user");
    public final Signal<CustomerCard, ?, ?, ?, ?> customerCardInput = Signals.createSignal(CustomerCard.class, (String)"card");
    public final Signal<Customer, ?, ?, ?, ?> customerInput = Signals.createSignal(Customer.class, (String)"customer");
    public final Signal<Long, ?, ?, ?, ?> accountIDInput = Signals.createSignal(Long.class, (String)"accountId");
    public final Signal<String, ?, ?, ?, ?> couponScanned = Signals.createSignal(String.class, (String)"uniqueId");
    public final Signal<String, ?, ?, ?, ?> voucherScanned = Signals.createSignal(String.class, (String)"voucherId");
    public final Signal<String, Double, ?, ?, ?> barcodedItemScanned = Signals.createSignal(String.class, (String)"plu", Double.class, (String)"payload");
    public final Signal<DPFPSample, ?, ?, ?, ?> fingerprintSampled = Signals.createSignal(DPFPSample.class, (String)"sample");
    private static WaiterMateInputAdapter adapter;
    private boolean areProximitiesSetup = false;
    public Signal<DPFPSample, ?, ?, ?, ?> fingerprintInput = Signals.createSignal(DPFPSample.class, (String)"sample");
    private UnknownCardSwipedHandler unknownCardHandler;
    static final String CUST_ID_PREFIX = "CID";

    private WaiterMateInputAdapter() {
        this.swipecardInput.connect((Object)this, "swipeCardInput");
        this.proximityReaderInput.connect((Object)this, "proximityInput");
        this.fingerprintInput.connect((Object)this, "gotFingerprint");
        this.unknownCardHandler = new UnknownCardSwipedHandler();
    }

    public void setupProximityReaders() {
        if (!this.areProximitiesSetup) {
            OrderMateLog.LOG.info("Setting up Proximity Readers for Terminal:" + Terminal.getLocalHost());
            List proximityReaders = Terminal.getLocalHost().getAvailableProximityReaders();
            for (ProximityReader current : proximityReaders) {
                current.getData.connect((Object)this, "gotProximityReader");
            }
            this.areProximitiesSetup = true;
        }
    }

    public void swipeCardInput(String data) {
        if (this.isInputParsingEnabled()) {
            Customer theCustomer;
            if (data != null && data.indexOf(CUST_ID_PREFIX) == 1) {
                Customer customerByID = this.getCustomerByID(data);
                if (customerByID != null) {
                    this.customerInput.emit((Object)customerByID);
                }
                return;
            }
            User theUser = User.getUserBySwipecard((String)data);
            if (theUser != null) {
                this.userInput.emit((Object)theUser);
                return;
            }
            CustomerCardHelper helper = new CustomerCardHelper();
            CustomerCard card = helper.getCardByCardId(data);
            if (card != null) {
                this.customerCardInput.emit((Object)card);
            }
            if ((theCustomer = Customer.getCustomerByCard((String)data)) != null) {
                this.customerInput.emit((Object)theCustomer);
            }
            if (theCustomer == null && card == null) {
                this.unknownCardHandler.handleUnknownCard(helper.replaceCardMarker(data));
            }
        }
    }

    public void proximityInput(final String data) {
        if (this.isInputParsingEnabled()) {
            Runnable readData = new Runnable(){

                @Override
                public void run() {
                    User theUser = User.getUserByProximityBand((String)data);
                    if (theUser != null) {
                        WaiterMateInputAdapter.this.userInput.emit((Object)theUser);
                    }
                }
            };
            SwingUtilities.invokeLater(readData);
        }
    }

    void gotFingerprint(DPFPSample sample) {
        if (sample != null) {
            this.fingerprintSampled.emit((Object)sample);
        }
    }

    public InventoryItemUnit parseBarcodeString(String data, AccountType accountType) {
        if (!Terminal.isLocalHostSetup()) {
            return null;
        }
        String barcodeData = BarcodeUtils.stripBarcodeDelimiter((String)data);
        Collection units = InventoryItemUnit.getUnitsByBarcode((String)barcodeData, (AccountType)accountType, (Terminal)Terminal.getLocalHost());
        InventoryItemUnit theUnit = null;
        if (units != null) {
            if (units.size() > 1) {
                OnePressPopupWindow windowSelection = new OnePressPopupWindow(Internationalization.getLiteralFor((String)"SELECT_CORRECT_ITEM"), (Collection)AbstractScrollPaneModel.constructButtons((Collection)units), 1, units.size());
                CustomButton selected = (CustomButton)windowSelection.start();
                if (selected != null) {
                    theUnit = (InventoryItemUnit)selected.getData();
                }
            } else if (units.size() == 1) {
                theUnit = (InventoryItemUnit)units.iterator().next();
            }
        }
        return theUnit;
    }

    protected void emitBarcode(String input) {
        if (LoginManager.getInstance().hasUser()) {
            String data = BarcodeUtils.stripBarcodeDelimiter((String)input);
            if (data.isEmpty()) {
                return;
            }
            BarcodePrefix internalPrefix = BarcodeUtils.getInternalPrefix((String)data);
            if (internalPrefix != null) {
                if (BarcodeUtils.BarcodePrefixGroup.Account.name().equals(internalPrefix.getName())) {
                    this.emitAccount(data, internalPrefix);
                } else if (BarcodeUtils.BarcodePrefixGroup.SalesItem.name().equals(internalPrefix.getName())) {
                    this.emitBarcodedItemScanned(data, internalPrefix);
                } else if (BarcodeUtils.BarcodePrefixGroup.Coupon.name().equals(internalPrefix.getName())) {
                    this.emitCouponScanned(data);
                } else if (BarcodeUtils.BarcodePrefixGroup.GiftVoucher.name().equals(internalPrefix.getName())) {
                    this.emitVoucherScanned(data);
                }
            } else {
                super.emitBarcode(data);
            }
        }
    }

    private void emitAccount(String data, BarcodePrefix prefix) {
        String idString = data.substring(prefix.getPrefix().length(), data.length() - 1);
        try {
            Long value = Long.valueOf(idString);
            OrderMate.LOG.info("Got barcoded account id:" + value.toString());
            this.accountIDInput.emit((Object)value);
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.info("Malformed barcode input:" + data, (Throwable)ex);
        }
    }

    private void emitBarcodedItemScanned(String dataString, BarcodePrefix prefix) {
        OrderMate.LOG.info("Got barcoded item scanned:" + dataString);
        try {
            String plu = BarcodeUtils.getPLUFromInternalBarcode((String)dataString, (BarcodePrefix)prefix);
            Double payload = BarcodeUtils.getPayloadFromInternalBarcode((String)dataString, (BarcodePrefix)prefix);
            if (payload != null) {
                OrderMate.LOG.info("PLU:" + plu + " Payload:" + payload);
                this.barcodedItemScanned.emit((Object)plu, (Object)payload);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Malformed Barcode input " + dataString, (Throwable)ex);
        }
    }

    private void emitCouponScanned(String dataString) {
        OrderMate.LOG.info("Got Coupon scanned:" + dataString);
        this.couponScanned.emit((Object)dataString);
    }

    private void emitVoucherScanned(String dataString) {
        OrderMate.LOG.info("Got Voucher scanned:" + dataString);
        this.voucherScanned.emit((Object)dataString);
    }

    public static WaiterMateInputAdapter getInstance() {
        if (adapter == null) {
            adapter = new WaiterMateInputAdapter();
            NotificationManager.getInstance().notifyScreenChanged.connect((Object)adapter, "gotScreenChanged");
        }
        return adapter;
    }

    public void enableUnknownCardHandler(boolean enabled) {
        this.unknownCardHandler.setAllowAddNewCustomer(enabled);
    }

    public UnknownCardSwipedHandler getUnknownCardHandler() {
        return this.unknownCardHandler;
    }

    private Customer getCustomerByID(String swipedData) {
        try {
            String id = swipedData.substring(swipedData.indexOf(CUST_ID_PREFIX) + CUST_ID_PREFIX.length());
            LocalIdTranslator idTrans = new LocalIdTranslator();
            long localId = idTrans.convertToLocalId((Number)Long.valueOf(id));
            Customer customerByID = (Customer)PersistenceManager.getByID((long)localId, Customer.class);
            if (customerByID == null && HOConfig.getInstance().isConfigured() && HOConfig.getInstance().isMultisiteCustomers()) {
                CallMethodOnClassExecutable callMethodExe = new CallMethodOnClassExecutable(CustomerUpdateProcessor.class.getCanonicalName(), new CallMethod[]{new CallMethod("fetchCustomerFromHO", new Serializable[]{Long.valueOf(localId)})});
                PersistenceManager.getInstance();
                customerByID = (Customer)PersistenceManager.getServerConnection().runSync((Executable)callMethodExe);
            }
            return customerByID;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occurred while retrieving Customer by ID.", (Throwable)ex);
            return null;
        }
    }

    public void gotScreenChanged(AbstractScreen newScreen) {
        adapter.resetInputBuffer();
    }
}

