/*
 * Decompiled with CFR 0.152.
 */
package waitermate;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.cache.CacheManager;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.PermissionGroupLink;
import ordermate.internationalization.Internationalization;
import ordermate.persistence.remote.RemotePersistence;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.WaiterMate;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.ProgressDialog;

public class WaiterMateUpdater {
    public final Signal updatePerformed = Signals.createSignal();
    private static WaiterMateUpdater updater = new WaiterMateUpdater();

    private WaiterMateUpdater() {
    }

    public static WaiterMateUpdater getInstance() {
        return updater;
    }

    public Runnable getUpdateTask() {
        return new WaiterMateUpdateTask();
    }

    private void doProgressTask(final Task task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.doProgressDialog((Task)task);
            }
        });
    }

    private void cachePermissions() {
        List groups = PermissionGroup.getPermissionGroups();
        for (PermissionGroup group : groups) {
            PermissionGroup preloadedGroup = (PermissionGroup)PersistenceManager.preload((PersistentObject)group);
            CacheManager.getInstance().cacheObjects((Collection)preloadedGroup.getPermissionLinks());
            for (PermissionGroupLink link : preloadedGroup.getPermissionLinks()) {
                if (link.getPermission() != null) {
                    CacheManager.getInstance().cacheObject(link.getPermission().getLastSavedSnapshot());
                    continue;
                }
                WaiterMate.LOG.error("The system contains a permission link to a permission that does not exist! " + link);
            }
        }
    }

    private Task getPreloadObjectsTask() {
        return new AbstractTask(){
            private static final int SUB_TASKS = 1;

            public String getName() {
                return "Accelerating system";
            }

            protected int getTotalSubTasks() {
                return 1;
            }

            protected void performTask() throws Exception {
                WaiterMateUpdater.this.cachePermissions();
                this.emitProgress();
            }
        };
    }

    public void exceptionMethod(Exception ex) {
        WaiterMate.LOG.error("During Progress Dialog Tasks an Error Occured! \nerror:\n" + ex.getMessage());
        Dialogs.displayOkDialog((String)ex.getMessage(), (String)Internationalization.getLiteralFor((String)"ERROR"));
    }

    public void refreshQuickSaleAccount() {
        this.updatePerformed.emit();
    }

    private class WaiterMateUpdateTask
    implements Runnable {
        private WaiterMateUpdateTask() {
        }

        @Override
        public void run() {
            OrderMate.LOG.info("Starting waitermate update task");
            boolean canHit = PersistenceManager.isPersistenceSetup();
            if (canHit && PersistenceManager.getPersistenceDelegate() instanceof RemotePersistence) {
                try {
                    if (((RemotePersistence)PersistenceManager.getPersistenceDelegate()).ping() == null) {
                        canHit = false;
                    }
                }
                catch (RemoteException e) {
                    OrderMate.LOG.info("Cannot connect to remote persistence, did not pong to my ping.");
                    canHit = false;
                }
            }
            if (!canHit) {
                throw new IllegalStateException("Cannot connect to persistence for WaiterMate Updater");
            }
            Terminal localhost = Terminal.getLocalHost();
            if (InventoryProfile.shouldCacheMenus((Terminal)localhost)) {
                CompositeTask task = new CompositeTask("Downloading Menu");
                task.exceptionSignal.connect((Object)WaiterMateUpdater.this, "exceptionMethod");
                task.addTask(InventoryProfile.cacheMenuGroups((Terminal)localhost));
                task.addTask(WaiterMateUpdater.this.getPreloadObjectsTask());
                WaiterMateUpdater.this.doProgressTask((Task)task);
            } else if (SystemCurrentInfo.getInstance().needsUpdate()) {
                PersistenceManager.getInstance().clearLocalCaches();
                WaiterMateUpdater.this.doProgressTask(WaiterMateUpdater.this.getPreloadObjectsTask());
            }
            if (TradingDay.needsNewTradingDay()) {
                SystemCurrentInfo.refreshReference();
            }
            OrderMate.LOG.info("Completed waitermate update task");
        }
    }
}

