/*
 * Decompiled with CFR 0.152.
 */
package waitermate.failover;

import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.sales.AccountType;
import ordermate.database.users.User;
import waitermate.guikit.dialogs.Dialogs;

public class WaitermateFailover {
    private static WaitermateFailover instance;
    private Map<AccountType, Boolean> allowedAccountTypes;
    private String server;

    public static boolean isActive() {
        return instance != null;
    }

    public static WaitermateFailover getInstance() {
        return instance;
    }

    public static synchronized void startFailover(String server) {
        OrderMate.LOG.info("Calling Waitermate to run in Failover mode, hooked on :" + server);
        if (instance == null) {
            instance = new WaitermateFailover(server);
        } else {
            instance.connectedToServer(server);
        }
    }

    public static synchronized void stopFailover(String server) {
        OrderMate.LOG.info("Calling Waitermate to stop running in Failover, hooked onto master:" + server);
        if (instance != null) {
            instance.connectedToServer(server);
        }
        instance = null;
    }

    private WaitermateFailover(String yourServer) {
        this.server = yourServer;
        this.allowedAccountTypes = new HashMap<AccountType, Boolean>();
        for (AccountType accountType : AccountType.getRegister().values()) {
            this.allowedAccountTypes.put(accountType, Boolean.FALSE);
        }
        OrderMate.LOG.info("Waitermate Failover activated.");
    }

    private void connectedToServer(String newServer) {
        if (this.server == null || !this.server.equals(newServer)) {
            // empty if block
        }
    }

    public boolean allowedAccountType(AccountType type) {
        if (this.allowedAccountTypes.get(type).booleanValue()) {
            return true;
        }
        this.askForAuthorisation(type);
        return this.allowedAccountTypes.get(type);
    }

    public void showDisallowAction(String name) {
        StringBuilder SB = new StringBuilder("<html><h1 align='center' color='red'>Failover Mode</h1>").append(name).append(" cannot be performed in Failover Mode.<br>").append("Actions that have the potential to modify the database relating<br>").append("to core business functionality are restricted in Failover Mode.<br>").append("Please contact OrderMate Support on 1300 667 067<br><br>").append("Functionality will be restored after handover is complete.</html>");
        Dialogs.displayOkDialog((String)SB.toString(), (String)("Unsupported in Failover: " + name));
    }

    private void askForAuthorisation(AccountType type) {
        String pin;
        StringBuilder SB = new StringBuilder("<html><h1 Color='Orange'></h1>").append("This terminal is running in FailoverMode.<br>").append("This means that the main ServerMate is not connected,<br>").append("and so a connection has been established with a <br>").append("Redundant Terminal.<br>").append("In this mode, all terminals can use Quicksale account types.<br>").append("But care must be taken for other account types.<br>").append("<br>If all WaiterMate Terminals, including this one, are connected<br>").append("to a single Redundant ServerMate, then allow this Account Type.<br>").append("Otherwise, or if unsure only <b>one</b> Waitermate terminal<br>").append("must be allowed to modify Table, Phone or Bartabs.<br>").append("If yes, you will need a manager to authorise in the next step.<br><br>").append("Do you wish to allow <b>" + type + "</b> for this terminal?</html>");
        if (Dialogs.displayChoiceDialog((String)SB.toString(), (String)"Authorise Failover Access", (boolean)true) && (pin = Dialogs.getPIN((boolean)true, (String)("Authorise " + type.toString()), null, null, (String)"Authorise", (String)"Disallow")) != null) {
            User user = User.getUserByPin((String)pin);
            OrderMate.LOG.info("Attempt to authorise account type:" + type + " by user:" + user);
            if (user.getPermissionGroup().getLevel() >= 6) {
                this.allowedAccountTypes.put(type, Boolean.TRUE);
            } else {
                Dialogs.displayOkDialog((String)"This user doesn't have sufficent privileges.", (String)"Account type not authorised");
            }
        }
    }
}

