/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.internationalization.Internationalization;

public class NotificationIconPanel
extends JPanel {
    Map<String, JLabel> allComponents;

    public NotificationIconPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.allComponents = new HashMap<String, JLabel>();
        this.initDefaultIcons();
    }

    private void initDefaultIcons() {
        this.addNotificationIcon("/ordermate/images/clock16.png", Internationalization.getLiteralFor((String)"THE_USER_IS_CURRENTLY_CLOCKED_ON"));
        this.addNotificationIcon("/waitermate/images/Stock_16.png", Internationalization.getLiteralFor((String)"Stock is being requested from this Stock Area!"));
    }

    public void addNotificationIcon(String imageFilename, String toolTip) {
        JLabel iconLabel = new JLabel(IconLoader.get((String)imageFilename));
        iconLabel.setToolTipText(toolTip);
        iconLabel.setVisible(false);
        this.allComponents.put(imageFilename, iconLabel);
        this.add(Box.createHorizontalStrut(16), 0);
        this.add((Component)iconLabel, 0);
    }

    public JLabel getIconLabel(String imageFilename) {
        return this.allComponents.get(imageFilename);
    }

    public void showIcon(String imageFilename) {
        if (!this.allComponents.containsKey(imageFilename)) {
            this.addNotificationIcon(imageFilename, "");
        }
        this.getIconLabel(imageFilename).setVisible(true);
    }

    public void hideIcon(String imageFilename) {
        if (this.allComponents.containsKey(imageFilename)) {
            this.getIconLabel(imageFilename).setVisible(true);
        }
    }
}

