/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui;

import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;

public class WaiterMateCustomerCardLabelGenerator {
    public static String generateLabel(Customer customer, String cardId) {
        StringBuilder builder = new StringBuilder();
        if (customer != null) {
            builder.append("<html>");
            String custName = customer.getName();
            if (custName.isEmpty()) {
                builder.append("Unnamed Customer");
            } else {
                builder.append(customer.getName());
            }
            builder.append("<font color=\"#A4A4A4\">");
            builder.append(" (");
            builder.append(WaiterMateCustomerCardLabelGenerator.generateLoyaltyIfEnabled(customer));
            if (cardId != null && cardId.length() > 1) {
                builder.append("Card No. ").append(cardId.substring(1));
                builder.append(", ");
            }
            builder.append(WaiterMateCustomerCardLabelGenerator.generateTenure(customer));
            builder.append(")</font></html>");
        } else if (cardId != null && cardId.length() > 1) {
            builder.append("Card No. ").append(cardId.substring(1));
        }
        return builder.toString();
    }

    public static String generateLabel(Account account) {
        return WaiterMateCustomerCardLabelGenerator.generateLabel(account.getCustomer(), account.getCardId());
    }

    private static String generateLoyaltyIfEnabled(Customer customer) {
        StringBuilder sb = new StringBuilder();
        if (SystemProperty.getInstance().isLoyaltyEnabled() && customer.getCategory() != null && customer.getCategory().isLoyaltyPointsEnabled()) {
            if (SystemProperty.getInstance().isDollarsTypeEnabled()) {
                sb.append(new Price((double)customer.getLoyaltyPoints() / 100.0, 0.01));
            } else {
                sb.append(customer.getLoyaltyPoints());
            }
            if (customer.getLoyaltyPoints() == 1) {
                sb.append(" point, ");
            } else {
                sb.append(" points, ");
            }
        }
        return sb.toString();
    }

    private static String generateTenure(Customer customer) {
        StringBuilder builder = new StringBuilder();
        Date currentDate = new Date(System.currentTimeMillis());
        Date creationDate = customer.getCreationTime();
        Calendar customerCreationCal = Calendar.getInstance();
        customerCreationCal.setTime(creationDate);
        if (creationDate.compareTo(currentDate) <= 0) {
            long customerCreationDateInDays;
            long currentDateInMS = currentDate.getTime();
            long customerCreationDateInMS = creationDate.getTime();
            long currentDateInDays = WaiterMateCustomerCardLabelGenerator.getDaysFromMilliseconds(currentDateInMS);
            long dayDiff = currentDateInDays - (customerCreationDateInDays = (long)WaiterMateCustomerCardLabelGenerator.getDaysFromMilliseconds(customerCreationDateInMS));
            if (dayDiff < 7L) {
                builder.append(WaiterMateCustomerCardLabelGenerator.doDays(dayDiff));
            } else if (dayDiff >= 28L && dayDiff <= 30L && !WaiterMateCustomerCardLabelGenerator.getMonthsWithLessThanThirtyDays().contains(customerCreationCal.get(2))) {
                builder.append(WaiterMateCustomerCardLabelGenerator.doWeeks(dayDiff));
            } else if (dayDiff <= 29L) {
                builder.append(WaiterMateCustomerCardLabelGenerator.doWeeks(dayDiff));
            } else if (dayDiff <= 364L) {
                builder.append(WaiterMateCustomerCardLabelGenerator.doMonths(dayDiff));
            } else if (dayDiff >= 365L) {
                builder.append(WaiterMateCustomerCardLabelGenerator.doYearsAndMonths(dayDiff));
            }
        }
        return builder.toString();
    }

    private static String doDays(long dayDiff) {
        StringBuilder sb = new StringBuilder();
        sb.append(dayDiff + " day");
        if (dayDiff > 1L || dayDiff == 0L) {
            sb.append("s");
        }
        return sb.toString();
    }

    private static String doWeeks(long dayDiff) {
        StringBuilder sb = new StringBuilder();
        double noOfWeeks = dayDiff / 7L;
        Math.floor(noOfWeeks);
        MathsUtils.roundDoubleToDecPlaces((double)noOfWeeks, (int)0);
        if (noOfWeeks % 1.0 == 0.0) {
            sb.append((int)noOfWeeks + " week");
        } else {
            sb.append(noOfWeeks + " week");
        }
        if (noOfWeeks >= 2.0) {
            sb.append("s");
        }
        return sb.toString();
    }

    private static String doMonths(long dayDiff) {
        StringBuilder sb = new StringBuilder();
        double noOfMonths = WaiterMateCustomerCardLabelGenerator.getNumberOfMonthsFromDays(dayDiff);
        MathsUtils.roundDoubleToDecPlaces((double)noOfMonths, (int)0);
        if (noOfMonths % 1.0 == 0.0) {
            sb.append((int)noOfMonths + " month");
        } else {
            sb.append(noOfMonths + " month");
        }
        if (noOfMonths >= 2.0) {
            sb.append("s");
        }
        return sb.toString();
    }

    private static String doYearsAndMonths(long dayDiff) {
        StringBuilder sb = new StringBuilder();
        double yearsInDec = (double)dayDiff / 365.0;
        double months = yearsInDec % 1.0;
        months *= 365.0;
        months = WaiterMateCustomerCardLabelGenerator.getNumberOfMonthsFromDays((long)months);
        Math.floor(yearsInDec);
        Math.floor(months);
        MathsUtils.roundDoubleToDecPlaces((double)yearsInDec, (int)0);
        MathsUtils.roundDoubleToDecPlaces((double)months, (int)0);
        sb.append((int)yearsInDec + " yr");
        if (yearsInDec >= 2.0) {
            sb.append("s");
        }
        if (months != 0.0) {
            sb.append(" " + (int)months + " mth");
            if (months >= 2.0) {
                sb.append("s");
            }
        }
        return sb.toString();
    }

    private static double getNumberOfMonthsFromDays(long days) {
        double averageMonth = 30.0;
        double monthOfYear = (double)days / averageMonth;
        monthOfYear = Math.floor(monthOfYear);
        return monthOfYear;
    }

    private static int getDaysFromMilliseconds(long millis) {
        return (int)(millis / 1000L / 60L / 60L / 24L);
    }

    private static List<Integer> getMonthsWithLessThanThirtyDays() {
        int[] monthIDs = new int[]{1, 3, 5, 8, 10};
        ArrayList<Integer> months = new ArrayList<Integer>();
        for (int i = 0; i < monthIDs.length; ++i) {
            months.add(monthIDs[i]);
        }
        return months;
    }
}

