/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import ordermate.OrderMate;
import ordermate.gui.CaptureKeyboard;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;
import org.jdesktop.swingx.JXDatePicker;
import waitermate.KBFriendlyFormHelper;

public class WaiterMateObjectEditor<T extends PersistentObject>
implements AncestorListener {
    private Map<JComponent, Binding> bindings;
    public Signal gotChange = Signals.createSignal();
    private UniversalListener listener;

    public WaiterMateObjectEditor() {
        this.bindings = new HashMap<JComponent, Binding>();
        this.listener = new UniversalListener();
    }

    public void setObject(T toEdit, boolean loadValues) {
        SwingUtilities.invokeLater(new Runnable((PersistentObject)toEdit, loadValues){
            final /* synthetic */ PersistentObject val$toEdit;
            final /* synthetic */ boolean val$loadValues;
            {
                this.val$toEdit = persistentObject;
                this.val$loadValues = bl;
            }

            @Override
            public void run() {
                for (JComponent component : WaiterMateObjectEditor.this.bindings.keySet()) {
                    Binding binding = (Binding)WaiterMateObjectEditor.this.bindings.get(component);
                    binding.setSourceObject((Object)this.val$toEdit);
                    if (!this.val$loadValues) continue;
                    binding.refresh();
                }
            }
        });
    }

    public void updateObject() {
        for (JComponent component : this.bindings.keySet()) {
            Binding binding = this.bindings.get(component);
            try {
                binding.save();
            }
            catch (ClassCastException ex) {
                OrderMate.LOG.warn("Binding is invalid:" + binding, (Throwable)ex);
            }
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        CaptureKeyboard.getInstance().processEvents(false);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        CaptureKeyboard.getInstance().processEvents(true);
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    public Object getValueFor(JComponent component) {
        Binding.ValueResult result;
        Binding binding = this.bindings.get(component);
        if (binding != null && !(result = binding.getTargetValueForSource()).failed()) {
            return result.getValue();
        }
        return null;
    }

    public JTextField createTextField(PropertiedObject.Property property, int numColumns) {
        JTextField field = KBFriendlyFormHelper.createTextField(property, numColumns);
        this.bindTextComponent(property, field);
        return field;
    }

    public JTextComponent createIntegerField(PropertiedObject.Property property, int numColumns) {
        JFormattedTextField field = KBFriendlyFormHelper.createIntegerField(property, numColumns);
        this.bindTextComponent(property, field);
        return field;
    }

    public JComboBox createComboBox(PropertiedObject.Property property, EventList values) {
        EventComboBoxModel model = new EventComboBoxModel(values);
        return this.createComboBox(property, model);
    }

    public JComboBox createComboBox(PropertiedObject.Property property, EventComboBoxModel model) {
        JComboBox box = KBFriendlyFormHelper.createComboBox(property, (ComboBoxModel)model);
        this.bindComboBox(property, box);
        return box;
    }

    public AutoCompleteSupport applyAutoComplete(JComboBox box, EventList items, boolean strict) {
        AutoCompleteSupport autoComplete = AutoCompleteSupport.install((JComboBox)box, (EventList)items);
        autoComplete.setCorrectsCase(true);
        autoComplete.setStrict(strict);
        autoComplete.setSelectsTextOnFocusGain(strict);
        return autoComplete;
    }

    private void bindComboBox(PropertiedObject.Property prop, JComboBox comp) {
        BeanProperty beanProp = BeanProperty.create((String)"selectedItem");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, null, (Property)BeanProperty.create((String)prop.getName()), (Object)comp, (Property)beanProp);
        beanProp.addPropertyStateListener((Object)comp, (PropertyStateListener)this.listener);
        this.bindings.put(comp, (Binding)binding);
    }

    private void bindLabel(PropertiedObject.Property prop, JLabel label) {
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, null, (Property)BeanProperty.create((String)prop.getName()), (Object)label, (Property)BeanProperty.create((String)"text"));
        this.bindings.put(label, (Binding)binding);
    }

    private void bindTextComponent(PropertiedObject.Property prop, JTextComponent comp) {
        BeanProperty beanProp = BeanProperty.create((String)"text");
        beanProp.addPropertyStateListener((Object)comp, (PropertyStateListener)this.listener);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, null, (Property)BeanProperty.create((String)prop.getName()), (Object)comp, (Property)beanProp);
        this.bindings.put(comp, (Binding)binding);
    }

    public JXDatePicker createDatePicker(PropertiedObject.Property property) {
        BeanProperty beanProp = BeanProperty.create((String)"date");
        JXDatePicker picker = KBFriendlyFormHelper.createDatePicker(property);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, null, (Property)BeanProperty.create((String)property.getName()), (Object)picker, (Property)beanProp);
        this.bindings.put((JComponent)picker, (Binding)binding);
        beanProp.addPropertyStateListener((Object)picker, (PropertyStateListener)this.listener);
        return picker;
    }

    public JCheckBox createCheckBox(PropertiedObject.Property property, String text) {
        BeanProperty beanProp = BeanProperty.create((String)"selected");
        JCheckBox box = KBFriendlyFormHelper.createCheckBox(property, text);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, null, (Property)BeanProperty.create((String)property.getName()), (Object)box, (Property)beanProp);
        this.bindings.put(box, (Binding)binding);
        beanProp.addPropertyStateListener((Object)box, (PropertyStateListener)this.listener);
        return box;
    }

    public JLabel createLabel(PropertiedObject.Property property) {
        JLabel label = KBFriendlyFormHelper.createLabel(null, null);
        this.bindLabel(property, label);
        return label;
    }

    public Binding getBinding(JComponent component) {
        return this.bindings.get(component);
    }

    class UniversalListener
    implements PropertyStateListener {
        UniversalListener() {
        }

        public void propertyStateChanged(PropertyStateEvent evt) {
            WaiterMateObjectEditor.this.gotChange.emit();
        }
    }
}

