/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui;

import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.ImageHelper;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.gui.dialogs.ForcedChoiceOptionDialog;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.customerdisplay.WaiterMateCustomerDisplay;

public class WaitermateCustomerDisplayGuiHandler
extends WaitermateGuiHandler {
    @Override
    public void displayOkDialog(String title, String message) {
        this.showCustomerDisplayDialog(message);
        super.displayOkDialog(title, message);
    }

    @Override
    public void displayOkDialog(JComponent comp, String title) {
        super.displayOkDialog(comp, title);
        this.showCustomerDisplayDialog(comp);
    }

    @Override
    public boolean displayForcedChoiceDialog(String title, String message, String positiveOption, String negativeOption) {
        this.showCustomerDisplayDialog(HtmlUtils.html((String)(message + "<br>" + positiveOption + " OR " + negativeOption)));
        return super.displayForcedChoiceDialog(title, message, positiveOption, negativeOption);
    }

    @Override
    public void closeBlockingDialog(JPanel mainComponent) {
        super.closeBlockingDialog(mainComponent);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaiterMateCustomerDisplay.getInstance().stopDialog();
            }
        });
    }

    @Override
    public void displayBlockingDialog(JPanel mainComponent) {
        super.displayBlockingDialog(mainComponent);
        this.showCustomerDisplayDialog(mainComponent);
    }

    @Override
    public void refreshBlockingDialog(JPanel mainComponent) {
        this.showCustomerDisplayDialog(mainComponent);
    }

    @Override
    public Object displayChoiceDialog(String title, String message, List<?> options, Object defaultOption) {
        StringBuilder messageBuilder = new StringBuilder(message).append("<br>");
        if (options != null) {
            for (int i = 0; i < options.size(); ++i) {
                if (!(options.get(i) instanceof String)) continue;
                messageBuilder.append((String)options.get(i)).append(",");
            }
            this.showCustomerDisplayDialog(HtmlUtils.html((String)messageBuilder.toString().substring(0, messageBuilder.length() - 1)));
            return super.displayChoiceDialog(title, message, options, defaultOption);
        }
        return null;
    }

    @Override
    public void displayErrorDialog(String title, String message, String errorDetails) {
        this.showCustomerDisplayDialog(HtmlUtils.html((String)(message + "<br>" + errorDetails)));
        super.displayErrorDialog(title, message, errorDetails);
    }

    @Override
    public ForcedChoiceOptionDialog createForcedChoiceDialog(String message, String title, String posText, String negText, List<String> options, boolean requiresConfirmation) {
        StringBuilder messageBuilder = new StringBuilder(message).append("<br>").append(posText).append(" OR ").append(negText).append("<br>");
        if (options != null) {
            for (String option : options) {
                messageBuilder.append(option).append(",");
            }
        }
        this.showCustomerDisplayDialog(HtmlUtils.html((String)messageBuilder.toString().substring(0, messageBuilder.length() - 1)));
        return super.createForcedChoiceDialog(message, title, posText, negText, options, requiresConfirmation);
    }

    private void showCustomerDisplayDialog(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaiterMateCustomerDisplay.getInstance().displayDialog(message);
            }
        });
    }

    private void showCustomerDisplayDialog(final JComponent component) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JComponent ghost = new ImageHelper().ghostifyComponent(component);
                    WaiterMateCustomerDisplay.getInstance().displayDialog(ghost);
                }
            });
        }
    }
}

