/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.additems.search;

import au.com.ordermate.units.SalesQuantity;
import java.util.Iterator;
import java.util.List;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.CustomButtonRenderer;
import ordermate.internationalization.Internationalization;

class InventoryItemRenderer
extends CustomButtonRenderer<InventoryItem> {
    InventoryItemRenderer() {
    }

    protected String createComponentText(InventoryItem item) {
        int i;
        StringBuilder SB = new StringBuilder("<html><body><span style=\"color:gray\">");
        InventoryGroup parent = item.getMenuGroup();
        InventoryGroup[] groups = new InventoryGroup[parent.getDepth() + 1];
        for (i = 0; i < groups.length; ++i) {
            groups[i] = parent;
            parent = parent.getParentGroup();
        }
        for (i = groups.length - 1; i >= 0; --i) {
            SB.append(" &gt ");
            SB.append(groups[i].getLabel());
        }
        SB.append("</span><br>");
        SB.append("<B>" + item.getLabel() + "</B>");
        SB.append("<br><span style=\"color:green\">");
        Iterator it = item.getUnits().iterator();
        for (int maxCount = 3; it.hasNext() && maxCount > 0; --maxCount) {
            InventoryItemUnit nextUnit = (InventoryItemUnit)it.next();
            SB.append(nextUnit.getSizeLabel());
            SB.append(": ");
            String priceString = "N/A";
            List prices = nextUnit.getPrices();
            if (prices != null && !prices.isEmpty()) {
                priceString = ((UnitPriceLevel)prices.get(0)).getPrice().toString();
            }
            SB.append(priceString);
            SalesQuantity amount = nextUnit.getGenericStockCount();
            if (amount != null) {
                if (amount.lessThanOrEquals(0L)) {
                    SB.append("<span style=\"color:red\"> Avail:");
                    SB.append(amount);
                    SB.append("</span>");
                } else {
                    SB.append(" " + Internationalization.getLiteralFor((String)"AVAIL_SHORT") + Internationalization.getLiteralFor((String)"COLON") + " ");
                    SB.append(amount);
                }
            }
            if (!it.hasNext()) continue;
            if (maxCount == 1) {
                SB.append(Internationalization.getLiteralFor((String)"COMMA_ETC"));
                continue;
            }
            SB.append(Internationalization.getLiteralFor((String)"COMMA"));
        }
        SB.append("</span></body></html>");
        return SB.toString();
    }

    public CustomButton<InventoryItem> createComponent() {
        CustomButton button = super.createComponent();
        button.setHorizontalAlignment(2);
        button.setHorizontalTextPosition(2);
        return button;
    }

    public Class<InventoryItem> getSelectedClassType() {
        return InventoryItem.class;
    }
}

