/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.JComponent;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.sales.Account;
import waitermate.gui.customerdisplay.CustomerDisplayDebugHelper;
import waitermate.gui.customerdisplay.CustomerDisplayFunctionPanel;
import waitermate.gui.customerdisplay.MessagePanel;
import waitermate.gui.customerdisplay.advertising.AdvertisementManager;
import waitermate.gui.customerdisplay.advertising.CustomerDisplayAdvertisementManager;
import waitermate.gui.customerdisplay.advertising.ImagedPanel;
import waitermate.upsell.UpsellManager;

public abstract class AbstractCustomerDisplayPanel<T extends AbstractCustomerDisplay>
extends ImagedPanel {
    private JComponent mainAdvertPanel;
    private JComponent southPanel;
    private MessagePanel messagePanel;
    private CustomerDisplayFunctionPanel functionPanel;
    AdvertisementManager adMan;
    protected T display;

    public AbstractCustomerDisplayPanel(Image yourBackground, T yourDisplay) {
        super(yourBackground);
        this.display = yourDisplay;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setupComponents();
    }

    protected void setupComponents() {
        this.functionPanel = this.createFunctionPanel();
        this.functionPanel.applyCustomerDisplay(this.display);
        this.functionPanel.setVisible(false);
        this.adMan = new CustomerDisplayAdvertisementManager((AbstractCustomerDisplay)this.display);
        if (this.useMainAdverts()) {
            this.mainAdvertPanel = this.adMan.getAdvertPanel();
            this.add((Component)this.mainAdvertPanel, "Center");
            this.add((Component)this.functionPanel, "East");
            if (UpsellManager.getInstance() != null) {
                UpsellManager.getInstance().upsellSuggested.connect((Object)this.adMan, "gotUpsell");
            }
        } else {
            this.add((Component)this.functionPanel, "Center");
        }
        CustomerDisplayDebugHelper.renderBorders(this.functionPanel, Color.GREEN);
        this.southPanel = this.adMan.getBannerPanel();
        this.southPanel.setPreferredSize(new Dimension(100, this.display.getBannerHeight()));
        this.southPanel.setVisible(this.display.isBannerVisible());
        CustomerDisplayDebugHelper.renderBorders(this.southPanel, Color.GREEN);
        this.add((Component)this.southPanel, "South");
        this.messagePanel = new MessagePanel();
        this.messagePanel.setPreferredSize(new Dimension(100, this.display.getMessageHeight()));
        this.messagePanel.setMessage(this.display.getStandbyMessage().getMessage(), 0L);
        this.messagePanel.setVisible(this.display.isMessageVisible());
        CustomerDisplayDebugHelper.renderBorders(this.messagePanel, Color.GREEN);
        this.add((Component)this.messagePanel, "North");
        this.messagePanel.applyCustomerDisplay((AbstractCustomerDisplay)this.display);
    }

    protected boolean useMainAdverts() {
        return true;
    }

    public void onStart() {
        this.adMan.start();
    }

    AdvertisementManager getAdvertisingManager() {
        return this.adMan;
    }

    public void setMessage(String value, long delay) {
        this.messagePanel.setMessage(value, delay);
    }

    protected abstract CustomerDisplayFunctionPanel<T> createFunctionPanel();

    protected abstract void accountChanged(Account var1);

    protected JComponent getBanner() {
        return this.southPanel;
    }

    protected MessagePanel getMessage() {
        return this.messagePanel;
    }
}

