/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay;

import au.com.ordermate.configuration.Config;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import ordermate.OrderMate;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.misc.customerdisplay.QAndACustomerDisplay;
import waitermate.gui.customerdisplay.CustomerDisplayFrame;

public class CustomerDisplayDebugHelper {
    private CustomerDisplayDebugHelper() {
    }

    public static void renderBorders(JComponent panel, Color c) {
        if (Config.isDebuging()) {
            LineBorder lb = new LineBorder(c);
            CompoundBorder compBorder = new CompoundBorder(lb, panel.getBorder());
            panel.setBorder(compBorder);
        }
    }

    public static void writeDimentionsToLogs(AbstractCustomerDisplay disp, CustomerDisplayFrame frame) {
        if (Config.isDebuging()) {
            StringBuilder SB = new StringBuilder();
            SB.append("\n===================================\n");
            SB.append("CUSTOMER DISPLAY DETAILS").append("\n");
            SB.append("===================================\n");
            int adjustedheight = frame.getHeight();
            if (disp.isMessageVisible()) {
                adjustedheight -= disp.getMessageHeight();
                SB.append("Message Width: ").append(frame.getWidth()).append(" Height: ").append(disp.getMessageHeight()).append("\n");
            }
            if (disp.isBannerVisible()) {
                adjustedheight -= disp.getBannerHeight();
                SB.append("Banner Width: ").append(frame.getWidth()).append(" Height: ").append(disp.getBannerHeight()).append("\n");
            }
            if (disp instanceof OrderCustomerDisplay) {
                SB.append("Order Width: ").append(((OrderCustomerDisplay)disp).getOrderWidth()).append(" Height: ").append(adjustedheight).append("\n");
                SB.append("Order Header Width: ").append(((OrderCustomerDisplay)disp).getOrderWidth()).append(" Height: ").append(((OrderCustomerDisplay)disp).getOrderHeaderHeight()).append("\n");
                SB.append("Order Footer Width: ").append(((OrderCustomerDisplay)disp).getOrderWidth()).append(" Height: ").append(((OrderCustomerDisplay)disp).getOrderTotalHeight()).append("\n");
                SB.append("Advertisement Width: ").append(frame.getWidth() - ((OrderCustomerDisplay)disp).getOrderWidth()).append(" Height: ").append(adjustedheight).append("\n");
                SB.append("===================================\n");
                OrderMate.LOG.info(SB.toString());
            } else if (disp instanceof QAndACustomerDisplay) {
                SB.append("Question Width: ").append(frame.getWidth()).append(" Height: ").append(((QAndACustomerDisplay)disp).getQuestionPanelHeight()).append("\n");
                SB.append("Answer Width: ").append(frame.getWidth()).append(" Height: ").append(adjustedheight - ((QAndACustomerDisplay)disp).getQuestionPanelHeight()).append("\n");
                SB.append("===================================\n");
                OrderMate.LOG.info(SB.toString());
            }
        }
    }
}

