/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.border.EmptyBorder;
import ordermate.OrderMate;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.resource.ConfigResource;
import waitermate.gui.customerdisplay.advertising.ImagedPanel;
import waitermate.guikit.components.TypewriterLabel;

class MessagePanel
extends ImagedPanel {
    public static final long TYPEWRITER_SPEED = 80L;
    private static final int TOP_PAD = 30;
    private static final int BOTTOM_PAD = 30;
    private static final int LEFT_PAD = 20;
    private static final int RIGHT_PAD = 20;
    private TypewriterLabel messageLabel;

    MessagePanel() {
        super((Image)null);
        this.setLayout(new BoxLayout(this, 0));
        this.messageLabel = new TypewriterLabel();
        this.messageLabel.setAlignmentY(0.5f);
        this.messageLabel.setFont(new Font("SansSerif", 1, 18));
        this.messageLabel.setCharacterInterval(80L);
        this.add(Box.createHorizontalStrut(20));
        this.add((Component)this.messageLabel);
        this.setBorder(new EmptyBorder(new Insets(30, 20, 30, 20)));
    }

    void applyCustomerDisplay(AbstractCustomerDisplay display) {
        ConfigResource background = display.getResourceSet().getResource("Message Background");
        if (background != null && background.getResourcePath() != null) {
            try {
                Image image = IconLoader.getImage((String)background.getResourcePath());
                this.setBackgroundImage(image);
            }
            catch (IconLoader.IconNotFoundException ex) {
                OrderMate.LOG.warn("Cannot load background image, file bad:" + background.getResourcePath(), (Throwable)ex);
            }
            catch (NullPointerException ex) {
                OrderMate.LOG.warn("Cannot load background image, file bad:" + background.getResourcePath(), (Throwable)ex);
            }
        }
        this.messageLabel.setForeground(display.getMessageAttributes().getColour());
        this.messageLabel.setFont(display.getMessageAttributes().generateFont());
    }

    void setMessage(String message, long delay) {
        this.messageLabel.setText(message, delay);
    }
}

