/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.advertising;

import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.misc.resource.ConfigResourceType;
import waitermate.gui.customerdisplay.advertising.VideoPanel;
import waitermate.gui.customerdisplay.advertising.WatermarkPanel;

public class AdvertPanel
extends WatermarkPanel {
    private Image defaultImage;
    private JLabel gifHolder;
    private VideoPanel animationPanel;
    private ConfigResource resource;

    public AdvertPanel(Image watermarkImage, int alpha, float xLocation, float yLocation) {
        super(null, watermarkImage, alpha, xLocation, yLocation);
        this.setLayout(new BorderLayout());
        this.animationPanel = new VideoPanel();
        this.gifHolder = new JLabel();
    }

    public void setConfigResource(final ConfigResource yourResource) {
        this.removeAll();
        this.killAnimation();
        if (SwingUtilities.isEventDispatchThread()) {
            this.loadResource(yourResource);
        } else {
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    AdvertPanel.this.loadResource(yourResource);
                }
            };
            SwingUtilities.invokeLater(toRun);
        }
    }

    private void loadResource(ConfigResource yourResource) {
        this.resource = yourResource;
        if (this.resource == null) {
            this.doDefaultImage();
        } else if (ConfigResourceType.ANIMATION.equals((Object)this.resource.getResourceType())) {
            super.setVisible(true);
            this.loadAnimation(this.resource.getResourcePath());
        } else if (ConfigResourceType.IMAGE.equals((Object)this.resource.getResourceType())) {
            super.setVisible(true);
            try {
                if (this.resource.getResourcePath().endsWith("gif")) {
                    this.loadGif(this.resource.getResourcePath());
                } else {
                    this.loadIcon(IconLoader.getImage((String)this.resource.getResourcePath()));
                }
            }
            catch (IconLoader.IconNotFoundException ex) {
                OrderMate.LOG.warn("Cannot load advertPicture: Loading default image instead");
                this.loadIcon(this.defaultImage);
            }
            catch (NullPointerException ex) {
                OrderMate.LOG.warn("Cannot load advertPicture: Loading default image instead", (Throwable)ex);
                this.loadIcon(this.defaultImage);
            }
        }
    }

    private void loadGif(String resourcePath) {
        ImageIcon icon = IconLoader.get((String)this.resource.getResourcePath());
        this.removeAll();
        this.gifHolder.setIcon(icon);
        this.setBackgroundImage(null);
        this.add(this.gifHolder);
    }

    private void doDefaultImage() {
        if (this.defaultImage != null) {
            super.setVisible(true);
            this.loadIcon(this.defaultImage);
        } else {
            super.setVisible(false);
        }
    }

    private void loadIcon(Image loadThis) {
        if (loadThis == null) {
            return;
        }
        ImageHelper helper = new ImageHelper();
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            Image image = helper.fitImageTo(loadThis, this.getWidth(), this.getHeight());
            this.setBackgroundImage(image);
            this.validate();
            this.repaint();
        }
    }

    private void loadAnimation(String path) {
        if (path == null || path.trim().isEmpty()) {
            return;
        }
        this.setBackgroundImage(null);
        this.animationPanel.setVisible(true);
        this.animationPanel.loadAnimation(path);
        this.add((Component)this.animationPanel, "Center");
        this.validate();
        this.repaint();
        this.animationPanel.startAnimation();
    }

    private void killAnimation() {
        if (this.animationPanel != null) {
            this.animationPanel.stopAnimation();
            this.animationPanel.setVisible(false);
            this.remove(this.animationPanel);
        }
    }

    public void setDefaultImage(Image image) {
        this.defaultImage = image;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.setConfigResource(this.resource);
    }
}

