/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.advertising;

import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.CannotRealizeException;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.swing.JPanel;
import ordermate.OrderMate;

public class VideoPanel
extends JPanel {
    private Player player;

    public VideoPanel() {
        super(new FlowLayout(1));
    }

    public void loadAnimation(String path) {
        this.stopAnimation();
        File file = new File(path);
        try {
            this.player = Manager.createRealizedPlayer((URL)file.toURI().toURL());
            this.player.addControllerListener(new ControllerListener(){

                public void controllerUpdate(ControllerEvent event) {
                    if (event instanceof ControllerClosedEvent && event.getSource() instanceof Player) {
                        ((Player)event.getSource()).deallocate();
                    }
                }
            });
            this.add(this.player.getVisualComponent());
        }
        catch (NoPlayerException ex) {
            OrderMate.LOG.warn("Cannot play the file, no player for it:" + path, (Throwable)ex);
        }
        catch (CannotRealizeException ex) {
            OrderMate.LOG.warn("Cannot Realize the video:" + path, (Throwable)ex);
        }
        catch (MalformedURLException ex) {
            OrderMate.LOG.warn("Cannot play the file, Bad URL:" + path, (Throwable)ex);
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Cannot play the file, IO Error. Is the file already in use?" + path, (Throwable)ex);
        }
    }

    public void startAnimation() {
        if (this.player != null) {
            this.player.start();
        }
    }

    public void stopAnimation() {
        if (this.player != null) {
            this.player.stop();
            this.player.close();
            this.remove(this.player.getVisualComponent());
            this.player = null;
        }
    }
}

