/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.ordering;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.sales.Account;
import waitermate.gui.customerdisplay.CustomerDisplayDebugHelper;
import waitermate.gui.customerdisplay.CustomerDisplayFunctionPanel;
import waitermate.gui.customerdisplay.ordering.OrderingBodyPanel;
import waitermate.gui.customerdisplay.ordering.OrderingFooterPanel;
import waitermate.gui.customerdisplay.ordering.OrderingHeaderPanel;

public class OrderingPanel
extends CustomerDisplayFunctionPanel<OrderCustomerDisplay> {
    private OrderingHeaderPanel headerPanel;
    private OrderingBodyPanel bodyPanel;
    private OrderingFooterPanel footerPanel;

    @Override
    protected void setupComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.headerPanel = new OrderingHeaderPanel();
        this.bodyPanel = new OrderingBodyPanel();
        this.footerPanel = new OrderingFooterPanel();
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.bodyPanel, "Center");
        this.add((Component)this.footerPanel, "South");
    }

    @Override
    public void applyCustomerDisplay(OrderCustomerDisplay display) {
        this.bodyPanel.setBackgroundImage(this.loadImage((AbstractCustomerDisplay)display, "Order Background"));
        this.footerPanel.setBackgroundImage(this.loadImage((AbstractCustomerDisplay)display, "Total Background"));
        this.headerPanel.setBackgroundImage(this.loadImage((AbstractCustomerDisplay)display, "Header Background"));
        CustomerDisplayDebugHelper.renderBorders(this.bodyPanel, Color.MAGENTA);
        this.bodyPanel.applyCustomerDisplay(display);
        CustomerDisplayDebugHelper.renderBorders(this.footerPanel, Color.MAGENTA);
        this.footerPanel.applyCustomerDisplay(display);
        CustomerDisplayDebugHelper.renderBorders(this.headerPanel, Color.MAGENTA);
        this.headerPanel.applyCustomerDisplay(display);
    }

    public void setAccount(Account account) {
        this.bodyPanel.setAccount(account);
        this.footerPanel.setAccount(account);
        this.headerPanel.setAccount(account);
        this.bodyPanel.invalidate();
        this.footerPanel.invalidate();
        this.headerPanel.invalidate();
        this.revalidate();
        this.repaint();
    }
}

