/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.customerdisplay.ordering.line;

import au.com.ordermate.util.DisplayableStringifier;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.gui.FontAttributes;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.misc.customerdisplay.OrderCustomerDisplay;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesOption;
import waitermate.gui.customerdisplay.ordering.line.MultiLineStringifier;
import waitermate.gui.customerdisplay.ordering.line.SalesObjectRenderer;
import waitermate.gui.customerdisplay.ordering.line.SimpleSalesLineRenderer;

class SalesComponentLineRenderer
implements SalesObjectRenderer<SalesComponent> {
    private SalesComponent component;
    private JPanel fillPanel = new JPanel(new BorderLayout());
    private JPanel renderingPanel;
    private JLabel label;
    private SimpleSalesLineRenderer<List<SalesAdd>> addRenderer;
    private SimpleSalesLineRenderer<List<AbstractSalesRemove>> removeRenderer;
    private SimpleSalesLineRenderer<List<SalesOption>> optionRenderer;

    SalesComponentLineRenderer() {
        this.fillPanel.setOpaque(false);
        this.renderingPanel = new JPanel();
        this.renderingPanel.setOpaque(false);
        this.renderingPanel.setAlignmentX(0.0f);
        this.renderingPanel.setLayout(new BoxLayout(this.renderingPanel, 1));
        this.label = new JLabel();
        this.renderingPanel.add(this.label);
        this.fillPanel.add(this.renderingPanel);
    }

    @Override
    public void updateRenderer() {
        this.renderingPanel.removeAll();
        StringBuilder SB = new StringBuilder();
        if (this.component.getUnit().getPortion().getSize() != 1.0) {
            SB.append(this.component.getUnit().getPortion().getFraction()).append(" ").append(this.component.getUnit().getItemLabel());
        } else if (!InventoryWeightUnit.NA.equals((Object)this.component.getUnit().getItem().getInventoryWeightUnit())) {
            this.resolveWeightedItemLabel(SB);
        } else {
            SB.append(this.component.getUnit().getItemLabel());
        }
        this.label.setText(SB.toString());
        this.renderingPanel.add(this.label);
        this.updateMinuses();
        this.updatePluses();
        this.updateOptions();
        this.fillPanel.validate();
    }

    private void updateMinuses() {
        List minuses = this.component.getCurrentMinuses();
        if (minuses.isEmpty()) {
            this.removeRenderer = null;
        } else {
            if (this.removeRenderer == null) {
                this.removeRenderer = new SimpleSalesLineRenderer(new MultiLineStringifier("- ", new DisplayableStringifier()));
            }
            this.removeRenderer.setObject(minuses);
            this.removeRenderer.updateRenderer();
            this.renderingPanel.add(this.removeRenderer.getRenderingComponent());
        }
    }

    private void updatePluses() {
        List pluses = this.component.getCurrentPluses();
        if (pluses.isEmpty()) {
            this.addRenderer = null;
        } else {
            if (this.addRenderer == null) {
                this.addRenderer = new SimpleSalesLineRenderer(new MultiLineStringifier("+ ", new DisplayableStringifier()));
            }
            this.addRenderer.setObject(pluses);
            this.addRenderer.updateRenderer();
            this.renderingPanel.add(this.addRenderer.getRenderingComponent());
        }
    }

    private void updateOptions() {
        ArrayList<SalesOption> options = this.component.getCurrentOptions();
        if (options.isEmpty() || options.size() == 1 && ((SalesOption)options.get(0)).getOption().isDefault()) {
            this.optionRenderer = null;
        } else {
            ArrayList<SalesOption> copiedOptions = new ArrayList<SalesOption>();
            for (SalesOption nextOption : options) {
                if (nextOption.getOption().isDefault()) continue;
                copiedOptions.add(nextOption);
            }
            options = copiedOptions;
            if (!options.isEmpty()) {
                if (this.optionRenderer == null) {
                    this.optionRenderer = new SimpleSalesLineRenderer(new MultiLineStringifier("", new DisplayableStringifier()));
                }
                this.optionRenderer.setObject(options);
                this.renderingPanel.add(this.optionRenderer.getRenderingComponent());
                this.optionRenderer.updateRenderer();
            } else {
                this.optionRenderer = null;
            }
        }
    }

    @Override
    public void setObject(SalesComponent object) {
        this.component = object;
    }

    @Override
    public JComponent getRenderingComponent() {
        return this.fillPanel;
    }

    @Override
    public void applyCustomerDisplay(OrderCustomerDisplay display) {
        FontAttributes attributes = display.getLineAttributes();
        this.label.setFont(attributes.generateFont());
        this.label.setForeground(attributes.getColour());
        if (this.addRenderer != null) {
            this.addRenderer.applyCustomerDisplay(display);
        }
        if (this.removeRenderer != null) {
            this.removeRenderer.applyCustomerDisplay(display);
        }
        if (this.optionRenderer != null) {
            this.optionRenderer.applyCustomerDisplay(display);
        }
    }

    private void resolveWeightedItemLabel(StringBuilder SB) {
        SB.append(this.component.getUnit().getItemLabel()).append(" (").append(this.component.getBasePriceWithoutSurcharges().toString(true)).append("/").append(this.component.getUnit().getItem().getInventoryWeightUnit().getDisplay()).append(")");
    }
}

