/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.util.HtmlBuilder;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.SalesCombo;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class AutoComboScrollPaneModel
extends DefaultScrollPaneModel {
    private final ImageIcon leftArrow = IconLoader.get((String)"/waitermate/images/leftarrow.png");
    private final ImageIcon rightArrow = IconLoader.get((String)"/waitermate/images/rightarrow.png");
    private final Signal comboSelected;
    private boolean arrowLeft = true;

    AutoComboScrollPaneModel(List<SalesCombo> combos, Signal signal, boolean newArrowLeft) {
        this.comboSelected = signal;
        this.arrowLeft = newArrowLeft;
        this.addAll(combos);
        this.setColumns(1);
    }

    public void addComponent(Component component) {
        if (!(component instanceof ComboButtonPanel)) {
            throw new IllegalArgumentException("component should be of type ComboButtonPanel");
        }
        super.addComponent(component);
    }

    public void add(SalesCombo combo) {
        super.addComponent(this.createComponent(combo));
    }

    public void addAll(List<SalesCombo> salesCombos) {
        if (salesCombos == null || salesCombos.isEmpty()) {
            this.reset();
            return;
        }
        for (SalesCombo combo : salesCombos) {
            this.add(combo);
        }
    }

    public void remove(SalesCombo removeCombo) {
        List components = this.getComponents();
        for (int index = 0; index < components.size(); ++index) {
            if (!((ComboButtonPanel)components.get(index)).getCombo().equals((Object)removeCombo)) continue;
            this.removeComponent(index);
            break;
        }
    }

    private Component createComponent(SalesCombo combo) {
        ComboButtonPanel newPanel = new ComboButtonPanel(combo);
        newPanel.comboSelected.connect((Object)this, "gotSelected");
        return newPanel;
    }

    public void gotSelected(SalesCombo combo) {
        this.comboSelected.emit((Object)combo);
    }

    public List<SalesCombo> getComboList() {
        ArrayList<SalesCombo> returnList = new ArrayList<SalesCombo>();
        for (ComboButtonPanel currentPanel : this.getComponents()) {
            returnList.add(currentPanel.getCombo());
        }
        return returnList;
    }

    public SalesCombo getComboAt(int index) {
        return ((ComboButtonPanel)this.getComponent(index)).getCombo();
    }

    public class ComboButtonPanel
    extends JPanel
    implements ActionListener {
        private SalesCombo combo;
        private JButton button;
        public final Signal comboSelected = Signals.createSignal(SalesCombo.class, (String)"selectedCombo");

        ComboButtonPanel(SalesCombo newCombo) {
            this.setLayout(new BorderLayout());
            this.button = this.getNewButton();
            JLabel label = new JLabel(this.makeComboLabel(newCombo), 0);
            if (AutoComboScrollPaneModel.this.arrowLeft) {
                this.add((Component)this.button, "West");
                this.add((Component)label, "East");
            } else {
                this.add((Component)label, "West");
                this.add((Component)this.button, "East");
            }
            this.combo = newCombo;
            this.setBackground(this.combo.getBackgroundColor());
        }

        private String makeComboLabel(SalesCombo newCombo) {
            HtmlBuilder HB = new HtmlBuilder().append(newCombo.toString()).append(" ").append(newCombo.getPrice().toString(true));
            HB.appendLineBreak().appendColor("Saving: ", "GRAY").appendColor(newCombo.getMenuPriceDiff().toString(true), "GRAY");
            return HB.toString();
        }

        public SalesCombo getCombo() {
            return this.combo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comboSelected.emit((Object)this.getCombo());
        }

        private JButton getNewButton() {
            JButton newButton = new JButton();
            newButton.addActionListener(this);
            if (AutoComboScrollPaneModel.this.arrowLeft) {
                newButton.setIcon(AutoComboScrollPaneModel.this.leftArrow);
            } else {
                newButton.setIcon(AutoComboScrollPaneModel.this.rightArrow);
            }
            return newButton;
        }
    }
}

