/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemList;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import ordermate.gui.ordering.OrderComboHelper;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.dialogs.AutoComboScrollPaneModel;
import waitermate.guikit.dialogs.PopupWindow;

public class AutoComboSelector {
    private PopupWindow window;
    private static final String makeTitle = Internationalization.getLiteralFor((String)"MAKE_THESE_COMBOS");
    private static final String breakTitle = Internationalization.getLiteralFor((String)"BREAK_THIS_COMBOS");
    private ComboMode mode = ComboMode.Make;
    private ItemGroup itemGroup;
    private List<List<? extends SalesLineItem>> fromThese;
    private List<SalesItemList> itemList = new ArrayList<SalesItemList>();
    private List<SalesCombo> potentialSalesCombos = new ArrayList<SalesCombo>();
    private SalesItemList filterList = new SalesItemList();
    private AutoComboScrollPane potentialCombosPanel;
    private AutoComboScrollPane selectedCombosPanel;
    private final Signal comboAdded = Signals.createSignal(SalesCombo.class, (String)"SelectedCombo");
    private final Signal comboRemoved = Signals.createSignal(SalesCombo.class, (String)"RemovedCombo");
    private Signal done;
    private EventContext context;
    private JLabel potentialLabel;
    private JLabel selectedLabel;
    private static AutoComboSelector instance;

    private AutoComboSelector() {
        this.init();
    }

    public boolean startMake() {
        if (this.canMakeCombos()) {
            this.window.setText(makeTitle);
            this.potentialLabel.setText(Internationalization.getLiteralFor((String)"AVAILABLE_COMBOS"));
            this.selectedLabel.setText(Internationalization.getLiteralFor((String)"COMBOS_TO_MAKE"));
            this.mode = ComboMode.Make;
            this.setSelectedCombos(null);
            this.matchCombos();
            return this.window.start();
        }
        return false;
    }

    public boolean startBreak() {
        if (this.canBreakCombos()) {
            this.window.setText(breakTitle);
            this.potentialLabel.setText(Internationalization.getLiteralFor((String)"COMBOS_TO_BREAK"));
            this.selectedLabel.setText(Internationalization.getLiteralFor((String)"ORDERED_COMBOS"));
            this.mode = ComboMode.Break;
            this.potentialSalesCombos = new ArrayList<SalesCombo>();
            this.setSelectedCombos(this.itemGroup.getAccount().getSalesCombos());
            this.matchCombos();
            return this.window.start();
        }
        return false;
    }

    public void setFilterList(List salesLineItems) {
        if (salesLineItems == null || salesLineItems.size() == 0) {
            this.filterList = new SalesItemList();
            return;
        }
        this.filterList = new SalesItemList();
        this.filterList.addAll((Collection)salesLineItems);
    }

    protected void init() {
        this.window = new PopupWindow();
        this.window.getNavBar().ok.connect((Object)this, "gotOk");
        this.window.setText(makeTitle);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel selectedPanel = new JPanel(new BorderLayout());
        JPanel potentialPanel = new JPanel(new BorderLayout());
        this.potentialSalesCombos = new ArrayList<SalesCombo>();
        this.potentialLabel = new JLabel();
        this.potentialLabel.setFont(OrderMateTheme.getMediumFont());
        this.selectedLabel = new JLabel();
        this.selectedLabel.setFont(OrderMateTheme.getMediumFont());
        this.selectedCombosPanel = this.initScrollPane(new AutoComboScrollPaneModel(null, this.comboRemoved, true));
        this.potentialCombosPanel = this.initScrollPane(new AutoComboScrollPaneModel(null, this.comboAdded, false));
        this.potentialCombosPanel.setName("potential");
        this.selectedCombosPanel.setName("selected");
        this.selectedCombosPanel.setPreferredSize(new Dimension(300, 500));
        potentialPanel.setName("potentialCombosPnl");
        potentialPanel.add((Component)this.potentialLabel, "North");
        potentialPanel.add((Component)((Object)this.potentialCombosPanel), "Center");
        potentialPanel.setPreferredSize(new Dimension(300, 500));
        selectedPanel.add((Component)this.selectedLabel, "North");
        selectedPanel.add((Component)((Object)this.selectedCombosPanel), "Center");
        selectedPanel.setPreferredSize(new Dimension(300, 500));
        mainPanel.add((Component)potentialPanel, "West");
        mainPanel.add((Component)selectedPanel, "East");
        this.window.setComponent((JComponent)mainPanel);
        this.window.setPreferredSize(new Dimension(700, 550));
        JButton selectAllButton = this.window.getNavBar().constructButton((Icon)IconLoader.get((String)"/waitermate/images/selectAll.png"), Internationalization.getLiteralFor((String)"SELECT_ALL"), "selectAll");
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoComboSelector.this.gotSelectAll();
            }
        });
        selectAllButton.setName("selectAllButton");
        this.window.getNavBar().removeRight((Component)this.window.getNavBar().getOkButton());
        this.window.getNavBar().addRight((Component)selectAllButton);
        JButton clearAllButton = this.window.getNavBar().constructButton((Icon)IconLoader.get((String)"/waitermate/images/selectNone.png"), Internationalization.getLiteralFor((String)"SELECT_NONE"), "selectNone");
        clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoComboSelector.this.gotSelectNone();
            }
        });
        this.window.getNavBar().addRight((Component)clearAllButton);
        this.window.getNavBar().addRight((Component)this.window.getNavBar().getOkButton());
        this.comboAdded.connect((Object)this, "gotComboAdded");
        this.comboRemoved.connect((Object)this, "gotComboRemoved");
    }

    private AutoComboScrollPane initScrollPane(AutoComboScrollPaneModel model) {
        AutoComboScrollPane scrollPane = new AutoComboScrollPane(model);
        scrollPane.setSize(new Dimension(300, 500));
        return scrollPane;
    }

    private void setItemGroup(ItemGroup newItemGp) {
        this.itemGroup = newItemGp;
        this.itemList = new ArrayList<SalesItemList>();
        this.potentialSalesCombos = new ArrayList<SalesCombo>();
        if (this.itemGroup != null) {
            for (List<? extends SalesLineItem> aList : this.fromThese) {
                SalesItemList salesList = new SalesItemList();
                salesList.copyList(aList, LoginManager.getEventContext());
                this.itemList.add(salesList);
                this.potentialSalesCombos.addAll(SalesCombo.generateAutoSalesComboList((SalesItemList)salesList, (SalesItemList)this.filterList, (Terminal)this.context.getTerminal(), (User)this.context.getUser(), (ItemGroup)this.itemGroup));
            }
        }
    }

    public void setContext(ItemGroup itemGroup, List<List<? extends SalesLineItem>> restrictedList, EventContext context) {
        if (itemGroup != null) {
            this.fromThese = new ArrayList<List<? extends SalesLineItem>>();
            if (restrictedList != null) {
                for (List<? extends SalesLineItem> rList : restrictedList) {
                    this.fromThese.add(rList);
                }
            } else {
                this.fromThese.add(itemGroup.getItemHelper().getUnpaidItems());
            }
        }
        this.context = context;
        this.setItemGroup(itemGroup);
    }

    private void setSelectedCombos(List newSelectedCombos) {
        this.selectedCombosPanel.getAutoComboModel().reset();
        if (newSelectedCombos != null) {
            this.selectedCombosPanel.getAutoComboModel().addAll(newSelectedCombos);
        }
    }

    protected void matchCombos() {
        if (this.mode.equals((Object)ComboMode.Make)) {
            this.potentialSalesCombos = new ArrayList<SalesCombo>();
            for (SalesItemList anItemList : this.itemList) {
                this.potentialSalesCombos.addAll(SalesCombo.generateAutoSalesComboList((SalesItemList)anItemList, (SalesItemList)this.filterList, (Terminal)this.context.getTerminal(), (User)this.context.getUser(), (ItemGroup)this.itemGroup));
            }
        }
        AutoComboScrollPaneModel model = (AutoComboScrollPaneModel)this.potentialCombosPanel.getModel();
        if (!this.potentialSalesCombos.isEmpty()) {
            model.reset();
            model.addAll(this.potentialSalesCombos);
        } else {
            model.reset();
        }
    }

    public static boolean canMakeCombos(ItemGroup itemGroup, List<List<? extends SalesLineItem>> restrictedItems) {
        if (itemGroup != null) {
            if (restrictedItems != null) {
                SalesCombo potentialCombo = null;
                for (List<? extends SalesLineItem> aList : restrictedItems) {
                    potentialCombo = SalesCombo.generateSingleAutoCombo((SalesItemList)new SalesItemList(aList), (SalesItemList)SalesItemList.EMPTY_LIST, (Terminal)Terminal.getLocalHost(), (User)LoginManager.getInstance().getUser(), (ItemGroup)itemGroup);
                    if (potentialCombo == null) continue;
                    return true;
                }
            } else {
                return SalesCombo.generateSingleAutoCombo((SalesItemList)new SalesItemList(itemGroup.getItemHelper().getSalesItems()), (SalesItemList)SalesItemList.EMPTY_LIST, (Terminal)Terminal.getLocalHost(), (User)LoginManager.getInstance().getUser(), (ItemGroup)itemGroup) != null;
            }
        }
        return false;
    }

    public boolean canMakeCombos() {
        return !this.potentialSalesCombos.isEmpty();
    }

    public boolean canBreakCombos() {
        if (this.fromThese == null) {
            return false;
        }
        for (List<? extends SalesLineItem> ilist : this.fromThese) {
            for (SalesLineItem salesLineItem : ilist) {
                if (!(salesLineItem instanceof SalesCombo)) continue;
                return true;
            }
        }
        return false;
    }

    public void gotComboAdded(SalesCombo selectedCombo) {
        if (selectedCombo.isValid()) {
            this.addCombo(selectedCombo);
        } else {
            OrderMate.LOG.warn("Autocombo selected for creation, but will not make, is invalid");
        }
    }

    private void addCombo(SalesCombo toAdd) {
        this.potentialSalesCombos.remove(toAdd);
        if (this.mode.equals((Object)ComboMode.Make)) {
            for (SalesItem currentItem : toAdd.getSalesItems()) {
                for (SalesItemList listItems : this.itemList) {
                    if (listItems.subtractItem(currentItem, this.context.getTerminal(), this.context.getUser())) break;
                }
            }
        }
        toAdd.setCustomer(this.itemGroup.getCustomer());
        this.matchCombos();
        this.moveCombo(toAdd, this.potentialCombosPanel, this.selectedCombosPanel);
        this.selectedCombosPanel.displayLastPage();
    }

    public void gotComboRemoved(SalesCombo selectedCombo) {
        this.removeCombo(selectedCombo);
    }

    private void removeCombo(SalesCombo toRemove) {
        this.potentialSalesCombos.add(toRemove);
        if (this.mode.equals((Object)ComboMode.Make)) {
            block0: for (SalesItem currentItem : toRemove.getSalesItems()) {
                boolean found = false;
                for (int i = 0; i < this.itemList.size(); ++i) {
                    for (SalesLineItem salesLineItem : this.fromThese.get(i)) {
                        if (!salesLineItem.isEquivalentTo((SalesLineItem)currentItem, true, false)) continue;
                        this.itemList.get(i).add(currentItem);
                        found = true;
                        break;
                    }
                    if (found) continue block0;
                }
            }
        }
        this.matchCombos();
        this.selectedCombosPanel.getAutoComboModel().remove(toRemove);
    }

    protected void gotSelectAll() {
        AutoComboScrollPaneModel model = this.potentialCombosPanel.getAutoComboModel();
        while (model.getRows() > 0) {
            SalesCombo combo = model.getComboAt(0);
            this.addCombo(combo);
        }
    }

    protected void gotSelectNone() {
        AutoComboScrollPaneModel model = this.selectedCombosPanel.getAutoComboModel();
        while (model.getRows() > 0) {
            SalesCombo combo = model.getComboAt(0);
            this.removeCombo(combo);
        }
    }

    private void moveCombo(SalesCombo combo, AutoComboScrollPane removeFrom, AutoComboScrollPane addTo) {
        removeFrom.getAutoComboModel().remove(combo);
        addTo.getAutoComboModel().add(combo);
    }

    public void gotOk() {
        OrderComboHelper helper = new OrderComboHelper((GuiHandler)new WaitermateGuiHandler());
        if (this.mode.equals((Object)ComboMode.Make)) {
            for (SalesCombo currentItem : this.selectedCombosPanel.getAutoComboModel().getComboList()) {
                if (this.itemGroup.getItems().contains(currentItem)) continue;
                helper.replaceItems(this.itemGroup.getAccount(), currentItem, this.context.getTerminal(), this.context.getUser());
            }
        } else if (this.mode.equals((Object)ComboMode.Break)) {
            for (SalesCombo currentItem : this.potentialSalesCombos) {
                helper.replaceCombo(this.itemGroup.getAccount(), currentItem, this.context.getTerminal(), this.context.getUser());
            }
        }
        this.context = null;
        this.itemGroup = null;
        this.done.emit();
    }

    public void configureSignal(Signal doneSignal) {
        if (doneSignal == null) {
            throw new IllegalArgumentException("Cannot set a null done Signal to AutoComboSelector.");
        }
        this.done = doneSignal;
    }

    public static final AutoComboSelector getInstance() {
        if (instance == null) {
            instance = new AutoComboSelector();
        }
        return instance;
    }

    private static class AutoComboScrollPane
    extends CustomScrollPane {
        public AutoComboScrollPane(AutoComboScrollPaneModel newModel) {
            super((CustomScrollPaneModel)newModel);
        }

        public AutoComboScrollPaneModel getAutoComboModel() {
            return (AutoComboScrollPaneModel)this.getModel();
        }
    }

    private static enum ComboMode {
        Make,
        Break;

    }
}

