/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ordermate.OrderMate;
import ordermate.database.misc.BarcodeUtils;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.keypad.Keypad;
import ordermate.internationalization.Internationalization;
import waitermate.WaiterMateInputAdapter;

public class BarcodeScanGuiPanel
extends JPanel
implements ActionListener {
    private JButton emitAccountBarcode;
    private JButton emitItemBarcode;
    private JButton clearId;
    private JButton paste;
    private JTextField idField;
    private Keypad keyPad;

    public BarcodeScanGuiPanel() {
        this.setupComponents();
    }

    private void setupComponents() {
        this.idField = new JTextField();
        this.idField.setColumns(20);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow(Internationalization.getLiteralFor((String)"ID"), (Component)this.idField);
        this.emitAccountBarcode = new JButton(Internationalization.getLiteralFor((String)"EMIT_ACCOUNT_BARCODE"));
        this.emitAccountBarcode.setToolTipText(Internationalization.getLiteralFor((String)"EMITS_THE_GIVEN_ID_AS_AN_ACCOUNT_BARCODE"));
        this.emitItemBarcode = new JButton(Internationalization.getLiteralFor((String)"EMIT_ITEM_BARCODE"));
        this.emitItemBarcode.setToolTipText(Internationalization.getLiteralFor((String)"EMITS_THE_GIVEN_ID_AS_AN_ITEM_BARCODE"));
        this.clearId = new JButton(Internationalization.getLiteralFor((String)"CLEAR"));
        this.clearId.setToolTipText(Internationalization.getLiteralFor((String)"CLEAR_THE_ID_FROM_THE_FIELD"));
        this.paste = new JButton("Paste");
        this.paste.setToolTipText("Paste contents from the system clip board.");
        builder.addRow("", (Component)this.emitAccountBarcode);
        builder.addRow("", (Component)this.emitItemBarcode);
        builder.addRow("", (Component)this.clearId);
        builder.addRow("", (Component)this.paste);
        this.emitAccountBarcode.addActionListener(this);
        this.emitItemBarcode.addActionListener(this);
        this.clearId.addActionListener(this);
        this.paste.addActionListener(this);
        Keypad.KeypadBuilder keyPadBuilder = new Keypad.KeypadBuilder();
        this.keyPad = keyPadBuilder.build();
        this.keyPad.setMaximumValue(13);
        this.keyPad.updated.connect((Object)this, "gotBarcode");
        builder.addRow("", (Component)this.keyPad);
        this.add(builder.getPanel());
    }

    public void gotBarcode(String value) {
        this.idField.setText(value);
    }

    private void emitAccountBarcode() {
        Long id = this.getNumber();
        if (id != null) {
            StringBuilder SB = new StringBuilder("F");
            SB.append(BarcodeUtils.makeBarcodeString((long)id, (BarcodeUtils.BarcodePrefixGroup)BarcodeUtils.BarcodePrefixGroup.Account));
            SB.append(7);
            WaiterMateInputAdapter.getInstance().gotInput(SB.toString());
        }
    }

    private void emitAsBarcode() {
        String id = this.idField.getText();
        if (id == null || id.isEmpty()) {
            id = "9325121000519";
        }
        StringBuilder SB = new StringBuilder("F").append(id);
        WaiterMateInputAdapter.getInstance().gotInput(SB.toString());
    }

    private Long getNumber() {
        String text = this.idField.getText();
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        try {
            return Long.valueOf(text.trim());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Incorrect number input into idField.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.emitAccountBarcode) {
            this.emitAccountBarcode();
        } else if (source == this.emitItemBarcode) {
            this.emitAsBarcode();
        } else if (source == this.clearId) {
            this.keyPad.setValue("");
        } else if (source == this.paste) {
            Clipboard clippy = Toolkit.getDefaultToolkit().getSystemClipboard();
            Object data = null;
            try {
                data = clippy.getData(DataFlavor.stringFlavor);
            }
            catch (Exception e1) {
                OrderMate.LOG.error("Cannot paste contents from clipboard");
            }
            if (data != null) {
                this.idField.setText(String.valueOf(data));
            }
        }
    }
}

