/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.networkio.ports.GuiPortDisplay;
import au.com.ordermate.networkio.ports.GuiPortFrame;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ordermate.OrderMate;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.PlusMinusPanel;
import ordermate.gui.keypad.Keypad;

public class CallerDisplayGuiPanel
extends JPanel
implements ActionListener {
    private JButton sendPhoneNumberBtn;
    private JButton clearPhoneNo;
    private JButton sendStevePhoneNoBtn;
    private JButton sendAmandaPhoneNoBtn;
    private JButton sendSandraPhoneNoBtn;
    private JButton sendAreaCodePhoneNoBtn;
    private PlusMinusPanel lineNumber;
    private JTextField phoneNoField;
    private Keypad keyPad;
    private GuiPortDisplay guiPortDisplay = (GuiPortDisplay)GuiPortFrame.getInstance().getPanel("CallerID");
    private static final String GUI_FRAME_NAME = "CallerID";
    private static final int PHONE_NUMBER_LENGTH = 14;
    private static final String CALL_DATA_STEVE = "01 I S 0000 G B1 11/10 12:18 PM 039-999-8888                   \r\n";
    private static final String CALL_DATA_AMANDA = "02 I S 0000 G B1 11/10 12:18 PM 041-765-4456                   \r\n";
    private static final String CALL_DATA_SANDRA = "03 I S 0000 G B1 11/10 12:18 PM 98683222                       \r\n";
    private static final String CALL_DATA_ALL_ZERO_THREE_AREA_CODE = "01 I S 0000 G B1 11/10 12:18 PM 03                             \r\n";

    public CallerDisplayGuiPanel() {
        this.setUpComponents();
    }

    private void setUpComponents() {
        JPanel phoneNumberPnl = new JPanel();
        phoneNumberPnl.setLayout(new GridLayout(0, 2, 5, 0));
        this.phoneNoField = new JTextField();
        this.phoneNoField.setColumns(14);
        this.sendPhoneNumberBtn = new JButton("Send Phone Number");
        this.sendPhoneNumberBtn.setToolTipText("Sends the given Phone Number as a call.");
        phoneNumberPnl.add(this.phoneNoField);
        phoneNumberPnl.add(this.sendPhoneNumberBtn);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Phone Number:", (Component)phoneNumberPnl);
        this.clearPhoneNo = new JButton("Clear");
        this.clearPhoneNo.setToolTipText("Clear the Phone Number from the field");
        builder.addRow("", (Component)this.clearPhoneNo);
        this.lineNumber = new PlusMinusPanel(Integer.valueOf(1), Integer.valueOf(3));
        this.lineNumber.setPlusMinusText(null, null);
        this.lineNumber.setValue(1);
        builder.addRow("Line Number: ", (Component)this.lineNumber);
        this.sendPhoneNumberBtn.addActionListener(this);
        this.clearPhoneNo.addActionListener(this);
        Keypad.KeypadBuilder keyPadBuilder = new Keypad.KeypadBuilder();
        this.keyPad = keyPadBuilder.build();
        this.keyPad.setMaximumValue(13);
        this.keyPad.updated.connect((Object)this, "gotPhoneNumber");
        builder.addRow("", (Component)this.keyPad);
        builder.addSeparator("");
        this.sendStevePhoneNoBtn = new JButton("Send Steve, Line 1");
        this.sendAmandaPhoneNoBtn = new JButton("Send Amanda, Line 2");
        this.sendSandraPhoneNoBtn = new JButton("Send Sandra, Line 3");
        this.sendAreaCodePhoneNoBtn = new JButton("Send 03 Area Code, Line 1");
        this.sendStevePhoneNoBtn.addActionListener(this);
        this.sendAmandaPhoneNoBtn.addActionListener(this);
        this.sendSandraPhoneNoBtn.addActionListener(this);
        this.sendAreaCodePhoneNoBtn.addActionListener(this);
        JPanel presetNumberBtns = new JPanel();
        presetNumberBtns.setLayout(new GridLayout(2, 2, 6, 6));
        presetNumberBtns.add(this.sendStevePhoneNoBtn);
        presetNumberBtns.add(this.sendAmandaPhoneNoBtn);
        presetNumberBtns.add(this.sendSandraPhoneNoBtn);
        presetNumberBtns.add(this.sendAreaCodePhoneNoBtn);
        builder.addRow("Presets:", (Component)presetNumberBtns);
        this.add(builder.getPanel());
    }

    public void gotPhoneNumber(String value) {
        this.phoneNoField.setText(value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.sendPhoneNumberBtn) {
            this.buildAndSendCallData();
        } else if (source == this.clearPhoneNo) {
            this.keyPad.setValue("");
        } else if (source == this.sendStevePhoneNoBtn) {
            this.sendPhoneNumber(CALL_DATA_STEVE);
        } else if (source == this.sendAmandaPhoneNoBtn) {
            this.sendPhoneNumber(CALL_DATA_AMANDA);
        } else if (source == this.sendSandraPhoneNoBtn) {
            this.sendPhoneNumber(CALL_DATA_SANDRA);
        } else if (source == this.sendAreaCodePhoneNoBtn) {
            this.sendPhoneNumber(CALL_DATA_ALL_ZERO_THREE_AREA_CODE);
        }
    }

    public void buildAndSendCallData() {
        StringBuilder callData = new StringBuilder();
        if (this.guiPortDisplay != null && !this.phoneNoField.getText().isEmpty()) {
            callData.append(String.format("%02d", this.lineNumber.getValue()));
            callData.append(" I S 0000 G B1 11/10 12:18 PM ");
            callData.append(String.format("%1$-14s", this.phoneNoField.getText()));
            callData.append("                 \r\n");
            this.sendPhoneNumber(callData.toString());
        }
    }

    private void sendPhoneNumber(String callData) {
        try {
            if (this.guiPortDisplay != null && !callData.isEmpty()) {
                this.guiPortDisplay.sendDataToBeReceived.emit((Object)callData);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Error sending phone number to CallerID.", (Throwable)ex);
        }
    }
}

