/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.PopupWindow;

public class DateSelectDialog
extends PopupWindow
implements ActionListener {
    private Date theDate;
    private JLabel dateLabel;
    private JButton prevDay;
    private JButton nextDay;
    private JLabel dayLabel;
    private JButton prevWeek;
    private JButton nextWeek;
    private JLabel weekLabel;
    private JButton prevMonth;
    private JButton nextMonth;
    private JLabel monthLabel;
    private Calendar theCalendar;
    private boolean enforceFutureDate = true;

    public DateSelectDialog() {
        this(false);
    }

    public DateSelectDialog(boolean canSelectPreviousDate) {
        super(new NavBar());
        this.enforceFutureDate = !canSelectPreviousDate;
        NavBar nav = this.getNavBar();
        nav.addLeft((Component)nav.getCancelButton());
        nav.addRight((Component)nav.getOkButton());
        nav.setText(Internationalization.getLiteralFor((String)"SELECT_DATE"));
        this.theCalendar = new GregorianCalendar();
        this.theCalendar.setTimeInMillis(System.currentTimeMillis());
        this.setComponent(this.setupPanel());
        this.refreshButtons();
    }

    public boolean go(Date currentDate) {
        this.theDate = currentDate == null ? DateTimeUtils.getThreeMonthsAgo() : currentDate;
        this.theCalendar.setTimeInMillis(this.theDate.getTime());
        this.displayDate();
        this.refreshButtons();
        return this.start();
    }

    private JPanel setupPanel() {
        JPanel date = new JPanel();
        date.setPreferredSize(new Dimension(600, 250));
        date.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(15, 6), 5, 0));
        date.setBorder(new TitledBorder(Internationalization.getLiteralFor((String)"DATE") + ": "));
        this.dateLabel = new JLabel();
        this.dateLabel.setFont(OrderMateTheme.getLargeFont());
        date.add((Component)this.dateLabel, new Rectangle(0, 0, 7, 4));
        this.prevDay = new JButton(IconLoader.get((String)"/waitermate/images/leftarrow.png"));
        this.prevDay.addActionListener(this);
        date.add((Component)this.prevDay, new Rectangle(7, 0, 3, 2));
        this.dayLabel = new JLabel(Internationalization.getLiteralFor((String)"DAY"));
        this.dayLabel.setFont(OrderMateTheme.getMediumFont());
        date.add((Component)this.dayLabel, new Rectangle(10, 0, 2, 2));
        this.nextDay = new JButton(IconLoader.get((String)"/waitermate/images/rightarrow.png"));
        this.nextDay.addActionListener(this);
        date.add((Component)this.nextDay, new Rectangle(12, 0, 3, 2));
        this.prevWeek = new JButton(IconLoader.get((String)"/waitermate/images/leftarrow.png"));
        this.prevWeek.addActionListener(this);
        date.add((Component)this.prevWeek, new Rectangle(7, 2, 3, 2));
        this.weekLabel = new JLabel(Internationalization.getLiteralFor((String)"WEEK"));
        this.weekLabel.setFont(OrderMateTheme.getMediumFont());
        date.add((Component)this.weekLabel, new Rectangle(10, 2, 2, 2));
        this.nextWeek = new JButton(IconLoader.get((String)"/waitermate/images/rightarrow.png"));
        this.nextWeek.addActionListener(this);
        date.add((Component)this.nextWeek, new Rectangle(12, 2, 3, 2));
        this.prevMonth = new JButton(IconLoader.get((String)"/waitermate/images/leftarrow.png"));
        this.prevMonth.addActionListener(this);
        this.prevMonth.setName("previousMonthButton");
        date.add((Component)this.prevMonth, new Rectangle(7, 4, 3, 2));
        this.monthLabel = new JLabel(Internationalization.getLiteralFor((String)"MONTH"));
        this.monthLabel.setFont(OrderMateTheme.getMediumFont());
        date.add((Component)this.monthLabel, new Rectangle(10, 4, 2, 2));
        this.nextMonth = new JButton(IconLoader.get((String)"/waitermate/images/rightarrow.png"));
        this.nextMonth.setName("nextMonthButton");
        this.nextMonth.addActionListener(this);
        date.add((Component)this.nextMonth, new Rectangle(12, 4, 3, 2));
        return date;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.prevDay) {
            this.theCalendar.add(5, -1);
            this.displayDate();
        } else if (e.getSource() == this.nextDay) {
            this.theCalendar.add(5, 1);
            this.displayDate();
        } else if (e.getSource() == this.prevMonth) {
            this.theCalendar.add(2, -1);
            if (this.enforceFutureDate && this.theCalendar.getTime().before(new Date(System.currentTimeMillis()))) {
                this.theCalendar.setTime(new Date(System.currentTimeMillis()));
            }
            this.displayDate();
        } else if (e.getSource() == this.nextMonth) {
            this.theCalendar.add(2, 1);
            this.displayDate();
        } else if (e.getSource() == this.prevWeek) {
            this.theCalendar.add(6, -7);
            if (this.enforceFutureDate && this.theCalendar.getTime().before(new Date(System.currentTimeMillis()))) {
                this.theCalendar.setTime(new Date(System.currentTimeMillis()));
            }
            this.displayDate();
        } else if (e.getSource() == this.nextWeek) {
            this.theCalendar.add(6, 7);
            if (this.enforceFutureDate && this.theCalendar.getTime().before(new Date(System.currentTimeMillis()))) {
                this.theCalendar.setTime(new Date(System.currentTimeMillis()));
            }
            this.displayDate();
        }
        this.refreshButtons();
    }

    private void displayDate() {
        this.dateLabel.setText(DateTimeUtils.getLongFormat().format(this.theCalendar.getTime()));
    }

    public Date getNewDate() {
        return this.theCalendar.getTime();
    }

    public void refreshButtons() {
        GregorianCalendar systemDate = new GregorianCalendar();
        systemDate.setTime(new Date(System.currentTimeMillis()));
        if (!this.enforceFutureDate) {
            return;
        }
        boolean enable = false;
        enable = this.theCalendar.get(1) > systemDate.get(1) ? true : this.theCalendar.get(6) > systemDate.get(6) && this.theCalendar.get(1) >= systemDate.get(1);
        this.prevDay.setEnabled(enable);
        this.prevMonth.setEnabled(enable);
        this.prevWeek.setEnabled(enable);
    }
}

