/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.tables.PhysicalTable;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.guikit.dialogs.Dialogs;

public class OnlineOrderingGuiPanel
extends JPanel
implements ActionListener {
    private static final String PATH = "tests/ordermate/jaxb/exporter/";
    private static final String[] TYPES = new String[]{"Default", "KIOSK_TAKEAWAY", "KIOSK_TABLE", "ONLINE_TABLE"};
    private JButton simpleOrderButton;
    private JButton withPaymentButton;
    private JButton complexOrderButton;
    private JButton overchargeOrderButton;
    private JButton underchargeOrderButton;
    private JButton simpleSaleWithDateDueButton;
    private JLabel feedbackLabel;
    private JPanel paidOverwritePanel;
    private JRadioButton chkPaid;
    private JRadioButton chkUnpaid;
    private JCheckBox deliveryCheck;
    private JComboBox typeCombo;

    public OnlineOrderingGuiPanel() {
        this.setupComponents();
        this.setName("Online");
    }

    private void setupComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.simpleOrderButton = new JButton("Fire Simple Order");
        this.withPaymentButton = new JButton("Fire Order With Payments");
        this.complexOrderButton = new JButton("Fire Complex Order");
        this.overchargeOrderButton = new JButton("Fire Overcharge Order");
        this.underchargeOrderButton = new JButton("Fire Undercharge Order");
        this.simpleSaleWithDateDueButton = new JButton("Fire Due Date Order");
        this.simpleOrderButton.addActionListener(this);
        this.withPaymentButton.addActionListener(this);
        this.complexOrderButton.addActionListener(this);
        this.overchargeOrderButton.addActionListener(this);
        this.underchargeOrderButton.addActionListener(this);
        this.simpleSaleWithDateDueButton.addActionListener(this);
        this.add(this.simpleOrderButton);
        this.add(this.withPaymentButton);
        this.add(this.complexOrderButton);
        this.add(this.overchargeOrderButton);
        this.add(this.underchargeOrderButton);
        this.add(this.simpleSaleWithDateDueButton);
        this.add(this.getPaymentStatusOverwritePanel());
        this.typeCombo = new JComboBox<String>(TYPES);
        this.add(this.typeCombo);
        this.add(Box.createVerticalGlue());
        this.deliveryCheck = new JCheckBox("Delivery");
        this.add(this.deliveryCheck);
        this.feedbackLabel = new JLabel();
        this.add(this.feedbackLabel);
    }

    private void doOrder(OnlineOrderFile orderFile) {
        File file = new File(PATH + orderFile.fileName);
        OrderMate.LOG.info("Writing from:" + file);
        if (file.exists()) {
            this.feedbackLabel.setForeground(OrderMateTheme.getDefaultTextColor());
            this.feedbackLabel.setText("Issuing order");
            String path = OnlineIntegrationConfig.getDefaultInstance().getFileWatcherPath();
            OrderMate.LOG.info("Writing to:" + path + File.separator + orderFile.fileName);
            StringBuilder SB = null;
            try {
                PhysicalTable logTable;
                String table;
                FileReader fin = new FileReader(file);
                BufferedReader reader = new BufferedReader(fin);
                String line = reader.readLine();
                SB = new StringBuilder();
                String type = (String)this.typeCombo.getSelectedItem();
                Long tableId = null;
                if (type.equals(TYPES[0])) {
                    type = null;
                } else if (!type.equals(TYPES[1]) && (type.equals(TYPES[2]) || type.equals(TYPES[3])) && !StringUtils.isEmpty((String)(table = Dialogs.getString((String)"Physical Table Name?"))) && (logTable = (PhysicalTable)PersistenceManager.getObject(PhysicalTable.class, (String)Query.select(PhysicalTable.class).equals(PhysicalTable.Properties.NAME, (Object)table).active(PhysicalTable.class).toString())) != null) {
                    tableId = logTable.getID();
                }
                String payments = null;
                if (OnlineOrderFile.Payments.equals((Object)orderFile)) {
                    payments = this.getPayments();
                }
                while (line != null) {
                    if (line.contains("orderDate=")) {
                        SB.append("orderDate=\"").append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date()) + "\"");
                    } else if (line.contains("delivery")) {
                        SB.append("delivery=\"").append(this.deliveryCheck.isSelected()).append("\"\r\n");
                    } else if (line.contains("isPaid=") && (this.chkPaid.isSelected() || this.chkUnpaid.isSelected())) {
                        if (this.chkPaid.isSelected()) {
                            SB.append("isPaid=\"true\"");
                        } else {
                            SB.append("isPaid=\"false\"");
                        }
                    } else if (type != null && line.contains("extHRef=")) {
                        SB.append(line);
                        SB.append("\r\naccountType='").append(type).append("'\r\n");
                        if (tableId != null) {
                            SB.append("extWebTableID='").append(tableId).append("'\r\n");
                        }
                    } else if (payments != null && line.endsWith("<payment/>")) {
                        SB.append(payments);
                    } else {
                        SB.append(line);
                    }
                    SB.append("\n");
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (IOException ex) {
                this.feedbackLabel.setText("Problem reading:" + orderFile.fileName);
                this.feedbackLabel.setForeground(Color.RED);
            }
            if (SB != null) {
                try {
                    FileWriter writer = new FileWriter(new File(path + File.separator + orderFile.fileName));
                    writer.write(SB.toString());
                    writer.flush();
                    writer.close();
                }
                catch (IOException ex) {
                    this.feedbackLabel.setText("Problem writing:" + orderFile.fileName);
                    this.feedbackLabel.setForeground(Color.ORANGE);
                }
                this.feedbackLabel.setText("Issued online order");
                this.feedbackLabel.setForeground(Color.GREEN);
            }
        } else {
            this.feedbackLabel.setForeground(Color.RED);
            this.feedbackLabel.setText("This option is not available.");
        }
    }

    private JPanel getPaymentStatusOverwritePanel() {
        if (this.paidOverwritePanel == null) {
            this.paidOverwritePanel = new JPanel();
            this.paidOverwritePanel.setLayout(new BoxLayout(this.paidOverwritePanel, 1));
            JLabel label = new JLabel("Overwrite the payment status from the XML file as:");
            ButtonGroup group = new ButtonGroup();
            if (this.chkPaid == null) {
                this.chkPaid = new JRadioButton("Order 'paid'");
                this.chkPaid.addActionListener(this);
                this.chkUnpaid = new JRadioButton("Order 'not paid'");
                this.chkUnpaid.addActionListener(this);
                group.add(this.chkPaid);
                group.add(this.chkUnpaid);
            }
            this.paidOverwritePanel.add(label);
            this.paidOverwritePanel.add(this.chkPaid);
            this.paidOverwritePanel.add(this.chkUnpaid);
        }
        return this.paidOverwritePanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.simpleOrderButton) {
            this.doOrder(OnlineOrderFile.Simple);
        } else if (e.getSource() == this.withPaymentButton) {
            this.doOrder(OnlineOrderFile.Payments);
        } else if (e.getSource() == this.complexOrderButton) {
            this.doOrder(OnlineOrderFile.Complex);
        } else if (e.getSource() == this.overchargeOrderButton) {
            this.doOrder(OnlineOrderFile.Overcharge);
        } else if (e.getSource() == this.underchargeOrderButton) {
            this.doOrder(OnlineOrderFile.Undercharge);
        } else if (e.getSource() == this.simpleSaleWithDateDueButton) {
            this.doOrder(OnlineOrderFile.Dated);
        }
    }

    private String getPayments() {
        StringBuilder SB = new StringBuilder();
        boolean done = false;
        while (!done) {
            Price price = null;
            while (price == null) {
                double input = Dialogs.getPriceDouble((String)"Please choose the amount to pay ");
                if (input == Double.MIN_VALUE) {
                    done = true;
                    price = Price.ZERO_DOLLAR;
                    continue;
                }
                try {
                    price = new Price(input, 0.01);
                }
                catch (Exception ex) {
                    OrderMate.LOG.info("Cannot parse price:", (Throwable)ex);
                    JOptionPane.showMessageDialog(this, input + " is an invalid price");
                }
            }
            if (done) continue;
            List drawers = PersistenceManager.getObjectList(CashDrawer.class, (String)Query.select(CashDrawer.class).toString());
            CashDrawer cd = (CashDrawer)Dialogs.displaySelectionDialog((String)"Choose your cashdrawer (cancel for none)", (List)drawers);
            List units = FinanceUnit.getAllUnits();
            FinanceUnit funit = (FinanceUnit)Dialogs.displaySelectionDialog((String)"Choose your Payment Type (cancel for none)", (List)units);
            SB.append("<payment amount=\"").append(price.toString(false)).append("\" ");
            if (cd != null) {
                SB.append("cashdrawerName=\"").append(cd.getLabel()).append("\" ");
            }
            if (funit != null) {
                SB.append("paymentType=\"").append(funit.getLabel()).append("\" ");
            }
            SB.append("/>");
        }
        return SB.toString();
    }

    public static enum OnlineOrderFile {
        Simple("simpleSale.xml"),
        Complex("standardTestAccount.xml"),
        Overcharge("simpleOverchargeSale.xml"),
        Undercharge("simpleUnderchargeSale.xml"),
        Dated("simpleSaleWithDateDue.xml"),
        Payments("simpleSalePayments.xml"),
        Custom("");

        private final String fileName;

        private OnlineOrderFile(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

