/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ordermate.database.Lockable;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import waitermate.LoginManager;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.PopupWindow;

public class UnlockDialog
extends PopupWindow
implements ActionListener {
    private JLabel prompt;
    private Lockable currentLocked;
    private StandardSecurityDecorator unlockButton;
    private JButton unlockUnprivileged;
    private boolean unlocked = false;

    public UnlockDialog() {
        super(new NavBar());
        NavBar nav = this.getNavBar();
        JButton unlock = nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/lock.png"), Internationalization.getLiteralFor((String)"UNLOCK"), Internationalization.getLiteralFor((String)"UNLOCK_ACCOUNTS"));
        unlock.addActionListener(this);
        this.unlockButton = new StandardSecurityDecorator((JComponent)unlock, AllPermissions.UNLOCK_ACCOUNTS);
        nav.addRight((Component)this.unlockButton);
        this.unlockUnprivileged = nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/lock.png"), Internationalization.getLiteralFor((String)"UNLOCK"), Internationalization.getLiteralFor((String)"UNLOCK_ACCOUNTS"));
        this.unlockUnprivileged.addActionListener(this);
        nav.addRight((Component)this.unlockUnprivileged);
        nav.addRight((Component)nav.getOkButton());
        this.prompt = new JLabel();
    }

    public boolean display(Lockable toDisplay, String name) {
        this.unlocked = false;
        User user = toDisplay.getUser();
        this.setupPrompt(user, name);
        if (user == null) {
            this.unlockButton.setVisible(false);
            this.unlockUnprivileged.setVisible(false);
        } else if (user.equals((Object)LoginManager.getInstance().getUser())) {
            this.unlockButton.setVisible(false);
            this.unlockUnprivileged.setVisible(true);
        } else {
            this.unlockButton.setVisible(true);
            this.unlockUnprivileged.setVisible(false);
        }
        this.currentLocked = toDisplay;
        this.start();
        return this.unlocked;
    }

    public void displayLockInfo(Lockable toDisplay, String name) {
        User user = toDisplay.getUser();
        this.setupPrompt(user, name);
        this.unlockButton.setVisible(false);
        this.unlockUnprivileged.setVisible(false);
        this.start();
    }

    private void setupPrompt(User user, String accountName) {
        if (user != null) {
            this.prompt.setText(accountName + " " + Internationalization.getLiteralFor((String)"IS_CURRENTLY_IN_USE_BY") + " " + user.getName());
        } else {
            this.prompt.setText(accountName + " " + Internationalization.getLiteralFor((String)"IS_NOT_CURRENTLY_LOCKED"));
        }
        this.setComponent(this.prompt);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.unlockButton.getDecorateComponent() || e.getSource() == this.unlockUnprivileged) {
            this.currentLocked.unlock();
            this.unlocked = true;
            TerminalEventLog.logUnlockLockable((Lockable)this.currentLocked, (User)LoginManager.getInstance().getUser(), (Terminal)Terminal.getLocalHost());
            this.stop();
        }
    }
}

