/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.dialogs;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.finance.Shift;
import ordermate.database.finance.Skim;
import ordermate.database.finance.SkimTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.users.AllPermissions;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.TextScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.PopupWindow;

public class ViewSkimsDialog
extends PopupWindow
implements ActionListener {
    private JButton printButton;
    private TextScrollPaneModel text;
    private Shift shift;
    public final Signal printSignal = Signals.createSignal();

    public ViewSkimsDialog() {
        super(false);
        NavBar nav = this.getNavBar();
        JButton print = nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/print.png"), Internationalization.getLiteralFor((String)"PRINT"), "Print");
        print.addActionListener(this);
        this.printButton = print;
        nav.addRight((Component)new StandardSecurityDecorator((JComponent)this.printButton, AllPermissions.SKIMS));
        this.text = new TextScrollPaneModel(15);
        CustomScrollPane pane = new CustomScrollPane((CustomScrollPaneModel)this.text);
        this.getNavBar().removeLeft((Component)this.getNavBar().getCancelButton());
        nav.addRight((Component)nav.getOkButton());
        JPanel mainArea = new JPanel(new GridLayout(1, 1));
        mainArea.setPreferredSize(new Dimension(250, 350));
        mainArea.add((Component)pane);
        this.setComponent(mainArea);
    }

    public boolean display(Shift theShift, Terminal theTerminal) {
        if (theShift == null || theTerminal == null) {
            return false;
        }
        List cashDrawers = theTerminal.getAvailableCashDrawers(LoginManager.getInstance().getUser());
        if (cashDrawers == null || cashDrawers.size() == 0) {
            return false;
        }
        this.text.clear();
        this.shift = theShift;
        boolean ok = true;
        this.setText(Internationalization.getLiteralFor((String)"TERMINAL_SKIMS_FOR_SHIFT") + " " + this.shift.getName());
        Iterator it = cashDrawers.iterator();
        if (it.hasNext()) {
            CashDrawer currentDrawer = (CashDrawer)it.next();
            List skims = Skim.getSkims((Shift)this.shift, (CashDrawer)currentDrawer);
            if (skims != null && skims.size() > 0) {
                this.text.addLine("<html><font color=\"BLUE\">" + Internationalization.getLiteralFor((String)"CASHDRAWER") + ": " + currentDrawer.getLabel() + "</html");
                this.text.addLine("");
                for (Skim currentSkim : skims) {
                    this.text.addLine("<html><font color=\"RED\">" + Internationalization.getLiteralFor((String)"SKIM") + " " + currentSkim.getCreationTimeAsString() + "</html>");
                    this.text.addLine(Internationalization.getLiteralFor((String)"PERFORMED_BY") + " " + currentSkim.getUser());
                    this.text.addLine("");
                    List transactions = currentSkim.getActiveTransactions();
                    for (SkimTransaction currentTrans : transactions) {
                        this.text.addLine("(" + currentTrans.getFinanceUnit().getType() + ") " + currentTrans.getFinanceUnit().getLabel() + " " + currentTrans.getAmount());
                    }
                    this.text.addLine("");
                    this.text.addLine(Internationalization.getLiteralFor((String)"TOTAL") + currentSkim.getTotal());
                    this.text.addLine("");
                }
                if (ok) {
                    this.start();
                    return ok;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.printButton) {
            this.printSignal.emit();
            this.stop();
        }
    }
}

