/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.UIManager;
import ordermate.database.finance.transactions.PreauthTransaction;
import ordermate.database.finance.transactions.PreauthTransactionHelper;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.users.AllPermissions;
import ordermate.gui.button.CustomButton;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.renderer.DisplayableRenderer;

public class BarTabRenderer
extends DisplayableRenderer {
    private static final String UNKNOWN_BAR_TAB_VENDOR = "Unknown";

    public JComponent createComponent() {
        JComponent component = (JComponent)super.createComponent();
        StandardSecurityDecorator decorator = new StandardSecurityDecorator(component, AllPermissions.ACCESS_BARTABS);
        return decorator;
    }

    public void setupComponent(Component component, Object value, int index) {
        PreauthTransaction txn;
        CustomButton wrapped = (CustomButton)((StandardSecurityDecorator)component).getDecorateComponent();
        super.setupComponent((Component)wrapped, value, index);
        wrapped.setForeground(null);
        StringBuilder SB = new StringBuilder("<html><span style=\"font-size:large;\"><b>");
        BarTabAccount account = (BarTabAccount)value;
        Price due = account.getSavedTotal().subtract(account.getPaid());
        SB.append(account.getLabel());
        SB.append("</b> : ");
        SB.append(due);
        SB.append("</span><br>Created: ");
        SB.append(DateTimeUtils.formatTimeForDisplay((Date)account.getCreationDateTime()));
        SB.append("<br>Limit: ");
        SB.append(account.getCreditLimit());
        SB.append(", Remaining: ");
        SB.append(account.getCreditLimit().subtract(due));
        if (account.getSource() != null && !account.getSource().isEmpty()) {
            BarTabsConfiguration barTabConfig = BarTabsConfiguration.getBarTabConfigForVendorId((String)account.getSource());
            if (barTabConfig != null) {
                SB.append("<br>").append(barTabConfig.getName());
            } else {
                SB.append("<br>").append(UNKNOWN_BAR_TAB_VENDOR);
            }
            if (account.getExtID() != null && !account.getExtID().isEmpty()) {
                SB.append(": ").append(account.getExtID());
            }
        }
        if ((txn = (PreauthTransaction)PersistenceManager.getObject(PreauthTransaction.class, (String)PreauthTransaction.getExisting((Account)account).toString())) != null) {
            SB.append("<br>Preauth: ").append(HtmlUtils.colour((String)PreauthTransactionHelper.getInstance().getTotalPreAuth(txn).toString(), (String)"green"));
        }
        SB.append("</html>;");
        wrapped.setText(SB.toString());
        if (wrapped.getForeground() == null) {
            Color color = UIManager.getColor("Button.foreground");
            wrapped.setForeground(color);
        }
    }
}

