/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.PhoneAccount;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.Renderer;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DeliveryAccountItemRenderer
implements Renderer {
    public final Signal account = Signals.createSignal(Account.class, (String)"selectedAccount");
    public final Signal delete = Signals.createSignal(Account.class, (String)"selectedAccount");

    public void gotAccountPressed(Displayable it) {
        this.account.emit((Object)it);
    }

    public void gotDeletePressed(Displayable it) {
        this.delete.emit((Object)it);
    }

    public Component createComponent() {
        ListedDeliveryAccountPanel panel = new ListedDeliveryAccountPanel();
        panel.accountPressed.connect((Object)this, "gotAccountPressed");
        panel.deletePressed.connect((Object)this, "gotDeletePressed");
        return panel;
    }

    public void setupComponent(Component component, Object object, int index) {
        ListedDeliveryAccountPanel panel = (ListedDeliveryAccountPanel)component;
        panel.setAccount((PhoneAccount)object);
    }

    private static class ListedDeliveryAccountPanel
    extends JPanel
    implements ActionListener {
        private static final Insets margin = new Insets(10, 6, 2, 2);
        public Signal<Displayable, ?, ?, ?, ?> deletePressed = Signals.createSignal(Displayable.class, (String)"theAccount");
        public Signal accountPressed = Signals.createSignal(Displayable.class, (String)"theAccount");
        private PhoneAccount item;
        private CustomButton itemButton;
        private CustomButton deleteButton;
        private JLabel priceLabel;

        public ListedDeliveryAccountPanel() {
            this.setLayout((LayoutManager)new GraphPaperLayout(21, 1));
            this.itemButton = new CustomButton();
            this.itemButton.setHorizontalAlignment(2);
            this.itemButton.setMargin(margin);
            this.priceLabel = new JLabel();
            this.deleteButton = new CustomButton();
            this.deleteButton.setText("");
            this.deleteButton.setIcon((Icon)IconLoader.get((String)"/waitermate/images/delete.png"));
            this.add((Component)this.itemButton, new Rectangle(0, 0, 15, 1));
            this.add((Component)this.priceLabel, new Rectangle(15, 0, 2, 1));
            this.add((Component)this.deleteButton, new Rectangle(17, 0, 4, 1));
            this.deleteButton.addActionListener((ActionListener)this);
            this.itemButton.addActionListener((ActionListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.deleteButton) {
                this.deletePressed.emit((Object)this.item);
            } else if (source == this.itemButton) {
                this.accountPressed.emit((Object)this.item);
            }
        }

        private void refreshValues() {
            this.itemButton.setText(this.getAccountText());
            this.priceLabel.setText(this.item.getTotal().toString());
            if (this.item.isDelivered() || this.item.getDelivery().getDriver().getDriverTracking() != null) {
                this.deleteButton.setEnabled(false);
            }
        }

        public void setAccount(PhoneAccount theAccount) {
            this.item = theAccount;
            this.refreshValues();
        }

        private String getAccountText() {
            Customer customer = this.item.getCustomer();
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html>");
            buffer.append(this.item.getLabel());
            buffer.append("<br>");
            boolean newline = false;
            newline |= this.appendIfNotNull(buffer, customer.getRoomAptNumber(), " /");
            newline |= this.appendIfNotNull(buffer, customer.getHouseNumber());
            newline |= this.appendIfNotNull(buffer, customer.getStreetName());
            if (newline |= this.appendIfNotNull(buffer, customer.getStreetType())) {
                buffer.append("<br>");
            }
            newline = false;
            newline |= this.appendIfNotNull(buffer, customer.getSuburb());
            newline |= this.appendIfNotNull(buffer, customer.getPostcode());
            if (newline |= this.appendIfNotNull(buffer, customer.getState())) {
                buffer.append("<br>");
            }
            buffer.append("</html>");
            return buffer.toString();
        }

        private boolean appendIfNotNull(StringBuffer buffer, String value) {
            return this.appendIfNotNull(buffer, value, null);
        }

        private boolean appendIfNotNull(StringBuffer buffer, String value, String suffix) {
            boolean append;
            boolean bl = append = value != null && !value.equals("");
            if (append) {
                buffer.append(value);
                if (suffix != null) {
                    buffer.append(suffix);
                }
                buffer.append(" ");
            }
            return append;
        }
    }
}

