/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.accountitems;

import au.com.ordermate.guicore.NameDecorator;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.Course;
import ordermate.database.misc.SeatsMode;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.SellableWrapperFactory;
import ordermate.gui.modify.AWTInterceptor;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.accountitems.DefaultItemRenderer;

public class CourseItemsPanel
extends JPanel
implements ActionListener {
    private static final Color TAB_WITH_ITEMS_COLOR = new Color(255, 216, 144);
    private static final Color TAB_NO_ITEMS_COLOR = null;
    private RendererScrollPaneModel<Sellable> currentItemsModel;
    private CustomScrollPane itemsPanel;
    private NameDecorator nameDecorator;
    private JPanel customPanel;
    private JTabbedPane courseTabs;
    private JTabbedPane seatTabs;
    private String message = "";
    private int lastSelectedTab = -2;
    private FilterListener listener;
    public Signal<?, ?, ?, ?, ?> seatTabChanged = Signals.createSignal();
    public Signal<Boolean, ?, ?, ?, ?> holdCourseButtonSignal = Signals.createSignal(Boolean.class, (String)"pressed");
    private List<Sellable> items = new ArrayList<Sellable>();
    private List<Sellable> filteredItems = new ArrayList<Sellable>();
    private Color foreGroundColor = null;
    private Color backgroundColor = null;
    private Color PURPLE = new Color(137, 107, 172);
    private int numSeats = 1;
    private int numColumns = 1;
    private boolean showCourses = true;
    private boolean updatingTabs = false;
    private final Dimension dim = new Dimension(1, 1);
    private JToggleButton holdCourseButton = null;
    private JPanel holdCourseButtonPanel = null;

    public CourseItemsPanel() {
        this(new DefaultItemRenderer());
    }

    public CourseItemsPanel(Renderer newRenderer) {
        this.listener = new FilterListener();
        this.setLayout(new BorderLayout());
        this.initComponents(newRenderer);
    }

    public CourseItemsPanel(Renderer newRenderer, String newKeyPrefix) {
        this.listener = new FilterListener(newKeyPrefix);
        this.setLayout(new BorderLayout());
        this.initComponents(newRenderer);
    }

    private void initComponents(Renderer renderer) {
        this.setupItemsPanel(renderer);
        this.courseTabs = new JTabbedPane();
        this.courseTabs.setName("courseTabs");
        this.courseTabs.setFont(OrderMateTheme.getLargeFont());
        this.courseTabs.addChangeListener(this.listener);
        OrderMateTheme.setupTabbedPane((JTabbedPane)this.courseTabs);
        this.add((Component)this.courseTabs, "North");
        SeatsMode seatsMode = SystemProperty.getInstance().getSeatsMode();
        if (!SeatsMode.FineDining.equals((Object)seatsMode)) {
            this.seatTabs = new JTabbedPane(4);
            this.seatTabs.setName("seatTabs");
            this.seatTabs.setFont(OrderMateTheme.getLargeFont());
            this.seatTabs.addChangeListener(this.listener);
            OrderMateTheme.setupTabbedPane((JTabbedPane)this.seatTabs);
            this.add((Component)this.seatTabs, "East");
        }
        this.nameDecorator = new NameDecorator((JComponent)this.itemsPanel, "Secondcourse");
        this.add((Component)this.nameDecorator, "Center");
        this.customPanel = new JPanel(new BorderLayout());
        this.add((Component)this.customPanel, "South");
        this.addHoldCourseButton();
    }

    private void addHoldCourseButton() {
        this.holdCourseButtonPanel = new JPanel();
        this.holdCourseButton = new JToggleButton();
        this.holdCourseButton.setRolloverEnabled(false);
        this.foreGroundColor = this.holdCourseButton.getForeground();
        this.backgroundColor = this.holdCourseButton.getBackground();
        this.holdCourseButton.setName("holdCourseButton");
        this.holdCourseButton.setText(HtmlUtils.htmlCenter((String)Internationalization.getLiteralFor((String)"LAST_PRINTED")));
        this.holdCourseButton.setPreferredSize(new Dimension(this.holdCourseButton.getPreferredSize().width + 120, 50));
        this.holdCourseButton.addActionListener(this);
        this.holdCourseButtonPanel.setName("holdCourseButtonPanel");
        this.holdCourseButtonPanel.add((Component)this.holdCourseButton, Float.valueOf(1.0f));
        this.customPanel.add("North", this.holdCourseButtonPanel);
        this.setHoldCourseButtonColor();
    }

    public void setCourseHoldButtonVisible(boolean visible) {
        this.holdCourseButtonPanel.setVisible(visible);
        this.holdCourseButton.setVisible(true);
        this.setHoldCourseButtonColor();
    }

    public void setCustomComponent(JComponent someComponent) {
        this.customPanel.add((Component)someComponent, "Center");
    }

    private void setupItemsPanel(Renderer renderer) {
        this.currentItemsModel = new RendererScrollPaneModel(renderer);
        this.currentItemsModel.setColumns(this.numColumns);
        this.itemsPanel = new CustomScrollPane(this.currentItemsModel);
        this.itemsPanel.setName("itemsScroll");
        this.itemsPanel.setEmptyMessage(this.message);
    }

    private void setupCourses() {
        String[] courses = Account.getCourses();
        boolean needsRebuild = false;
        if (courses.length != this.courseTabs.getTabCount()) {
            needsRebuild = true;
        } else {
            for (int i = 0; i < courses.length; ++i) {
                if (courses[i].equals(this.courseTabs.getTitleAt(i))) continue;
                needsRebuild = true;
                break;
            }
        }
        if (needsRebuild) {
            this.doCoursesRebuild();
        }
    }

    private void doCoursesRebuild() {
        String[] courses = Account.getCourses();
        this.updatingTabs = true;
        this.courseTabs.removeAll();
        if (courses.length > 0 && this.showCourses) {
            for (int i = 0; i < courses.length; ++i) {
                this.courseTabs.addTab(courses[i], Box.createRigidArea(this.dim));
            }
        }
        this.courseTabs.setPreferredSize(null);
        this.updatingTabs = false;
    }

    private void setupSeats() {
        if (this.seatTabs != null && this.seatTabs.getTabCount() != this.numSeats) {
            this.updatingTabs = true;
            this.seatTabs.removeAll();
            this.seatTabs.add("All", Box.createGlue());
            for (int i = 0; i < this.numSeats - 1; ++i) {
                this.seatTabs.add(Integer.toString(i + 1), Box.createGlue());
            }
            this.seatTabs.setPreferredSize(null);
            this.updatingTabs = false;
        }
    }

    public void displayLastPage() {
        this.itemsPanel.displayLastPage();
    }

    public void setDefaultMessage(String aMessage) {
        this.message = aMessage;
    }

    protected void clearItems() {
        this.items.clear();
    }

    public void setItems(Collection<Sellable> yourItems) {
        this.items.clear();
        if (ExperimentalFeatureHelper.isWMShowComboItemsInOldWay()) {
            this.addCourseItemsV1(yourItems);
        } else {
            this.addCourseItemsV2(yourItems);
        }
        this.rebuildGui();
        this.resetTabColours();
        this.updateItems();
    }

    protected void addCourseItemsV1(Collection<Sellable> yourItems) {
        this.items.addAll(yourItems);
    }

    private void addCourseItemsV2(Collection<Sellable> yourItems) {
        SellableWrapperFactory sellableFactory = new SellableWrapperFactory();
        for (Sellable sellable : yourItems) {
            if (sellable.getSellingObject() instanceof SalesCombo) {
                SalesCombo combo = (SalesCombo)sellable.getSellingObject();
                if (!this.isComboItemsInSameCourse(combo)) {
                    List comboItems = combo.getSalesItems();
                    this.items.add(sellable);
                    for (SalesItem comboItem : comboItems) {
                        SalesLineItemWrapper comboSellable = sellableFactory.wrapItem((SalesLineItem)comboItem);
                        this.items.add((Sellable)comboSellable);
                    }
                    continue;
                }
                this.items.add(sellable);
                continue;
            }
            this.items.add(sellable);
        }
    }

    private boolean isComboItemsInSameCourse(SalesCombo combo) {
        List comboItems = combo.getSalesItems();
        if (comboItems == null || comboItems.isEmpty()) {
            return true;
        }
        int course = ((SalesItem)comboItems.get(0)).getCourse();
        for (SalesItem comboItem : comboItems) {
            if (comboItem.getCourse() == course) continue;
            return false;
        }
        combo.setCourse(course);
        return true;
    }

    public void setCurrentCourse(Course course) {
        if (this.showCourses) {
            int index = Course.getCourses().indexOf(course);
            for (int i = 0; i < this.courseTabs.getTabCount(); ++i) {
                this.courseTabs.setIconAt(i, index == i ? IconLoader.get((String)"/waitermate/images/ok32.png") : null);
            }
            this.courseTabs.validate();
            this.courseTabs.repaint();
        }
    }

    protected void resetTabColours() {
        for (int c = 0; c < this.courseTabs.getTabCount(); ++c) {
            OrderMateTheme.setTabColour((JTabbedPane)this.courseTabs, (int)c, (Color)TAB_NO_ITEMS_COLOR);
        }
        if (this.seatTabs != null) {
            for (int s = 0; s < this.seatTabs.getTabCount(); ++s) {
                OrderMateTheme.setTabColour((JTabbedPane)this.seatTabs, (int)s, (Color)TAB_NO_ITEMS_COLOR);
            }
        }
        for (Sellable item : this.items) {
            int course = item.getCourse();
            if (course >= this.courseTabs.getTabCount()) {
                course = this.courseTabs.getTabCount() - 1;
            }
            if (!this.showCourses) continue;
            OrderMateTheme.setTabColour((JTabbedPane)this.courseTabs, (int)course, (Color)TAB_WITH_ITEMS_COLOR);
        }
    }

    public List<Sellable> getItems() {
        return new ArrayList<Sellable>(this.items);
    }

    protected void rebuildGui() {
        int currentSeat = this.getCurrentSeat();
        int currentCourse = this.getCurrentCourse();
        this.setupCourses();
        this.setupSeats();
        this.setCourse(currentCourse);
        this.setSeat(currentSeat);
        this.validate();
        this.courseTabs.setPreferredSize(this.getIdealDimensionForCourseTabs());
        if (this.seatTabs != null) {
            this.seatTabs.setPreferredSize(new Dimension(this.seatTabs.getWidth() - this.seatTabs.getComponentAt(0).getWidth(), 10));
        }
        this.resetTabColours();
    }

    private Dimension getIdealDimensionForCourseTabs() {
        int currentCourseTabsHeight = this.courseTabs.getHeight();
        int courseTabsComponentHeight = this.courseTabs.getComponentAt(0).getHeight();
        if (currentCourseTabsHeight != 0 || courseTabsComponentHeight != 0) {
            return new Dimension(10, currentCourseTabsHeight - courseTabsComponentHeight);
        }
        return new Dimension(10, 48);
    }

    public void setNumSeats(int s) {
        if (this.numSeats != s + 1) {
            this.numSeats = s + 1;
            this.setupSeats();
        }
    }

    public void setShowCourses(boolean shouldShowcourses) {
        this.showCourses = shouldShowcourses;
        this.rebuildGui();
    }

    public void setColumns(int newNumColumns) {
        this.numColumns = newNumColumns;
        this.itemsPanel.setColumns(this.numColumns);
    }

    public void setRenderer(Renderer newRenderer) {
        this.currentItemsModel.setRenderer(newRenderer);
    }

    public void redrawItems() {
        this.currentItemsModel.refresh();
    }

    public int getNumSeats() {
        return this.numSeats - 1;
    }

    public Renderer getRenderer() {
        return this.currentItemsModel.getRenderer();
    }

    public int getCurrentCourse() {
        return this.courseTabs.getSelectedIndex();
    }

    public boolean usesSeatTabs() {
        return this.seatTabs != null && this.numSeats > 2 && Terminal.getLocalHost().getSeatNums();
    }

    public int getCurrentSeat() {
        if (this.usesSeatTabs()) {
            int seat = this.seatTabs.getSelectedIndex();
            if (seat < 0) {
                seat = 0;
            }
            return seat;
        }
        return 0;
    }

    public void setSeat(int seatNumber) {
        if (this.usesSeatTabs()) {
            int selectedSeat = seatNumber >= this.numSeats ? this.numSeats - 1 : seatNumber;
            this.seatTabs.setSelectedIndex(selectedSeat);
        }
    }

    protected void updateItems() {
        int course = this.courseTabs.getSelectedIndex();
        int seat = 0;
        if (this.seatTabs != null) {
            seat = this.seatTabs.getSelectedIndex();
            for (int s = 0; s < this.seatTabs.getTabCount(); ++s) {
                OrderMateTheme.setTabColour((JTabbedPane)this.seatTabs, (int)s, (Color)TAB_NO_ITEMS_COLOR);
            }
        }
        this.filteredItems.clear();
        for (Sellable item : this.items) {
            if (item.getCourse() != course && this.courseTabs.isVisible()) continue;
            this.updateSeatTabColours(item);
            if (item.getSeat() != seat && this.usesSeatTabs()) continue;
            this.filteredItems.add(item);
        }
        this.currentItemsModel.setObjects(this.filteredItems);
    }

    private void updateSeatTabColours(Sellable item) {
        if (!this.updatingTabs && this.seatTabs != null && item.getCourse() == this.getCurrentCourse() && this.seatTabs.getTabCount() > 0) {
            int seat = item.getSeat();
            if (!this.usesSeatTabs() || seat >= this.numSeats) {
                seat = 0;
            }
            OrderMateTheme.setTabColour((JTabbedPane)this.seatTabs, (int)seat, (Color)TAB_WITH_ITEMS_COLOR);
        }
    }

    public void setCourse(int courseNumber) {
        if (this.showCourses) {
            this.setupCourses();
            this.courseTabs.setSelectedIndex(courseNumber);
        }
    }

    void redraw() {
        this.invalidate();
        this.repaint();
    }

    public void updateCourseHoldButton(boolean coursePrintOnHold, Date lastPrintedTime) {
        String lastPrintedTimeString;
        StringBuilder sb = new StringBuilder();
        String holdCourse = "Hold Course";
        this.holdCourseButton.setSelected(coursePrintOnHold);
        sb.append("Hold Course");
        if (lastPrintedTime != null && !(lastPrintedTimeString = DateTimeUtils.computeElapsedTimeString((long)DateTimeUtils.getDifferenceInMillisecs((Date)lastPrintedTime, (Date)new Date()), (boolean)true)).isEmpty()) {
            sb.append(HtmlUtils.newline((int)1));
            sb.append(Internationalization.getLiteralFor((String)"LAST_PRINTED"));
            sb.append(lastPrintedTimeString);
            sb.append(" ");
            sb.append(Internationalization.getLiteralFor((String)"AGO"));
        }
        this.holdCourseButton.setText(HtmlUtils.htmlCenter((String)sb.toString()));
        this.setHoldCourseButtonColor();
    }

    private void setHoldCourseButtonColor() {
        if (this.holdCourseButton.isSelected()) {
            this.holdCourseButton.setBackground(this.PURPLE);
            this.holdCourseButton.setForeground(Color.WHITE);
        } else {
            this.holdCourseButton.setForeground(this.foreGroundColor);
            this.holdCourseButton.setBackground(this.backgroundColor);
        }
        this.holdCourseButton.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.holdCourseButton)) {
            this.setHoldCourseButtonColor();
            this.holdCourseButtonSignal.emit((Object)this.holdCourseButton.isSelected());
        }
    }

    private class FilterListener
    implements ChangeListener {
        private final String noCourse = "nocourse";
        private String keyPrefix = "";

        public FilterListener() {
        }

        public FilterListener(String keyPrefixToUse) {
            if (keyPrefixToUse != null) {
                this.keyPrefix = keyPrefixToUse;
            }
        }

        @Override
        public void stateChanged(final ChangeEvent e) {
            if (SwingUtilities.isEventDispatchThread()) {
                String name = this.keyPrefix + this.getCourseNameString();
                CourseItemsPanel.this.nameDecorator.setKey(name);
                CourseItemsPanel.this.updateItems();
                CourseItemsPanel.this.seatTabChanged.emit();
                CourseItemsPanel.this.itemsPanel.setColumns(1);
                CourseItemsPanel.this.itemsPanel.setRowsPerPage(5);
                if (!"nocourse".equals(name)) {
                    AWTInterceptor.getInstance().eventDispatched((AWTEvent)new ContainerEvent(CourseItemsPanel.this, 300, (Component)CourseItemsPanel.this.nameDecorator));
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FilterListener.this.stateChanged(e);
                    }
                });
            }
        }

        private String getCourseNameString() {
            String[] courses;
            int courseNum = CourseItemsPanel.this.getCurrentCourse();
            if (courseNum >= 0 && courseNum < (courses = Course.getCourseNames()).length) {
                return courses[courseNum] + "course";
            }
            return "nocourse";
        }
    }
}

