/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.accountitems;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryWeightUnit;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesLineItemWrapper;
import ordermate.database.sales.Sellable;
import ordermate.database.sales.VoucherTransactionWrapper;
import ordermate.database.users.AllPermissions;
import ordermate.gui.button.CustomButton;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.services.sales.UpgradeableComboHelper;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.displayitems.accountitems.ItemIconGenerator;
import waitermate.gui.displayitems.accountitems.PanelCustomButton;
import waitermate.gui.displayitems.accountitems.saleslineitemrenderer.DefaultSalesLineItemRenderer;
import waitermate.gui.displayitems.accountitems.saleslineitemrenderer.SalesLineItemRenderer;
import waitermate.gui.displayitems.accountitems.saleslineitemrenderer.WeightedItemRenderer;

class ListedSalesItemPanel
extends JPanel
implements ActionListener {
    private static final SalesLineItemRenderer renderer = new DefaultSalesLineItemRenderer();
    private static final SalesLineItemRenderer weightedItemRenderer = new WeightedItemRenderer();
    public Signal<Sellable, ?, ?, ?, ?> quantityPressed = Signals.createSignal(Sellable.class, (String)"salesItem");
    public Signal<Sellable, ?, ?, ?, ?> itemPressed = Signals.createSignal(Sellable.class, (String)"salesItem");
    public Signal<Sellable, ?, ?, ?, ?> deletePressed = Signals.createSignal(Sellable.class, (String)"salesItem");
    public Signal<Sellable, ?, ?, ?, ?> upgradePressed = Signals.createSignal(Sellable.class, (String)"salesItem");
    protected Sellable item;
    private CustomButton<Sellable> quantityButton;
    protected PanelCustomButton<Sellable> itemButton;
    protected CustomButton<Sellable> upgradeButton;
    protected CustomButton<Sellable> genericIconButton;
    protected CustomButton<Sellable> deleteButton;
    protected StandardSecurityDecorator deleteDecorator;
    protected JLabel priceLabel;
    protected JLabel dollarLabel;
    private JLabel unroundedDollarLabel;
    private JLabel unroundedPriceLabel;
    private Component dollarSpace;
    private Component priceSpace;
    private static ExperimentalFeature displayUnroundedEF = ExperimentalFeature.find((String)"Display unrounded item price");
    private JPanel leftButtonHolder;

    public ListedSalesItemPanel(boolean deleteAllowed, boolean showSeats) {
        this.createPanel(deleteAllowed);
    }

    protected void createItemButton() {
        this.itemButton = new PanelCustomButton();
        this.itemButton.setName("itemButton");
        this.itemButton.addActionListener(this);
        this.itemButton.setHorizontalTextPosition(2);
        this.itemButton.setHorizontalAlignment(2);
        this.itemButton.putClientProperty("substancelaf.buttonopenSide", "LEFT");
        this.itemButton.setVerticalTextPosition(1);
    }

    protected void createPanel(boolean deleteAllowed) {
        this.setLayout((LayoutManager)new GraphPaperLayout(21, 1));
        this.add((Component)this.createLeftSidePanel(), new Rectangle(0, 0, 4, 1));
        this.createItemButton();
        this.unroundedPriceLabel = new JLabel("", 4);
        this.deleteButton = new CustomButton();
        this.deleteButton.addActionListener((ActionListener)this);
        this.deleteButton.setName("deleteItem");
        this.deleteButton.setIcon((Icon)IconLoader.get((String)"/waitermate/images/delete.png"));
        this.deleteDecorator = new StandardSecurityDecorator(this.deleteButton, AllPermissions.DELETE_ITEM);
        this.deleteDecorator.setSecurityOn(false);
        this.deleteDecorator.setName("deleteItemDec");
        this.add((Component)((Object)this.itemButton), new Rectangle(4, 0, 12, 1));
        this.dollarLabel = new JLabel();
        this.dollarLabel.setVerticalAlignment(1);
        this.dollarLabel.setAlignmentX(0.0f);
        JPanel dollarPricePanel = new JPanel();
        dollarPricePanel.setLayout(new BoxLayout(dollarPricePanel, 1));
        dollarPricePanel.add(this.dollarLabel);
        this.priceLabel = new JLabel();
        this.priceLabel.setName("itemPrice");
        this.priceLabel.setVerticalAlignment(1);
        this.priceLabel.setAlignmentX(1.0f);
        JPanel pricePanel = new JPanel();
        pricePanel.setLayout(new BoxLayout(pricePanel, 1));
        pricePanel.add(this.priceLabel);
        if (displayUnroundedEF != null && displayUnroundedEF.getBooleanValue(Boolean.FALSE).booleanValue()) {
            this.dollarSpace = Box.createVerticalStrut(5);
            this.priceSpace = Box.createVerticalStrut(5);
            this.unroundedDollarLabel = new JLabel();
            this.unroundedDollarLabel.setVerticalAlignment(1);
            this.unroundedDollarLabel.setAlignmentX(0.0f);
            this.unroundedDollarLabel.setForeground(Color.GRAY);
            this.unroundedPriceLabel = new JLabel();
            this.unroundedPriceLabel.setVerticalAlignment(1);
            this.unroundedPriceLabel.setAlignmentX(1.0f);
            this.unroundedPriceLabel.setForeground(Color.GRAY);
            dollarPricePanel.add(this.dollarSpace);
            dollarPricePanel.add(this.unroundedDollarLabel);
            pricePanel.add(this.priceSpace);
            pricePanel.add(this.unroundedPriceLabel);
        }
        JPanel pricePanelHolder = new JPanel();
        pricePanelHolder.setLayout(new BoxLayout(pricePanelHolder, 0));
        pricePanelHolder.setBorder(new EmptyBorder(7, 7, 7, 7));
        pricePanelHolder.add(dollarPricePanel);
        pricePanelHolder.add(Box.createHorizontalGlue());
        pricePanelHolder.add(pricePanel);
        if (deleteAllowed) {
            this.add((Component)pricePanelHolder, new Rectangle(16, 0, 2, 1));
            this.add((Component)this.deleteDecorator, new Rectangle(18, 0, 3, 1));
        } else {
            this.add((Component)((Object)this.itemButton), new Rectangle(4, 0, 14, 1));
            this.add((Component)pricePanelHolder, new Rectangle(19, 0, 2, 1));
        }
    }

    protected JPanel createLeftSidePanel() {
        this.leftButtonHolder = new JPanel(new GridLayout(1, 2, 0, 0));
        this.quantityButton = new CustomButton();
        this.quantityButton.setName("itemQuantity");
        this.quantityButton.addActionListener((ActionListener)this);
        this.quantityButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"RIGHT");
        this.upgradeButton = new CustomButton();
        this.upgradeButton.addActionListener((ActionListener)this);
        this.upgradeButton.setText("Upgrade");
        this.upgradeButton.setIcon((Icon)IconLoader.get((String)"/waitermate/images/upgrade.png"));
        this.upgradeButton.setHorizontalTextPosition(0);
        this.upgradeButton.setVerticalTextPosition(3);
        this.genericIconButton = new CustomButton();
        this.genericIconButton.setText("");
        this.genericIconButton.setHorizontalTextPosition(0);
        this.genericIconButton.setVerticalTextPosition(3);
        return this.leftButtonHolder;
    }

    public void setItem(TriggerActivationContext context, Sellable newItem) {
        SalesItem salesItem;
        this.item = newItem;
        this.setItemEditable(true);
        this.leftButtonHolder.remove((Component)this.quantityButton);
        if (this.item.isQuantifiable()) {
            this.quantityButton.setData((Displayable)this.item);
            this.quantityButton.setName("itemQuantity");
            this.quantityButton.setText(this.getQuantityLabel());
            this.quantityButton.setEnabled(true);
            this.leftButtonHolder.add((Component)this.quantityButton);
        }
        if (this.item.hasGenericIcon()) {
            this.genericIconButton.setIcon((Icon)IconLoader.get((String)this.item.getGenericIcon()));
            this.leftButtonHolder.add((Component)this.genericIconButton);
        }
        if (this.item.isUpgradeable()) {
            this.leftButtonHolder.add((Component)this.upgradeButton);
            this.upgradeButton.setEnabled(true);
        }
        boolean isModifiable = this.item.isModifiable(LoginManager.getEventContext());
        List items = this.item.getSalesItems();
        boolean isWeighted = false;
        if (items.size() == 1) {
            boolean bl = isWeighted = ((SalesItem)this.item.getSalesItems().get(0)).getInventoryItemIfSingle() != null;
            if (isWeighted) {
                isWeighted = ((SalesItem)this.item.getSalesItems().get(0)).getInventoryItemIfSingle().getInventoryWeightUnit() != InventoryWeightUnit.NA;
            }
        }
        this.quantityButton.setEnabled(isModifiable && !isWeighted);
        this.leftButtonHolder.remove((Component)this.upgradeButton);
        this.leftButtonHolder.remove((Component)this.genericIconButton);
        if (this.item.isUpgradeable()) {
            this.upgradeButton.setData((Displayable)this.item);
            this.upgradeButton.setText("Upgrade");
        }
        if (this.item.hasGenericIcon()) {
            this.leftButtonHolder.add((Component)this.genericIconButton);
        }
        if (this.item instanceof SalesLineItemWrapper) {
            SalesLineItem salesLineItem = (SalesLineItem)this.item.getSellingObject();
            if (isModifiable && salesLineItem instanceof SalesItem && UpgradeableComboHelper.getInstance().isUpgradeable(context, salesLineItem)) {
                this.leftButtonHolder.add((Component)this.upgradeButton);
            }
            if (this.dollarLabel != null) {
                this.dollarLabel.setText(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
                this.priceLabel.setText(salesLineItem.getItemLevelPrice().toString(false));
            } else {
                this.priceLabel.setText(salesLineItem.getItemLevelPrice().toString(true));
            }
            if (displayUnroundedEF != null && displayUnroundedEF.getBooleanValue(Boolean.FALSE).booleanValue()) {
                this.checkUnroundedLabel(salesLineItem.getItemLevelPrice());
            }
        } else {
            this.priceLabel.setText(this.item.getItemLevelPrice().toString());
        }
        this.itemButton.setData(this.item);
        this.updateLabel();
        this.itemButton.setIcon(ItemIconGenerator.generateIcon(this.item));
        this.itemButton.setEnabled(isModifiable);
        if (this.deleteDecorator != null) {
            this.updateDeleteButtonState();
        }
        if (!ExperimentalFeatureHelper.isWMShowComboItemsInOldWay() && this.item.getSellingObject() instanceof SalesItem && (salesItem = (SalesItem)this.item.getSellingObject()).getParentCombo() != null) {
            isModifiable = false;
            this.setItemEditable(false);
        }
    }

    private void setItemEditable(boolean isEnabled) {
        this.quantityButton.setEnabled(isEnabled);
        this.upgradeButton.setEnabled(isEnabled);
        this.deleteDecorator.setEnabled(isEnabled);
        if (this.priceLabel != null) {
            this.priceLabel.setVisible(isEnabled);
        }
        if (this.dollarLabel != null) {
            this.dollarLabel.setVisible(isEnabled);
        }
    }

    private void checkUnroundedLabel(Price price) {
        BigDecimal roundedTwo = new BigDecimal(price.getOriginalRawValue());
        roundedTwo = roundedTwo.setScale(2, 4);
        BigDecimal roundedThree = new BigDecimal(price.getOriginalRawValue());
        BigDecimal rouningCheck = (roundedThree = roundedThree.setScale(3, 4)).subtract(roundedTwo);
        if (rouningCheck.compareTo(BigDecimal.ZERO) != 0) {
            this.unroundedDollarLabel.setText(Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            this.unroundedDollarLabel.setVisible(true);
            this.unroundedPriceLabel.setText(roundedThree.toString());
            this.unroundedPriceLabel.setVisible(true);
            this.dollarSpace.setVisible(true);
            this.priceSpace.setVisible(true);
        } else {
            this.unroundedDollarLabel.setVisible(false);
            this.unroundedPriceLabel.setVisible(false);
            this.dollarSpace.setVisible(false);
            this.priceSpace.setVisible(false);
        }
    }

    private void updateDeleteButtonState() {
        if (this.deleteButton == null) {
            return;
        }
        boolean paid = this.item.hasFinanceTransactions();
        this.deleteButton.setData((Displayable)this.item);
        this.deleteButton.setName("deleteItem");
        this.deleteButton.setText("");
        this.deleteButton.setIcon((Icon)IconLoader.get((String)"/waitermate/images/delete.png"));
        Account committedAccount = this.item.getAccount();
        if (committedAccount != null && !committedAccount.isOpen() && committedAccount.isDebtorSale()) {
            this.deleteDecorator.setEnabled(false);
        } else if (paid) {
            if (committedAccount.isOpen() || Terminal.getLocalHost().getAssignedCashDrawer(LoginManager.getInstance().getUser()) == null) {
                this.deleteDecorator.setEnabled(false);
            } else {
                this.deleteDecorator.setEnabled(true);
                this.deleteDecorator.setSecurityOn(true);
            }
        } else if (this.item.isQuantifiable()) {
            this.deleteDecorator.setEnabled(true);
            if (this.item.getSavedQuantity(true).notEquals(0)) {
                this.deleteDecorator.setSecurityOn(true);
            } else {
                this.deleteDecorator.setSecurityOn(false);
            }
        } else if (this.item.hasFinanceTransactions()) {
            this.deleteDecorator.setEnabled(false);
            this.deleteDecorator.setSecurityOn(true);
        } else {
            boolean canDelete = true;
            if (this.item instanceof VoucherTransactionWrapper) {
                GiftVoucherTransaction txn = (GiftVoucherTransaction)this.item.getSellingObject();
                canDelete = txn.isActive() && !txn.isConfirmed();
            }
            this.deleteDecorator.setEnabled(true);
            this.deleteDecorator.setSecurityOn(false);
        }
    }

    public StandardSecurityDecorator getDeleteSecurityDecorator() {
        return this.deleteDecorator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.quantityButton) {
            this.quantityPressed.emit((Object)this.item);
        } else if (source == this.itemButton) {
            this.itemPressed.emit((Object)this.item);
        } else if (source == this.deleteDecorator.getDecorateComponent()) {
            this.deletePressed.emit((Object)this.item);
        } else if (source == this.upgradeButton) {
            this.upgradePressed.emit((Object)this.item);
        } else if (source == this.genericIconButton) {
            // empty if block
        }
    }

    public void refreshValues() {
        this.quantityButton.setText(this.getQuantityLabel());
        this.updateLabel();
        this.priceLabel.setText(this.item.getItemLevelPrice().toString());
    }

    private void updateLabel() {
        SalesLineItemRenderer localRenderer = this.getRenderer();
        this.itemButton.setText(localRenderer.getHTMLWaitermateTitle(this.item));
        this.itemButton.setExtraText(localRenderer.getHTMLMiddleText(this.item), localRenderer.getHTMLBottomText(this.item));
    }

    private String getQuantityLabel() {
        InventoryItem soleItem;
        InventoryWeightUnit unit = InventoryWeightUnit.NA;
        List items = this.item.getSalesItems();
        if (items.size() == 1 && (soleItem = ((SalesItem)items.get(0)).getInventoryItemIfSingle()) != null) {
            unit = soleItem.getInventoryWeightUnit();
        }
        if (this.item.isQuantifiable()) {
            return HtmlUtils.html((String)InventoryWeightUnit.convertToString((InventoryWeightUnit)unit, (SalesQuantity)this.item.getQuantity()));
        }
        return "";
    }

    private SalesLineItemRenderer getRenderer() {
        InventoryItem iItem;
        SalesLineItem sellableItem;
        if (this.item instanceof SalesLineItemWrapper && this.item.getSellingObject() instanceof SalesLineItem && (sellableItem = (SalesLineItem)this.item.getSellingObject()) instanceof SalesItem && (iItem = ((SalesItem)sellableItem).getInventoryItemIfSingle()) != null && !InventoryWeightUnit.NA.equals((Object)iItem.getInventoryWeightUnit())) {
            return weightedItemRenderer;
        }
        return renderer;
    }
}

