/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.accountitems;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.button.CustomButton;

public class PanelCustomButton<T extends Displayable>
extends CustomButton<T> {
    private String innerNamePrefix;
    private JLabel title;
    private JLabel middle;
    private JPanel bottomPanel;
    private JLabel bottomLabel;
    private JLabel iconLabel;

    public PanelCustomButton() {
        this(null);
    }

    public PanelCustomButton(T displayable) {
        super(displayable);
        this.title = new JLabel(displayable == null ? null : displayable.getLabel());
        this.bottomPanel = new JPanel(new BorderLayout());
        this.bottomPanel.getInsets().set(0, 0, 0, 0);
        this.bottomPanel.setOpaque(false);
        this.bottomLabel = new JLabel();
        this.bottomLabel.setName("bottomLabel");
        this.bottomLabel.getInsets().set(0, 0, 0, 0);
        this.iconLabel = new JLabel();
        this.iconLabel.setName("iconLabel");
        this.iconLabel.setHorizontalTextPosition(2);
        this.iconLabel.setHorizontalAlignment(4);
        this.iconLabel.getInsets().set(0, 0, 0, 0);
        this.bottomPanel.add((Component)this.bottomLabel, "Center");
        this.bottomPanel.add((Component)this.iconLabel, "East");
        this.iconLabel.setIcon(this.getIcon());
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.title, "Center");
    }

    public void setExtraText(String middleText, String bottomText) {
        this.remove(this.title);
        this.remove(this.bottomPanel);
        if (StringUtils.isEmpty((String)middleText)) {
            this.add(this.title, "Center");
            this.setMiddleText(null);
        } else {
            this.add(this.title, "North");
            this.setMiddleText(middleText);
        }
        this.bottomLabel.setText(bottomText);
        if (this.iconLabel.getIcon() != null || this.bottomLabel.getText() != null) {
            this.add(this.bottomPanel, "South");
        }
        this.updateInnerName();
    }

    public void setIcon(Icon defaultIcon) {
        if (this.iconLabel == null) {
            super.setIcon(defaultIcon);
        } else {
            super.setIcon(null);
            this.iconLabel.setIcon(defaultIcon);
        }
    }

    public void setText(String value) {
        super.setText(null);
        if (this.title != null) {
            this.title.setText(value);
        }
    }

    public void setData(T toSet) {
        super.setData(toSet);
        this.setText(null);
    }

    private void setMiddleText(String middleInfo) {
        if (this.middle != null) {
            this.remove(this.middle);
            this.middle = null;
        }
        if (middleInfo != null) {
            this.middle = new JLabel(middleInfo);
            this.middle.setVerticalAlignment(1);
            this.add(this.middle, "Center");
        }
    }

    public void setName(String innerName) {
        this.innerNamePrefix = innerName;
    }

    public void updateInnerName() {
        StringBuilder innerName = new StringBuilder(this.innerNamePrefix == null ? "" : this.innerNamePrefix).append(": ");
        innerName.append(this.title.getText()).append("\n");
        if (this.middle != null) {
            innerName.append(this.middle.getText()).append("\n");
        }
        if (this.bottomLabel.getText() != null) {
            innerName.append(this.bottomLabel.getText());
        }
        super.setName(innerName.toString());
    }
}

