/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.customer;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.sales.Customer;
import ordermate.database.users.AllPermissions;
import ordermate.gui.button.CustomButton;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class CustomerPanel
extends JPanel
implements ActionListener {
    public final Signal<Customer, ?, ?, ?, ?> selected = Signals.createSignal(Customer.class, (String)"selected");
    public final Signal<Customer, ?, ?, ?, ?> edit = Signals.createSignal(Customer.class, (String)"edit");
    public final Signal<Customer, ?, ?, ?, ?> salesHistorySignal = Signals.createSignal(Customer.class, (String)"salesHistorySignal");
    private static final Icon editImage = IconLoader.get((String)"/waitermate/images/edit.png");
    private static final Icon salesHitoryIcon = IconLoader.get((String)"/waitermate/images/money.png");
    private Customer customer;
    private CustomButton custButton = new CustomButton();
    private CustomButton salesHistoryButton;
    private CustomButton editButton;
    private StandardSecurityDecorator editDecorator;

    public CustomerPanel() {
        this.custButton.setHorizontalAlignment(2);
        this.custButton.addActionListener((ActionListener)this);
        this.custButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"RIGHT");
        this.custButton.putClientProperty((Object)"substancelaf.buttonShaper", (Object)"org.jvnet.substance.button.ClassicButtonShaper");
        this.salesHistoryButton = new CustomButton();
        this.salesHistoryButton.setIcon(salesHitoryIcon);
        this.salesHistoryButton.addActionListener((ActionListener)this);
        this.salesHistoryButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"LEFT");
        this.editButton = new CustomButton();
        this.editButton.setIcon(editImage);
        this.editButton.addActionListener((ActionListener)this);
        this.editButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"LEFT");
        this.editDecorator = new StandardSecurityDecorator((JComponent)this.editButton, AllPermissions.CUSTOMER_ADMIN);
        this.setLayout((LayoutManager)new GraphPaperLayout(21, 1));
        this.add((Component)this.custButton, new Rectangle(0, 0, 13, 1));
        this.add((Component)this.salesHistoryButton, new Rectangle(13, 0, 4, 1));
        this.add((Component)this.editDecorator, new Rectangle(17, 0, 4, 1));
    }

    public void setCustomer(Customer theCustomer) {
        this.customer = theCustomer;
        this.custButton.setData((Displayable)this.customer);
        this.editButton.setName("Edit " + (this.customer != null ? this.customer.getName() : " no customer"));
        if (this.customer == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        boolean newLine = false;
        newLine |= this.appendIfNotNull(buffer, this.customer.getFirstName());
        if (newLine |= this.appendIfNotNull(buffer, this.customer.getLastName())) {
            buffer.append("<br>");
        }
        if (this.appendIfNotNull(buffer, Internationalization.getLiteralFor((String)"CARD_ID") + ": ", this.customer.getCardID())) {
            buffer.append("<br>");
        }
        newLine = false;
        newLine |= this.appendIfNotNull(buffer, "P:", this.customer.getPrimaryPhoneNumber());
        if (newLine |= this.appendIfNotNull(buffer, "S:", this.customer.getSecondaryPhoneNumber())) {
            buffer.append("<br>");
        }
        this.appendIfNotNull(buffer, null, this.customer.getRoomAptNumber(), " / ");
        this.appendIfNotNull(buffer, this.customer.getHouseNumber());
        this.appendIfNotNull(buffer, this.customer.getStreetName());
        this.appendIfNotNull(buffer, this.customer.getStreetType());
        this.appendIfNotNull(buffer, this.customer.getSuburb());
        this.appendIfNotNull(buffer, this.customer.getState());
        this.appendIfNotNull(buffer, this.customer.getPostcode());
        buffer.append("</html>");
        this.custButton.setText(buffer.toString());
    }

    private boolean appendIfNotNull(StringBuffer buffer, String value) {
        boolean append;
        boolean bl = append = value != null && !value.equals("");
        if (append) {
            buffer.append(value);
            buffer.append(" ");
        }
        return append;
    }

    private boolean appendIfNotNull(StringBuffer buffer, String prefix, String value) {
        return this.appendIfNotNull(buffer, prefix, value, null);
    }

    private boolean appendIfNotNull(StringBuffer buffer, String prefix, String value, String suffix) {
        boolean append;
        boolean bl = append = value != null && !value.equals("");
        if (append) {
            if (prefix != null) {
                buffer.append(prefix);
            }
            buffer.append(value);
            if (suffix != null) {
                buffer.append(suffix);
            }
            buffer.append(" ");
        }
        return append;
    }

    public void setEditVisible(boolean value) {
        this.editDecorator.setVisible(value);
        this.editButton.setVisible(value);
    }

    public void setHistoryVisible(boolean showSalesHistoryButtonFlag) {
        this.salesHistoryButton.setVisible(showSalesHistoryButtonFlag);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.custButton) {
            this.selected.emit((Object)this.customer);
        } else if (source == this.editButton) {
            this.edit.emit((Object)this.customer);
        } else if (source == this.salesHistoryButton) {
            this.salesHistorySignal.emit((Object)this.customer);
        }
    }
}

