/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.stockitems;

import au.com.ordermate.persistence.Displayable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.gui.button.CustomButton;
import ordermate.gui.scroll.CustomButtonRenderer;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class StockAreaPairSelector
extends JPanel
implements ActionListener {
    private static final Dimension DEFAULT_BUTTON_SIZE = new Dimension(120, 60);
    public final Signal areaSelected = Signals.createSignal(StockArea.class, (String)"selectedAreaFrom", StockArea.class, (String)"selectedAreaTo");
    private Set<StockArea> allStockAreas;
    private CustomButton<StockArea> stockAreaFrom;
    private CustomButton<StockArea> stockAreaTo;
    private StockAreaDialogPanel stockAreaDialog;

    public StockAreaPairSelector(String prefixLabel, String divLabel) {
        this.setLayout(new FlowLayout(0));
        this.allStockAreas = new HashSet<StockArea>(StockArea.getStockAreas());
        this.stockAreaFrom = new CustomButton();
        this.stockAreaFrom.addActionListener((ActionListener)this);
        this.stockAreaFrom.setPreferredSize(DEFAULT_BUTTON_SIZE);
        this.stockAreaFrom.setName("stockAreaFrom");
        this.stockAreaTo = new CustomButton();
        this.stockAreaTo.addActionListener((ActionListener)this);
        this.stockAreaTo.setName("stockAreaTo");
        this.stockAreaTo.setPreferredSize(DEFAULT_BUTTON_SIZE);
        this.add(this.createJLabel(prefixLabel));
        this.add((Component)this.stockAreaFrom);
        this.add(this.createJLabel(divLabel));
        this.add((Component)this.stockAreaTo);
        this.stockAreaDialog = new StockAreaDialogPanel(new ArrayList<StockArea>(this.allStockAreas));
    }

    private JLabel createJLabel(String prefixLabel) {
        JLabel toReturn = new JLabel(prefixLabel);
        toReturn.setFont(OrderMateTheme.getMediumFont());
        return toReturn;
    }

    public void setStockAreaTo(StockArea toSet) {
        if (toSet == null) {
            return;
        }
        this.stockAreaTo.setData((Displayable)toSet);
        StockArea fromArea = (StockArea)this.stockAreaFrom.getData();
        if (fromArea == null || fromArea.equals((Object)toSet)) {
            this.stockAreaFrom.setData((Displayable)this.getAnyStockAreaNotSelected(toSet));
        }
    }

    public StockArea getStockAreaTo() {
        return (StockArea)this.stockAreaTo.getData();
    }

    public void setStockAreaFrom(StockArea toSet) {
        if (toSet == null) {
            return;
        }
        this.stockAreaFrom.setData((Displayable)toSet);
        StockArea toArea = (StockArea)this.stockAreaTo.getData();
        if (toArea == null || toArea.equals((Object)toSet)) {
            this.stockAreaTo.setData((Displayable)this.getAnyStockAreaNotSelected(toSet));
        }
    }

    public StockArea getStockAreaFrom() {
        return (StockArea)this.stockAreaFrom.getData();
    }

    private StockArea getAnyStockAreaNotSelected(StockArea toSet) {
        for (StockArea area : this.allStockAreas) {
            if (area.equals((Object)toSet)) continue;
            return area;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof CustomButton) {
            if (source.equals(this.stockAreaFrom)) {
                StockArea result = this.stockAreaDialog.display("Select Stock Area From");
                if (result != null) {
                    this.setStockAreaFrom(result);
                }
                this.performUpdate();
            } else if (source.equals(this.stockAreaTo)) {
                StockArea result = this.stockAreaDialog.display("Select Stock Area To");
                if (result != null) {
                    this.setStockAreaTo(result);
                }
                this.performUpdate();
            }
        }
    }

    public void performUpdate() {
        this.areaSelected.emit((Object)this.stockAreaFrom.getData(), (Object)this.stockAreaTo.getData());
    }

    public void newStockRequisitionOrder(StockRequisitionOrder selectedOrder) {
        this.setStockAreaFrom(selectedOrder.getStockAreaSender());
        this.setStockAreaTo(selectedOrder.getStockAreaReceiver());
        selectedOrder.setStockAreaReceiver((StockArea)this.stockAreaTo.getData());
        selectedOrder.setStockAreaSender((StockArea)this.stockAreaFrom.getData());
    }

    class StockAreaDialogPanel
    extends JPanel {
        private List<StockArea> allStockAreas;
        private CustomButtonRenderer<StockArea> renderer;
        private StockArea selectedStockArea = null;
        private PopupWindow dialog;

        public StockAreaDialogPanel(List<StockArea> allStockAreas) {
            this.setLayout(new BorderLayout());
            this.selectedStockArea = null;
            this.allStockAreas = allStockAreas;
            this.renderer = new CustomButtonRenderer<StockArea>(){

                public Class<StockArea> getSelectedClassType() {
                    return StockArea.class;
                }
            };
            this.renderer.selected.connect((Object)this, "gotStockArea");
            RendererScrollPaneModel model = new RendererScrollPaneModel(this.renderer);
            model.setObjects(allStockAreas);
            CustomScrollPane pane = new CustomScrollPane((CustomScrollPaneModel)model);
            pane.setColumns(2);
            pane.setRowsPerPage(3);
            this.add((Component)pane, "Center");
        }

        public StockArea display(String title) {
            this.dialog = Dialogs.createDialog((JComponent)this, (String)title, null, null, (boolean)true, (boolean)false, (boolean)false);
            if (Dialogs.displayDialog((PopupWindow)this.dialog, null, null)) {
                return this.selectedStockArea;
            }
            return null;
        }

        public void gotStockArea(StockArea area) {
            this.selectedStockArea = area;
            if (this.dialog != null) {
                this.dialog.gotOk();
            }
        }
    }
}

