/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.stockitems;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.searchers.stock.StockItemSearcher;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.keyboard.Keyboard;
import ordermate.gui.scroll.CustomButtonRenderer;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DataScrollPaneModel;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.displayitems.stockitems.StockItemRenderer;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;

public class StockItemSearchPanel
extends JPanel
implements ActionListener {
    private static final int NUM_RESULTS_TO_DISPLAY = 4;
    public Signal itemSelected = Signals.createSignal(StockItem.class, (String)"theNewItem");
    public Signal back = Signals.createSignal();
    private JLabel textLabel;
    private JLabel numResultsLabel;
    private JPanel resultPanel;
    private JPanel criteriaPanel;
    private NavBar navBar;
    private JButton categoryButton;
    private DataScrollPaneModel categoryModel;
    private CustomScrollPane categoryPanel;
    private RendererScrollPaneModel resultsModel;
    private Keyboard keyboard;
    private final StockItemSearcher searcher;
    private CustomButtonRenderer<StockItem> renderer;

    public StockItemSearchPanel() {
        this(new StockItemSearcher(), true);
    }

    public StockItemSearchPanel(StockItemSearcher theSearcher, boolean addNav) {
        super(new BorderLayout());
        this.searcher = theSearcher;
        this.searcher.addMatcherEditorListener(new MatcherEditor.Listener(){

            public void changedMatcher(MatcherEditor.Event arg0) {
                StockItemSearchPanel.this.updateResults();
            }
        });
        this.setupComponents(addNav);
    }

    private void setupComponents(boolean addNav) {
        this.setupCriteriaPanel();
        this.setupResultsPanel();
        this.setupKeyboardPanel();
        if (addNav) {
            this.setupNavBar();
        }
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.resultPanel, "Center");
        topPanel.add((Component)this.criteriaPanel, "West");
        this.add((Component)topPanel, "North");
        this.add((Component)this.keyboard, "Center");
        if (addNav) {
            this.add((Component)this.navBar, "South");
        }
    }

    private void setupCriteriaPanel() {
        JPanel holder = new JPanel();
        this.criteriaPanel = new JPanel(new BorderLayout());
        holder.setLayout(new FlowLayout(0));
        JLabel itemNameLabel = new JLabel("Stock Item Name:");
        itemNameLabel.setFont(OrderMateTheme.getLargeFont());
        holder.add(itemNameLabel);
        this.textLabel = new JLabel("");
        holder.add(this.textLabel);
        this.textLabel.setName("inputText");
        this.textLabel.setHorizontalAlignment(2);
        this.textLabel.setPreferredSize(new Dimension(200, 50));
        this.textLabel.setFont(OrderMateTheme.getLargeFont());
        this.criteriaPanel.add((Component)holder, "South");
        JLabel iconLabel = new JLabel(IconLoader.get((String)"/waitermate/images/bigSearch.png"));
        iconLabel.setText("Find a stock item...");
        iconLabel.setHorizontalTextPosition(0);
        iconLabel.setVerticalTextPosition(3);
        this.criteriaPanel.add((Component)iconLabel, "Center");
    }

    protected CustomButtonRenderer<StockItem> createRenderer() {
        return new StockItemRenderer();
    }

    private void setupResultsPanel() {
        this.resultPanel = new JPanel(new BorderLayout());
        this.renderer = this.createRenderer();
        this.renderer.selected.connect((Object)this, "gotStockItem");
        this.resultsModel = new RendererScrollPaneModel(this.renderer, 1, 4);
        CustomScrollPane scrolly = new CustomScrollPane((CustomScrollPaneModel)this.resultsModel);
        scrolly.setDecorationLocation(DecoratorLocation.East);
        this.resultPanel.add((Component)scrolly, "Center");
        this.numResultsLabel = new JLabel();
        this.resultPanel.add((Component)this.numResultsLabel, "South");
        this.numResultsLabel.setName("numResults");
        this.resultPanel.setPreferredSize(new Dimension(400, 200));
    }

    public void gotStockItem(StockItem selectedItem) {
        this.itemSelected.emit((Object)selectedItem);
    }

    public void setupKeyboardPanel() {
        this.keyboard = new Keyboard();
        this.keyboard.updated.connect((Object)this, "gotKeystroke");
    }

    private void setupNavBar() {
        this.navBar = new NavBar();
        this.navBar.addLeft((Component)this.navBar.getBackButton());
        this.navBar.addRight((Component)this.navBar.getClearButton());
        this.categoryButton = this.navBar.constructButton((Icon)IconLoader.get((String)"/waitermate/images/StockCount.png"), "Category", "category");
        this.categoryButton.addActionListener(this);
        this.navBar.addLeft((Component)this.categoryButton);
        this.navBar.back.connect((Object)this, "gotBack");
        this.navBar.clear.connect((Object)this, "gotClear");
    }

    public void gotKeystroke(String value) {
        this.keyboard.setValue(value);
        this.textLabel.setText(value);
        this.searcher.setSearchString(value);
    }

    public NavBar getNavBar() {
        return this.navBar;
    }

    private void updateResults() {
        EventList listOfItems = !this.searcher.isRestricted() ? new ArrayList() : this.searcher.getResultingItems();
        this.resultsModel.setObjects((List)listOfItems);
        if (this.searcher.getResultCount() == 0) {
            this.numResultsLabel.setForeground(Color.RED);
            this.numResultsLabel.setText("No results, try a wider search.");
        } else {
            this.numResultsLabel.setForeground(null);
            this.numResultsLabel.setText("Results: " + this.searcher.getResultCount());
        }
    }

    public void startSearch(StockGroup preferredGroup, boolean reset) {
        StockItemQueries.clearCache();
        this.startSearch(StockItemQueries.getStockItems(), preferredGroup, reset);
    }

    public void startSearch(List<StockItem> items, StockGroup prefGroup, boolean reset) {
        String gouupToSearch = null;
        if (prefGroup != null) {
            gouupToSearch = prefGroup.toString();
        }
        this.searcher.setSearchParameters(items, gouupToSearch);
        if (reset) {
            this.gotClear();
        }
    }

    void gotClear() {
        if (this.categoryModel != null) {
            this.categoryModel.selectAllButtons(false);
        }
        this.keyboard.setValue("");
        this.gotKeystroke("");
    }

    void gotBack() {
        this.back.emit();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.categoryButton) {
            if (this.categoryPanel == null) {
                this.categoryModel = new DataScrollPaneModel(1, 6);
                this.categoryModel.setItems(InventoryCategory.getAllCategories(), true, false);
                this.categoryPanel = new CustomScrollPane((CustomScrollPaneModel)this.categoryModel);
            }
            Dialogs.displayOkDialog((JComponent)this.categoryPanel, (String)"Select Categories");
            ArrayList<Displayable> categories = new ArrayList<Displayable>();
            Iterator it = this.categoryModel.getSelectedButtons().iterator();
            while (it.hasNext()) {
                categories.add(((CustomToggleButton)it.next()).getData());
            }
            if (categories.size() == 0) {
                Object var3_3 = null;
            }
        }
    }

    public StockItemSearcher getSearcher() {
        return this.searcher;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }
}

