/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.stockrequisition;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import ordermate.database.stock.requisition.StockRequisition;
import ordermate.gui.button.CustomButton;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class StockRequisitionItemPanel
extends JPanel
implements ActionListener {
    public final Signal itemPressed = Signals.createSignal(StockRequisition.class, (String)"selectedRequisition");
    public final Signal deletePressed = Signals.createSignal(StockRequisition.class, (String)"selectedRequisition");
    private StockRequisition stockItem;
    private CustomButton requisitionButton;
    private CustomButton deleteButton;

    public StockRequisitionItemPanel() {
        this.createPanel();
    }

    private void createPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.createRequisitionButton(), "Center");
        this.add(this.createDeleteButton(), "East");
    }

    private Component createRequisitionButton() {
        this.requisitionButton = new CustomButton();
        this.requisitionButton.addActionListener((ActionListener)this);
        this.requisitionButton.setHorizontalTextPosition(2);
        this.requisitionButton.setHorizontalAlignment(2);
        this.requisitionButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"LEFT");
        this.requisitionButton.setVerticalTextPosition(1);
        return this.requisitionButton;
    }

    private Component createDeleteButton() {
        this.deleteButton = new CustomButton();
        this.deleteButton.addActionListener((ActionListener)this);
        ImageIcon deleteIcon = IconLoader.get((String)"/waitermate/images/delete.png");
        this.deleteButton.setPreferredSize(new Dimension(deleteIcon.getIconWidth() * 2 + 10, deleteIcon.getIconHeight()));
        this.deleteButton.setHorizontalAlignment(0);
        this.deleteButton.setIcon((Icon)deleteIcon);
        return this.deleteButton;
    }

    public void setItem(StockRequisition newItem) {
        this.stockItem = newItem;
        this.requisitionButton.setData((Displayable)this.stockItem);
        this.requisitionButton.setText(this.stockItem.getDisplayableLabel());
        this.requisitionButton.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.requisitionButton)) {
            this.itemPressed.emit((Object)this.stockItem);
        } else if (source.equals(this.deleteButton)) {
            this.deletePressed.emit((Object)this.stockItem);
        }
    }
}

