/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.stockrequisition;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.database.stock.requisition.StockRequisitionOrderStatus;
import ordermate.gui.button.CustomButton;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class StockRequisitionOrderItemPanel
extends JPanel
implements ActionListener {
    public Signal<StockRequisitionOrder, ?, ?, ?, ?> itemPressed = Signals.createSignal(StockRequisitionOrder.class, (String)"stockItemWastage");
    private StockRequisitionOrder stockReqItem;
    private CustomButton requisitionButton;

    public StockRequisitionOrderItemPanel() {
        this.createPanel();
    }

    private void createPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.createRequisitionButton(), "Center");
    }

    private Component createRequisitionButton() {
        this.requisitionButton = new CustomButton();
        this.requisitionButton.addActionListener((ActionListener)this);
        this.requisitionButton.setHorizontalTextPosition(2);
        this.requisitionButton.setHorizontalAlignment(2);
        this.requisitionButton.putClientProperty((Object)"substancelaf.buttonopenSide", (Object)"LEFT");
        this.requisitionButton.setVerticalTextPosition(1);
        return this.requisitionButton;
    }

    public void setItem(StockRequisitionOrder newItem) {
        this.stockReqItem = newItem;
        this.requisitionButton.setIcon((Icon)IconLoader.get((String)"/waitermate/images/Stock_48.png"));
        this.requisitionButton.setVerticalTextPosition(0);
        this.requisitionButton.setHorizontalTextPosition(4);
        this.requisitionButton.setIconTextGap(8);
        this.requisitionButton.setData((Displayable)this.stockReqItem);
        this.requisitionButton.setText(this.buildDisplayableLable(this.stockReqItem));
        this.requisitionButton.setEnabled(true);
    }

    private String buildDisplayableLable(StockRequisitionOrder stockReqItem) {
        StringBuilder SB = new StringBuilder();
        SB.append("<html>").append("From ").append(stockReqItem.getStockAreaSender()).append(" to ").append(stockReqItem.getStockAreaReceiver()).append("\t");
        this.appendColoredStateString(SB, stockReqItem.getStatus());
        SB.append("\n<p>").append("Created ").append(DateTimeUtils.getDayOfWeekFormat().format(stockReqItem.getCreationDateTime())).append(", ").append(DateTimeUtils.getSimpleTimeFormat().format(stockReqItem.getCreationDateTime())).append(" by ").append(stockReqItem.getUserCreated()).append("</html>");
        return SB.toString();
    }

    private void appendColoredStateString(StringBuilder SB, StockRequisitionOrderStatus status) {
        if (StockRequisitionOrderStatus.NEW.equals((Object)status)) {
            SB.append("<span style=\"color:green\">");
        } else if (StockRequisitionOrderStatus.REQUESTED.equals((Object)status)) {
            SB.append("<span style=\"color:blue\">");
        } else if (StockRequisitionOrderStatus.PICKING.equals((Object)status)) {
            SB.append("<span style=\"color:#FF6A00\">");
        } else if (StockRequisitionOrderStatus.COMPLETE.equals((Object)status)) {
            SB.append("<span style=\"color:#808080\">");
        }
        SB.append("**" + status + "**").append("</span>");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.requisitionButton)) {
            this.itemPressed.emit((Object)this.stockReqItem);
        }
    }
}

