/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.displayitems.stockwastage;

import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.usage.StockWastage;
import waitermate.LoginManager;
import waitermate.gui.displayitems.stockwastage.StockWastageRenderer;

public class DefaultWastageRenderer
implements StockWastageRenderer {
    @Override
    public String getHTMLWaitermateLabel(StockWastage link) {
        StringBuilder SB = new StringBuilder("<html>");
        this.appendStockWastageLabel(link, SB);
        SB.append("</html>");
        return SB.toString();
    }

    protected void appendStockWastageLabel(StockWastage wastageItem, StringBuilder SB) {
        StockItem item = wastageItem.getStockItem();
        SB.append("<html><body>");
        SB.append(wastageItem.getQuantityUsed().toString());
        SB.append(" ");
        SB.append("<B>" + item.getLabel() + "</B><br>");
        StockOnHand soh = item.getStockOnHandObject(LoginManager.getEventContext().getTerminal().getStockArea());
        if (soh.getQuantity() <= 0.0) {
            SB.append("<span style=\"color:red\"> Avail: ");
        } else {
            SB.append("<span style=\"color:black\"> Avail: ");
        }
        SB.append(soh.getTotalQuantity(item.getDisplayMeasureUnitContainer()));
        SB.append("</span><br>");
        if (item.getTotalStockOnHand().getRawValue() <= 0.0) {
            SB.append("<span style=\"color:red\"> Total: ");
        } else {
            SB.append("<span style=\"color:gray\"> Total: ");
        }
        SB.append(item.getTotalStockOnHand());
        SB.append("</span></body></html>");
    }
}

