/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.fingerprint;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.GuiHandler;
import com.digitalpersona.onetouch.DPFPGlobal;
import com.digitalpersona.onetouch.DPFPSample;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.fingerprint.FingerprintDespatch;
import waitermate.gui.fingerprint.ScanFingerPanel;

class ScanFinger {
    private static ScanFinger instance;
    private Signal gotScan = Signals.createSignal(DPFPSample.class, (String)"sample");
    private Signal currentSignal;
    private Signal currentCancelSignal;
    private GuiHandler currentGui;
    private ScanFingerPanel scanPanel = new ScanFingerPanel();

    public static final ScanFinger getInstance() {
        if (instance == null) {
            instance = new ScanFinger();
        }
        return instance;
    }

    private ScanFinger() {
        this.scanPanel.cancel.connect((Object)this, "gotCancel");
        this.gotScan.connect((Object)this, "gotFingerprint");
    }

    public void scanFinger(Signal gotScanSignal, Signal gotCancelSignal, GuiHandler gui, String extraText) {
        this.currentSignal = gotScanSignal;
        this.currentCancelSignal = gotCancelSignal;
        this.currentGui = gui;
        if (this.currentSignal == null || this.currentGui == null) {
            throw new IllegalArgumentException("Cannot have a null signal or gui handler.");
        }
        if (!Config.isDebuging() && !this.checkForScanner()) {
            gui.displayOkDialog("No Fingerprint Scanner", "<html>There does not appear to be a finger print scanner attached.<br><br>Please make sure it is firmly plugged in, in operating condition<br>and that the latest drivers have been installed.</html>");
            this.gotCancel();
            return;
        }
        FingerprintDespatch.getInstance().setSignalToUse(this.gotScan);
        this.scanPanel.setExtraText(extraText);
        gui.displayBlockingDialog((JPanel)this.scanPanel);
    }

    private boolean checkForScanner() {
        try {
            return DPFPGlobal.getReadersFactory().getReaders().size() > 0;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Missing drivers for fingerprint scanner! : ", (Throwable)e);
            return false;
        }
    }

    public void gotFingerprint(DPFPSample sample) {
        this.dismissSignal();
        if (this.scanPanel.isShowing()) {
            this.currentGui.closeBlockingDialog((JPanel)this.scanPanel);
        }
        if (this.currentSignal != null) {
            this.currentSignal.emit((Object)sample);
            this.currentSignal = null;
        }
        this.currentGui = null;
        this.currentCancelSignal = null;
    }

    void gotCancel() {
        this.dismissSignal();
        if (this.scanPanel.isShowing()) {
            this.currentGui.closeBlockingDialog((JPanel)this.scanPanel);
        }
        this.currentCancelSignal.emit();
        this.currentGui = null;
        this.currentCancelSignal = null;
    }

    private void dismissSignal() {
        FingerprintDespatch.getInstance().dismissSignal(this.gotScan);
    }
}

