/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.mandatory;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import ordermate.database.RequiredFields;
import waitermate.gui.WaiterMateObjectEditor;
import waitermate.gui.mandatory.AbstractMandatoryFieldsPanel;

public abstract class ComponentMandatoryFieldsPanel<P extends PersistentObject>
extends AbstractMandatoryFieldsPanel<P> {
    private WaiterMateObjectEditor<P> editor;
    private Map<PropertiedObject.Property, JComponent> propertyMap = new HashMap<PropertiedObject.Property, JComponent>();
    private RequiredFields requiredFieldsObject;
    private P sandboxObject;

    public ComponentMandatoryFieldsPanel(LayoutManager manager) {
        super(manager);
        this.editor = new WaiterMateObjectEditor();
        this.editor.gotChange.connect((Object)this, "gotPropertyChanged");
        this.addAncestorListener(this.editor);
        this.setupComponents(this.editor);
    }

    protected void registerPropertyComponent(PropertiedObject.Property property, JComponent comp) {
        this.propertyMap.put(property, comp);
    }

    protected JComponent getComponentForProperty(PropertiedObject.Property prop) {
        return this.propertyMap.get(prop);
    }

    protected Set<PropertiedObject.Property> getProperties() {
        return this.propertyMap.keySet();
    }

    public void gotPropertyChanged() {
        this.doRequiredFieldsVisualFeedback();
        this.newInput.emit();
    }

    protected abstract void setupComponents(WaiterMateObjectEditor<P> var1);

    @Override
    protected void doRequiredFieldsVisualFeedback() {
        for (PropertiedObject.Property property : this.getProperties()) {
            JComponent component = this.getComponentForProperty(property);
            if (this.getFieldsRequired().contains(property)) {
                this.paintComponentAsRequired(component, this.isRequirementMet(property));
                continue;
            }
            this.paintComponentAsRequired(component, true);
        }
    }

    protected boolean isRequirementMet(PropertiedObject.Property property) {
        if (this.requiredFieldsObject != null) {
            return this.requiredFieldsObject.getMeetsRequirement(property);
        }
        return true;
    }

    @Override
    public void loadObject(P theObject) {
        if (theObject != null) {
            this.sandboxObject = theObject;
            this.requiredFieldsObject = this.getRequiredFieldsObject(this.sandboxObject);
        } else {
            this.sandboxObject = null;
            this.requiredFieldsObject = null;
        }
        this.editor.setObject(this.sandboxObject, true);
    }

    protected abstract P copyObject(P var1);

    protected abstract RequiredFields getRequiredFieldsObject(P var1);

    @Override
    public boolean hasPanelMetRequirements() {
        if (this.requiredFieldsObject == null) {
            return true;
        }
        boolean valid = true;
        for (PropertiedObject.Property property : this.getProperties()) {
            if (this.getFieldsRequired().contains(property)) {
                valid &= this.requiredFieldsObject.getMeetsRequirement(property);
            }
            if (valid) continue;
            break;
        }
        return valid;
    }

    @Override
    public P saveObject(P theObject) {
        this.editor.setObject(this.sandboxObject, false);
        this.editor.updateObject();
        return this.sandboxObject;
    }

    @Override
    public void reset() {
        this.editor.setObject(null, true);
    }

    @Override
    public void selectFirstInvalid() {
        if (this.isPanelValid()) {
            Collection<JComponent> comps = this.propertyMap.values();
            for (Component comp : this.getComponents()) {
                if (!comps.contains(comp)) continue;
                comp.requestFocusInWindow();
                break;
            }
        } else {
            for (Component comp : this.getComponents()) {
                if (!this.isMarkedAsInvalid((JComponent)comp)) continue;
                comp.requestFocusInWindow();
                break;
            }
        }
    }
}

