/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.modify.security;

import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.Permission;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.signals.Signal;
import waitermate.LoginManager;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;

public class SwipeOverSecurityDecorator
extends StandardSecurityDecorator
implements ActionListener {
    public Signal actionToPerformSignal;
    private User originalUser;
    private User tempSuperUser;
    private List<String> autoLogoutScreensList;
    private ImageIcon origIcon;
    private boolean iconOverlayed;
    private boolean overrideExistingImage = true;
    private boolean tempLoginAuthourisedUser = true;

    public SwipeOverSecurityDecorator(AbstractButton toDecorate, Permission newPermission, Signal actionPerformSignal, String[] autoLogoutScreens) {
        super((JComponent)toDecorate, newPermission);
        this.actionToPerformSignal = actionPerformSignal;
        toDecorate.addActionListener(this);
        this.autoLogoutScreensList = autoLogoutScreens != null ? Arrays.asList(autoLogoutScreens) : new ArrayList<String>();
        if (toDecorate.getIcon() instanceof ImageIcon) {
            this.origIcon = (ImageIcon)toDecorate.getIcon();
        }
        this.setIcon();
    }

    public SwipeOverSecurityDecorator(AbstractButton toDecorate, Permission newPermission, Signal actionPerformSignal) {
        this(toDecorate, newPermission, actionPerformSignal, null);
    }

    protected boolean processEnabledStatus() {
        if (this.iconOverlayed != !super.processEnabledStatus()) {
            this.setIcon();
        }
        return this.isSecurityOn() ? Terminal.getLocalHost().getShowPin() && this.isBusinessEnabled() : this.isBusinessEnabled();
    }

    private void setIcon() {
        AbstractButton button = (AbstractButton)this.getDecorateComponent();
        if (this.isSecurityVisible() && !this.isSecurityEnabled()) {
            if (this.origIcon != null && !this.overrideExistingImage) {
                ImageHelper helper = new ImageHelper();
                Image newImage = helper.imposeImage(this.origIcon.getImage(), IconLoader.getImage((String)"/waitermate/images/key24x24.png"), 1.0, 1.0);
                button.setIcon(new ImageIcon(newImage));
            } else {
                button.setIcon(IconLoader.get((String)"/waitermate/images/key24x24.png"));
            }
            this.iconOverlayed = true;
        } else {
            button.setIcon(this.origIcon);
            this.iconOverlayed = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isBusinessEnabled()) {
            if (!this.isSecurityEnabled()) {
                if (this.tempLoginAuthourisedUser && !this.autoLogoutScreensList.isEmpty()) {
                    NotificationManager.getInstance().notifyScreenChanged.connect((Object)this, "gotScreenChanged");
                }
                this.originalUser = LoginManager.getInstance().getUser();
                this.tempSuperUser = this.getUserWithPermissionLogin();
                if (this.tempSuperUser != null) {
                    this.actionToPerformSignal.emit();
                } else {
                    NotificationManager.getInstance().notifyScreenChanged.disconnect((Object)this);
                }
            } else {
                this.actionToPerformSignal.emit();
            }
        }
    }

    public void gotScreenChanged(AbstractScreen newScreen) {
        if (this.tempLoginAuthourisedUser && this.autoLogoutScreensList.contains(newScreen.getName())) {
            NotificationManager.getInstance().notifyScreenChanged.disconnect((Object)this);
            LoginManager.getInstance().setUser(this.originalUser);
            String dialogMsg = this.originalUser.getName() + " has been logged back on.";
            this.logMessage(dialogMsg);
            Dialogs.displayOkDialog((String)dialogMsg, (String)"User Logged On");
        }
    }

    protected User getUserWithPermissionLogin() {
        if (Terminal.getLocalHost().getShowPin()) {
            JPanel gui = (JPanel)ScreenResource.getScreen().getMainArea();
            Dimension dialogSize = new Dimension(400, 550);
            Point location = new Point(gui.getLocation().x + (gui.getWidth() - dialogSize.width) / 2, gui.getTopLevelAncestor() != null ? gui.getTopLevelAncestor().getY() + ScreenResource.getMenuHeight() : 0);
            while (!LoginManager.getInstance().getUser().hasPermission(this.getPermission())) {
                String pinEntered = Dialogs.showKeypadQuickLogout((Dimension)dialogSize, (Point)location, (String)"CANCEL");
                if (pinEntered.equals("\u0000")) {
                    return null;
                }
                if (!this.isUserValid(pinEntered)) continue;
                if (this.tempLoginAuthourisedUser) {
                    LoginManager.getInstance().gotPinLogin(pinEntered);
                }
                return LoginManager.getInstance().getUser();
            }
        }
        return null;
    }

    private boolean isUserValid(String pin) {
        User tempLoggedIn = User.getUserByPin((String)pin);
        if (tempLoggedIn == null) {
            Dialogs.displayOkDialog((String)"Invalid pin number", (String)"Invalid Pin");
            this.logMessage("Invalid pin login attempt: " + pin);
            return false;
        }
        if (!tempLoggedIn.hasPermission(this.getPermission())) {
            Dialogs.displayOkDialog((String)("User doesn't have required Permission: \n\n" + this.getPermission().getDescription()), (String)"Invalid User");
            this.logMessage("Attempt to logon with user (PIN " + pin + " ) not having permission: " + this.getPermission().getDescription());
            return false;
        }
        this.logMessage("User with (PIN " + pin + " ) logged on.");
        return true;
    }

    private void logMessage(String description) {
        TerminalEventLog.logInvalidPinLoginAttempt((Terminal)Terminal.getLocalHost(), (String)description);
        OrderMate.LOG.warn("Swipe Over : " + description);
    }

    boolean isIconOverlayed() {
        return this.iconOverlayed;
    }

    public boolean isOverrideExistingImage() {
        return this.overrideExistingImage;
    }

    public void setOverrideExistingImage(boolean overrideExistingImage) {
        this.overrideExistingImage = overrideExistingImage;
    }

    public boolean isTempLoginAuthourisedUser() {
        return this.tempLoginAuthourisedUser;
    }

    public void setTempLoginAuthourisedUser(boolean tempLoginAuthourisedUser) {
        this.tempLoginAuthourisedUser = tempLoginAuthourisedUser;
    }
}

