/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.notify;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.ImageHelper;
import au.com.ordermate.version.OMVersion;
import au.com.ordermate.version.VersionStability;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.misc.SystemVersionHistory;
import org.apache.logging.log4j.Level;
import waitermate.guikit.dialogs.PopupWindow;

public class WhatsNew {
    private OMVersion[] notableVersions = new OMVersion[]{new OMVersion(4, 0, 6, VersionStability.Stable, "")};
    private static boolean needsToShow = false;

    public static boolean needsToShow() {
        return needsToShow;
    }

    public boolean hasWhatsNew() {
        SystemVersionHistory history = (SystemVersionHistory)PersistenceManager.getObject(SystemVersionHistory.class, (String)Query.select(SystemVersionHistory.class).orderBy(SystemVersionHistory.Properties.ID, true).toString());
        if (history != null) {
            String versionString = history.getVersionString();
            for (OMVersion version : this.notableVersions) {
                if (!versionString.startsWith(version.getRevision())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldShowWhatsNew() {
        boolean check;
        boolean bl = check = !Config.isDebuging();
        if (!check) {
            return false;
        }
        SystemVersionHistory history = (SystemVersionHistory)PersistenceManager.getObject(SystemVersionHistory.class, (String)Query.select(SystemVersionHistory.class).orderBy(SystemVersionHistory.Properties.ID, true).toString());
        if (history != null) {
            String versionString = history.getVersionString();
            for (OMVersion version : this.notableVersions) {
                if (!versionString.startsWith(version.getRevision())) continue;
                needsToShow = DateTimeUtils.dateIsToday((Date)history.getFirstUsed());
            }
        }
        return needsToShow;
    }

    public void showWhatsNew() {
        needsToShow = false;
        if (SwingUtilities.isEventDispatchThread()) {
            this.display();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WhatsNew.this.display();
                }
            });
        }
    }

    private void display() {
        PopupWindow poppy = new PopupWindow();
        ImageIcon icon = null;
        try {
            SystemVersionHistory history = (SystemVersionHistory)PersistenceManager.getObject(SystemVersionHistory.class, (String)Query.select(SystemVersionHistory.class).orderBy(SystemVersionHistory.Properties.ID, true).toString());
            icon = new ImageIcon(this.getClass().getResource("/" + this.getClass().getName().replace(".", "/") + ".png"));
            Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            rect.width = (int)((double)rect.width * 0.8);
            rect.height = (int)((double)rect.height * 0.8);
            if (icon.getIconWidth() > rect.width || icon.getIconHeight() > rect.height) {
                icon = new ImageIcon(new ImageHelper().fitImageTo(icon.getImage(), rect.width, rect.height));
            }
            poppy.setComponent((JComponent)new JLabel(icon));
            poppy.setCancelButtonVisible(false);
            poppy.setText("OrderMate was upgraded to " + OrderMate.VERSION + " on " + DateTimeUtils.getVeryShortDateFormat().format(history.getFirstUsed()));
            poppy.start();
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.WARN, "Cannot show what's new", (Throwable)ex);
        }
    }
}

