/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.overview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import waitermate.LoginManager;
import waitermate.gui.overview.OverviewPage;
import waitermate.gui.overview.OverviewState;
import waitermate.gui.overview.WaiterMateOverviewPanel;
import waitermate.gui.overview.WaiterMateOverviewTab;
import waitermate.gui.overview.flashreport.WaitermateFlashReportPage;
import waitermate.gui.overview.userreport.WaitermateUserReportPage;
import waitermate.guikit.ScreenResource;

public class WaiterMateOverview
implements HierarchyBoundsListener {
    private final int FULL_WIDTH = 740;
    private final long ANIM_DELAY = 50L;
    private WaiterMateOverviewTab tab;
    private WaiterMateOverviewPanel gui;
    private List<OverviewPage> pages;
    private OverviewState currentState = OverviewState.Closed;
    private OverviewPage currentPage;
    private int height = 0;
    private int yLoc = 0;
    private JComponent relativeComponent;
    private Timer animTimer;

    public WaiterMateOverview() {
        this.tab = new WaiterMateOverviewTab();
        this.tab.openTab.connect((Object)this, "gotTriggerTab");
        this.tab.setCloseVisible(false);
        this.gui = new WaiterMateOverviewPanel();
        this.gui.changePage.connect((Object)this, "gotPage");
        this.pages = new ArrayList<OverviewPage>();
        this.pages.add(new WaitermateFlashReportPage());
        this.pages.add(new WaitermateUserReportPage());
        this.gui.setPages(this.pages);
    }

    public boolean gotPage(OverviewPage page) {
        if (LoginManager.getInstance().hasPermission(page.getPermission())) {
            if (this.currentPage != null) {
                this.currentPage.stopPage();
            }
            this.currentPage = page;
            this.currentPage.startPage();
            this.currentPage.overviewChanged(this.currentState);
            this.gui.setPage(this.currentPage);
            return true;
        }
        this.gui.setPage(null);
        return false;
    }

    public void gotTriggerTab(Boolean open) {
        if (OverviewState.Closed.equals((Object)this.currentState)) {
            for (OverviewPage nextPage : this.pages) {
                if (this.gotPage(nextPage)) break;
            }
            this.goHalfway();
        } else if (OverviewState.Half.equals((Object)this.currentState)) {
            if (Boolean.TRUE.equals(open)) {
                this.goOpen();
            } else {
                this.goClosed();
            }
        } else if (OverviewState.Open.equals((Object)this.currentState)) {
            this.goHalfway();
        }
        this.gui.setVisible(true);
    }

    private void goClosed() {
        this.gui.setVisible(false);
        this.gui.setSize(0, this.height);
        this.tab.setOpenVisible(true);
        this.tab.setCloseVisible(false);
        this.setState(OverviewState.Closed);
        this.repositionGuiComponents();
    }

    private void goHalfway() {
        this.gui.setVisible(true);
        this.gui.setSize(new Dimension(370, this.height));
        this.tab.setOpenVisible(true);
        this.tab.setCloseVisible(true);
        this.setState(OverviewState.Half);
        this.repositionGuiComponents();
    }

    private void goOpen() {
        this.gui.setVisible(true);
        this.gui.setSize(new Dimension(740, this.height));
        this.tab.setOpenVisible(false);
        this.tab.setCloseVisible(true);
        this.setState(OverviewState.Open);
        this.repositionGuiComponents();
    }

    private void setState(OverviewState state) {
        this.currentState = state;
        if (this.currentPage != null) {
            this.currentPage.overviewChanged(state);
        }
    }

    public void setVisible(boolean value) {
        if (value && this.height == 0) {
            this.adjustSizes();
        }
        this.goClosed();
        this.gui.setVisible(false);
        if (value) {
            this.tab.setVisible(true);
        } else {
            this.tab.setVisible(false);
        }
    }

    public void install(JComponent newRelativeComponent) {
        if (this.relativeComponent != null) {
            this.relativeComponent.removeHierarchyBoundsListener(this);
        }
        this.relativeComponent = newRelativeComponent;
        newRelativeComponent.addHierarchyBoundsListener(this);
        this.repositionGuiComponents();
        ScreenResource.getGlassPanel().add((Component)this.tab);
        this.tab.setVisible(false);
        ScreenResource.getGlassPanel().add((Component)this.gui);
    }

    private void repositionGuiComponents() {
        if (this.animTimer != null) {
            this.animTimer.cancel();
            this.animTimer = null;
        }
        Dimension frameSize = ScreenResource.getGlassPanel().getTopLevelAncestor().getSize();
        Point guiLoc = new Point(frameSize.width - this.gui.getWidth(), this.yLoc);
        Point tabLoc = new Point(frameSize.width - this.tab.getWidth() + 5, this.yLoc + this.height / 3);
        tabLoc.x = (int)(tabLoc.getX() - (double)this.gui.getWidth());
        this.animTimer = new Timer();
        this.animTimer.schedule((TimerTask)new OverviewMover(tabLoc, guiLoc), 0L, 50L);
    }

    @Override
    public void ancestorMoved(HierarchyEvent e) {
        this.adjustSizes();
    }

    @Override
    public void ancestorResized(HierarchyEvent e) {
        this.adjustSizes();
    }

    public void adjustSizes() {
        if (!this.relativeComponent.isDisplayable()) {
            return;
        }
        JFrame frame = (JFrame)this.relativeComponent.getTopLevelAncestor();
        if (this.relativeComponent.isShowing()) {
            this.height = this.relativeComponent.getHeight();
            this.yLoc = this.relativeComponent.getLocationOnScreen().y - frame.getContentPane().getLocationOnScreen().y;
            this.repositionGuiComponents();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaiterMateOverview.this.setVisible(false);
                }
            });
        }
    }

    class OverviewMover
    extends TimerTask {
        int count = 1;
        private final Point finalGui;
        private final Point finalTab;

        OverviewMover(Point endTabLoc, Point endGuiLoc) {
            this.finalTab = endTabLoc;
            this.finalGui = endGuiLoc;
        }

        @Override
        public void run() {
            final Point guiLoc = new Point(this.finalGui.x - (this.finalGui.x - WaiterMateOverview.this.gui.getX()) / this.count, this.finalGui.y - (this.finalGui.y - WaiterMateOverview.this.gui.getY()) / this.count);
            final Point tabLoc = new Point(this.finalTab.x - (this.finalTab.x - WaiterMateOverview.this.tab.getX()) / this.count, this.finalTab.y - (this.finalTab.y - WaiterMateOverview.this.tab.getY()) / this.count);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaiterMateOverview.this.gui.setLocation(guiLoc);
                    WaiterMateOverview.this.tab.setLocation(tabLoc);
                }
            });
            ++this.count;
            if (this.count == 10) {
                if (WaiterMateOverview.this.animTimer != null) {
                    WaiterMateOverview.this.animTimer.cancel();
                    WaiterMateOverview.this.animTimer = null;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WaiterMateOverview.this.gui.setLocation(OverviewMover.this.finalGui);
                        WaiterMateOverview.this.tab.setLocation(OverviewMover.this.finalTab);
                    }
                });
            }
        }
    }
}

