/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.overview.flashreport;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.internationalization.Internationalization;
import waitermate.gui.screens.admin.reports.WaitermateReport;

public class OpenAccountReportCompiler
implements WaitermateReport {
    private DecimalFormat priceFormat = new DecimalFormat("0.00");
    private Object[][] currentResults;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performReport() {
        ObjectQuery query = this.getQuery();
        Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null);
        OpenAccountReportCompiler openAccountReportCompiler = this;
        synchronized (openAccountReportCompiler) {
            this.currentResults = results;
        }
    }

    @Override
    public synchronized List<String> getStringData() {
        if (this.currentResults == null) {
            return null;
        }
        ArrayList<String> reportList = new ArrayList<String>();
        for (Object[] nextResult : this.currentResults) {
            this.process(nextResult, reportList);
        }
        return reportList;
    }

    private void process(Object[] result, List<String> reportList) {
        AccountType accType = (AccountType)AccountType.getRegister().get(String.valueOf(result[0]));
        StringBuilder SB = new StringBuilder("**");
        SB.append(result[1]).append(" ").append(accType.getCapitilizedLabel()).append("**");
        reportList.add(SB.toString());
        reportList.add(this.formatPrice("Avg", result[2]));
        reportList.add(this.formatPrice("Total", result[3]));
        String patrons = this.getPatrons(result[4], accType);
        if (patrons != null) {
            reportList.add(patrons);
        }
        reportList.add(this.formatTime("Avg Time", result[5]));
        reportList.add(this.formatTime("Longest Time", result[6]));
    }

    private String formatPrice(String label, Object value) {
        StringBuilder SB = new StringBuilder(label);
        SB.append(": ").append(Internationalization.getLiteralFor((String)"DOLLAR_SIGN")).append(this.priceFormat.format(value));
        return SB.toString();
    }

    private String formatTime(String label, Object secondsTime) {
        StringBuilder SB = new StringBuilder(label);
        SB.append(": ");
        long value = secondsTime instanceof BigDecimal ? ((BigDecimal)secondsTime).longValue() : ((Long)secondsTime).longValue();
        SB.append(DateTimeUtils.getHoursMinutesForPeriod((long)(value * 1000L)));
        return SB.toString();
    }

    private String getPatrons(Object result, AccountType accType) {
        if (DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons()) || AccountType.tableType.equals((Object)accType)) {
            StringBuilder SB = new StringBuilder(Internationalization.getLiteralFor((String)"COVERS") + ": ");
            SB.append(result);
            return SB.toString();
        }
        return null;
    }

    ObjectQuery getQuery() {
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        ObjectQuery query = Query.select((PropertiedObject.Property)Account.Properties.ACCOUNT_TYPE, (String)"acc_type").count(Account.class, "num_open").avg(Account.Properties.SAVED_TOTAL, "average").sum(Account.Properties.SAVED_TOTAL, "total").sum(Account.Properties.NUM_PATRONS, "num_patrons").selectFunc("AVG(TO_SECONDS(Now()) - TO_SECONDS(sales_account.Creation_time)) as average_average").selectFunc("MAX(TO_SECONDS(Now()) - TO_SECONDS(sales_account.Creation_time)) as longest_time").greaterThanOrEqual(Account.Properties.CREATION_DATE_TIME, cal.getTime(), SQLDateType.DATE).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).groupBy(Account.Properties.ACCOUNT_TYPE);
        return query;
    }
}

