/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.overview.flashreport;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import waitermate.gui.overview.OverviewPage;
import waitermate.gui.overview.OverviewState;
import waitermate.gui.overview.WMTwinReportPanel;
import waitermate.gui.overview.flashreport.OpenAccountReportCompiler;
import waitermate.gui.overview.flashreport.TodayStatusReportCompiler;
import waitermate.gui.overview.states.TableStatesReportCompiler;

public class WaitermateFlashReportPage
implements OverviewPage {
    private static final long DELAY = 30000L;
    private static final String LABEL = "Flash Report";
    private static final String ICON = "/waitermate/images/fastPay.png";
    private OpenAccountReportCompiler openCompiler;
    private TodayStatusReportCompiler todayCompiler;
    private TableStatesReportCompiler stateCompiler;
    private WMTwinReportPanel panel = new WMTwinReportPanel("Open Accounts", "Today's Status");
    private Timer timer;
    private FlashReportUpdater updater;

    @Override
    public void overviewChanged(OverviewState state) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (!OverviewState.Closed.equals((Object)state)) {
            boolean half = OverviewState.Half.equals((Object)state);
            this.panel.showHalf(half);
            this.updater = new FlashReportUpdater(half);
            this.timer = new Timer();
            this.timer.schedule((TimerTask)this.updater, 0L, 30000L);
        }
    }

    @Override
    public void startPage() {
        if (this.openCompiler == null) {
            this.openCompiler = new OpenAccountReportCompiler();
            this.todayCompiler = new TodayStatusReportCompiler();
            this.stateCompiler = new TableStatesReportCompiler();
        }
    }

    @Override
    public void stopPage() {
        if (this.timer != null) {
            this.timer.cancel();
            this.updater = null;
            this.timer = null;
        }
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public String getIcon() {
        return ICON;
    }

    @Override
    public Permission getPermission() {
        return AllPermissions.VIEW_ACCOUNTS_TAKINGS;
    }

    class FlashReportUpdater
    extends TimerTask {
        private final boolean half;

        public FlashReportUpdater(boolean doHalf) {
            this.half = doHalf;
        }

        @Override
        public void run() {
            List<String> openData = null;
            List<String> todayData = null;
            WaitermateFlashReportPage.this.openCompiler.performReport();
            WaitermateFlashReportPage.this.stateCompiler.performReport();
            openData = WaitermateFlashReportPage.this.openCompiler.getStringData();
            openData.addAll(WaitermateFlashReportPage.this.stateCompiler.getStringData());
            if (!this.half) {
                WaitermateFlashReportPage.this.todayCompiler.performReport();
                todayData = WaitermateFlashReportPage.this.todayCompiler.getStringData();
            }
            WaitermateFlashReportPage.this.panel.dataUpdated(openData, todayData);
        }
    }
}

