/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.overview.states;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import waitermate.gui.screens.admin.reports.WaitermateReport;

public class TableStatesReportCompiler
implements WaitermateReport {
    private Object[][] cachedData;

    @Override
    public void performReport() {
        ObjectQuery query = this.getQuery();
        this.cachedData = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null);
    }

    @Override
    public List<String> getStringData() {
        List<String> reportData = this.compileData();
        return reportData;
    }

    private List<String> compileData() {
        if (this.cachedData == null) {
            return null;
        }
        ArrayList<String> data = new ArrayList<String>();
        data.add("<h2>Table States</h2>");
        for (Object[] nextRow : this.cachedData) {
            StringBuilder SB = new StringBuilder();
            LogicalTableState state = (LogicalTableState)PersistenceManager.getByID((long)((Long)nextRow[0]), LogicalTableState.class);
            if (state.getImage() != null) {
                SB.append("*PIC:").append(state.getIcon()).append(":PIC* ");
            }
            SB.append("<b>").append(state.getLabel()).append(":</b>");
            SB.append("<br>Total: ").append(nextRow[1]);
            SB.append("<br>Avg Time: ").append(this.formatTime(nextRow[2]));
            SB.append("<br>Max Time: ").append(this.formatTime(nextRow[3]));
            SB.append("<br>");
            data.add(SB.toString());
        }
        return data;
    }

    private String formatTime(Object value) {
        long millis = value instanceof BigDecimal ? ((BigDecimal)value).longValue() : ((Long)value).longValue();
        millis = System.currentTimeMillis() - millis;
        return DateTimeUtils.toHoursMinutes((long)millis);
    }

    private ObjectQuery getQuery() {
        return Query.select((PropertiedObject.Property)LogicalTableState.Properties.ID).count(LogicalTable.class, "num_in_state").avg(LogicalTable.Properties.STATE_TIME, "average_time").min(LogicalTable.Properties.STATE_TIME, "longest_time").linkUsing(LogicalTable.Properties.TABLE_STATE).groupBy(LogicalTableState.Properties.ID).orderBy(LogicalTableState.Properties.SEQUENCE).active(LogicalTable.class);
    }
}

