/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import ordermate.database.users.Permission;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.signals.Signal;
import waitermate.failover.FailoverRestriction;
import waitermate.failover.WaitermateFailover;

public abstract class AbstractAdminPanel
extends CustomScrollPane
implements ActionListener {
    private DefaultScrollPaneModel scrollModel = (DefaultScrollPaneModel)this.getModel();

    public AbstractAdminPanel() {
        super((CustomScrollPaneModel)new DefaultScrollPaneModel(3, 5));
    }

    public AbstractAdminPanel(CustomScrollPaneModel cspm) {
        super(cspm);
    }

    protected JComponent addButton(String name, Icon icon, Permission permission, Signal signalToEmit) {
        return this.addButton(name, icon, permission, signalToEmit, FailoverRestriction.Enabled);
    }

    protected JComponent addButton(final String name, Icon icon, Permission permission, final Signal signalToEmit, final FailoverRestriction restriction) {
        JButton adminButton = new JButton(name);
        adminButton.setRolloverEnabled(false);
        JButton toReturn = adminButton;
        adminButton.setIcon(icon);
        adminButton.setHorizontalAlignment(2);
        adminButton.setBorder(new EmptyBorder(5, 20, 5, 5));
        adminButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WaitermateFailover.isActive() && FailoverRestriction.Disabled.equals((Object)restriction)) {
                    WaitermateFailover.getInstance().showDisallowAction(name);
                    return;
                }
                signalToEmit.emit();
            }
        });
        if (permission != null) {
            toReturn = new StandardSecurityDecorator((JComponent)adminButton, permission);
            this.scrollModel.addComponent((Component)toReturn);
        } else {
            this.scrollModel.addComponent((Component)adminButton);
        }
        return toReturn;
    }

    protected JComponent addButton(String name, JComponent button, Permission permission) {
        JComponent adminButton = button;
        adminButton.setName(name);
        JComponent toReturn = adminButton;
        if (permission != null) {
            toReturn = new StandardSecurityDecorator(adminButton, permission);
            this.scrollModel.addComponent((Component)toReturn);
        } else {
            this.scrollModel.addComponent((Component)adminButton);
        }
        return toReturn;
    }

    protected void start() {
    }
}

