/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.Admin;
import waitermate.gui.screens.admin.ConditionalAdminTab;
import waitermate.gui.screens.admin.action.ActionAdmin;
import waitermate.gui.screens.admin.barstock.BarstockAdmin;
import waitermate.gui.screens.admin.customer.CustomerAdmin;
import waitermate.gui.screens.admin.daily.DailyAdmin;
import waitermate.gui.screens.admin.integration.IntegrationAdmin;
import waitermate.gui.screens.admin.printer.PrinterAdmin;
import waitermate.gui.screens.admin.stockadmin.StockAdmin;
import waitermate.gui.screens.admin.system.SystemAdmin;
import waitermate.gui.screens.admin.useradmin.UserAdmin;

public class AdminCategoryPanel
extends JTabbedPane {
    public final Signal back = Signals.createSignal();
    public final Signal logout = Signals.createSignal();
    private final List<AbstractAdminScreen> panels = new ArrayList<AbstractAdminScreen>();
    private Admin admin;

    AdminCategoryPanel() {
        OrderMateTheme.setupTabbedPane((JTabbedPane)this);
        this.setFont(OrderMateTheme.getLargeFont());
        DailyAdmin dailyAdmin = new DailyAdmin(this);
        dailyAdmin.logout.connect(this.logout);
        this.panels.add(dailyAdmin);
        this.panels.add(new SystemAdmin());
        this.panels.add(new CustomerAdmin());
        this.panels.add(new PrinterAdmin());
        this.panels.add(new UserAdmin());
        this.panels.add(new IntegrationAdmin());
        this.panels.add(new StockAdmin());
        this.panels.add(new ActionAdmin());
        this.panels.add(new BarstockAdmin());
        for (AbstractAdminScreen panel : this.panels) {
            this.addTab(panel);
        }
    }

    AdminCategoryPanel(Admin admin) {
        this();
        this.admin = admin;
    }

    public Admin getAdminScreen() {
        return this.admin;
    }

    private void addTab(AbstractAdminScreen adminScreen) {
        if (adminScreen instanceof ConditionalAdminTab && !((ConditionalAdminTab)((Object)adminScreen)).checkTabDisplayCondition()) {
            return;
        }
        adminScreen.back.connect(this.back);
        JComponent gui = adminScreen.getMainArea();
        this.addTab(adminScreen.getCategoryName(), gui);
    }

    void startTabs() {
        Iterator<AbstractAdminScreen> it = this.panels.iterator();
        while (it.hasNext()) {
            it.next().display();
        }
    }
}

