/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.barstock;

import au.com.ordermate.util.image.IconLoader;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import ordermate.database.integration.BarStockConfiguration;
import ordermate.database.misc.SystemProperty;
import ordermate.internationalization.Internationalization;
import waitermate.WaiterMate;
import waitermate.gui.screens.admin.AbstractAdminScreen;
import waitermate.gui.screens.admin.ConditionalAdminTab;
import waitermate.gui.screens.admin.barstock.BarstockAdminPanel;
import waitermate.guikit.dialogs.Dialogs;

public class BarstockAdmin
extends AbstractAdminScreen
implements ConditionalAdminTab {
    private BarstockAdminPanel gui = new BarstockAdminPanel();

    public BarstockAdmin() {
        this.gui.startBarstock.connect((Object)this, "gotStartBarstock");
        this.gui.closeBarstock.connect((Object)this, "gotCloseBarstock");
        this.gui.crashBarstock.connect((Object)this, "gotCrashBarstock");
    }

    public JComponent getMainArea() {
        return this.gui;
    }

    @Override
    public String getCategoryName() {
        return Internationalization.getLiteralFor((String)"BARSTOCK");
    }

    @Override
    public Icon getCategoryIcon() {
        return IconLoader.get((String)"/waitermate/images/barStockOn.png");
    }

    public void gotStartBarstock() {
        try {
            BarStockConfiguration.getInstance().remoteStart();
        }
        catch (IOException e) {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"AN_ERROR_OCCURED_COMMUNICATION_WITH_BARSTOCK_SYSTEM") + "<br>" + Internationalization.getLiteralFor((String)"PLEASE_CHECK_THAT_THE_SYSTEM_IS_TURNED_ON")), (String)Internationalization.getLiteralFor((String)"BARSTOCK_ERROR"));
            WaiterMate.LOG.warn("Error communicating with barstock", (Throwable)e);
        }
    }

    public void gotCloseBarstock() {
        try {
            BarStockConfiguration.getInstance().remoteStop();
        }
        catch (IOException e) {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"AN_ERROR_OCCURED_COMMUNICATION_WITH_BARSTOCK_SYSTEM") + "<br>" + Internationalization.getLiteralFor((String)"PLEASE_CHECK_THAT_THE_SYSTEM_IS_TURNED_ON")), (String)Internationalization.getLiteralFor((String)"BARSTOCK_ERROR"));
            WaiterMate.LOG.warn("Error communicating with barstock", (Throwable)e);
        }
    }

    public void gotCrashBarstock() {
        try {
            BarStockConfiguration.getInstance().remoteCrash();
        }
        catch (IOException e) {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"AN_ERROR_OCCURED_COMMUNICATION_WITH_BARSTOCK_SYSTEM") + "<br>" + Internationalization.getLiteralFor((String)"PLEASE_CHECK_THAT_THE_SYSTEM_IS_TURNED_ON")), (String)Internationalization.getLiteralFor((String)"BARSTOCK_ERROR"));
            WaiterMate.LOG.warn("Error communicating with barstock", (Throwable)e);
        }
    }

    @Override
    public boolean checkTabDisplayCondition() {
        return SystemProperty.getInstance().isBarStockEnabled();
    }
}

