/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.clockonclockoff;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.screens.admin.clockonclockoff.TimesheetRenderer;

class ClockOnClockOffPanel
extends JPanel
implements ActionListener {
    public final Signal clockOn = Signals.createSignal();
    public final Signal clockOff = Signals.createSignal();
    private JButton clockOnOffButton;
    private JLabel suPrompt;
    private JLabel explanation;
    private StandardSecurityDecorator timesheetTotalTimeSecurityDecorator;
    private JLabel timesheetTotalLbl;
    private StandardSecurityDecorator timesheetSecurityDecorator;
    private JPanel timesheetPanel;
    private StandardSecurityDecorator btnSecurityDecorator;
    private RendererScrollPaneModel timesheetScrollModel;
    private TimesheetRenderer timesheetRenderer;
    private ClockOnOffSetup clockOnOrOffAction;
    private static final int ROWS_PER_PAGE = 10;

    public ClockOnClockOffPanel() {
        this(ClockOnOffSetup.CLOCK_ON);
    }

    public ClockOnClockOffPanel(ClockOnOffSetup setupForClockOnOrOff) {
        super((LayoutManager)new GraphPaperLayout(new Dimension(20, 20)));
        this.clockOnOrOffAction = setupForClockOnOrOff;
        this.buildGUI();
    }

    private void buildGUI() {
        this.clockOnOffButton = new JButton(this.getClockOnOffText(), IconLoader.get((String)"/waitermate/images/clock.png"));
        this.clockOnOffButton.addActionListener(this);
        this.btnSecurityDecorator = new StandardSecurityDecorator((JComponent)this.clockOnOffButton, this.getPermissionRequired());
        this.add((Component)this.btnSecurityDecorator, new Rectangle(1, 12, 7, 3));
        this.explanation = new JLabel();
        this.add((Component)this.explanation, new Rectangle(1, 4, 8, 8));
        this.suPrompt = new JLabel(this.getSUPromptText());
        this.add((Component)this.suPrompt, new Rectangle(1, 16, 8, 4));
        this.buildTimeSheetPanel();
    }

    private void buildTimeSheetPanel() {
        this.timesheetRenderer = new TimesheetRenderer();
        this.timesheetScrollModel = new RendererScrollPaneModel((Renderer)this.timesheetRenderer);
        this.timesheetScrollModel.setColumns(1);
        this.timesheetScrollModel.setRowsPerPage(10);
        this.add((Component)this.getTimeSheetSecurityDecorator(), new Rectangle(9, 3, 11, 15));
        CustomScrollPane scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.timesheetScrollModel);
        scrollPane.setDecorationLocation(DecoratorLocation.East);
        EmptyBorder buffer = new EmptyBorder(5, 5, 5, 5);
        LineBorder line = new LineBorder(new Color(134, 134, 150), 2);
        CompoundBorder inner = new CompoundBorder(buffer, line);
        CompoundBorder border = new CompoundBorder(inner, buffer);
        this.getTimeSheetPanel().setBorder(border);
        this.getTimeSheetPanel().add((Component)scrollPane, "Center");
        JPanel header = new JPanel(new FlowLayout(0));
        int WIDTH = 120;
        JLabel department = new JLabel(Internationalization.getLiteralFor((String)"DEPARTMENT"));
        department.setHorizontalAlignment(2);
        department.setPreferredSize(new Dimension(120, 14));
        JLabel timeIn = new JLabel(Internationalization.getLiteralFor((String)"CLOCKED_ON"));
        timeIn.setHorizontalAlignment(2);
        timeIn.setPreferredSize(new Dimension(120, 14));
        JLabel timeOut = new JLabel(Internationalization.getLiteralFor((String)"CLOCKED_OFF"));
        timeOut.setHorizontalAlignment(2);
        timeOut.setPreferredSize(new Dimension(120, 14));
        JLabel totalShift = new JLabel(Internationalization.getLiteralFor((String)"TOTAL_TIME_SHIFT"));
        totalShift.setHorizontalAlignment(2);
        header.add(department);
        header.add(timeIn);
        header.add(timeOut);
        header.add(totalShift);
        this.getTimeSheetPanel().add((Component)header, "First");
        this.add((Component)this.getTimeSheetTotalTimeSecurityDecorator(), new Rectangle(9, 18, 9, 2));
    }

    private JPanel getTimeSheetPanel() {
        if (this.timesheetPanel == null) {
            this.timesheetPanel = new JPanel(new BorderLayout());
            this.timesheetPanel.setName("TimeSheetPanel");
        }
        return this.timesheetPanel;
    }

    private StandardSecurityDecorator getTimeSheetTotalTimeSecurityDecorator() {
        if (this.timesheetTotalTimeSecurityDecorator == null) {
            this.timesheetTotalLbl = new JLabel("TimeTotal"){

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(true);
                }
            };
            this.timesheetTotalLbl.setHorizontalAlignment(4);
            this.timesheetTotalTimeSecurityDecorator = new StandardSecurityDecorator((JComponent)this.timesheetTotalLbl, AllPermissions.PRINT_TIMESHEET);
            this.timesheetTotalTimeSecurityDecorator.setSecurityEnabled(false);
            this.timesheetTotalTimeSecurityDecorator.setSecurityVisible(true);
            this.timesheetTotalTimeSecurityDecorator.setSecurityOn(true);
        }
        return this.timesheetTotalTimeSecurityDecorator;
    }

    private StandardSecurityDecorator getTimeSheetSecurityDecorator() {
        if (this.timesheetSecurityDecorator == null) {
            this.timesheetSecurityDecorator = new StandardSecurityDecorator((JComponent)this.getTimeSheetPanel(), AllPermissions.PRINT_TIMESHEET);
            this.timesheetSecurityDecorator.setSecurityVisible(true);
            this.timesheetSecurityDecorator.setSecurityEnabled(true);
            this.timesheetSecurityDecorator.setSecurityOn(true);
        }
        return this.timesheetSecurityDecorator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.clockOnOffButton) {
            if (this.clockOnOrOffAction.equals((Object)ClockOnOffSetup.CLOCK_ON)) {
                this.clockOn.emit();
            } else {
                this.clockOff.emit();
            }
        }
    }

    boolean canClockOnOff() {
        return this.clockOnOffButton.isEnabled();
    }

    private String getClockOnOffText() {
        if (this.clockOnOrOffAction.equals((Object)ClockOnOffSetup.CLOCK_ON)) {
            return Internationalization.getLiteralFor((String)"CLOCK_ON");
        }
        return Internationalization.getLiteralFor((String)"CLOCK_OFF");
    }

    private Permission getPermissionRequired() {
        if (this.clockOnOrOffAction.equals((Object)ClockOnOffSetup.CLOCK_ON)) {
            return AllPermissions.CLOCK_ON;
        }
        return AllPermissions.CLOCK_OFF;
    }

    public ClockOnOffSetup getClockOnOrOffAction() {
        return this.clockOnOrOffAction;
    }

    public void setupClockOnOrOffPanel(ClockOnOffSetup clockOnOrOff, List<FinanceTimesheet> timesheetList) {
        this.clockOnOrOffAction = clockOnOrOff;
        this.btnSecurityDecorator.setPermission(this.getPermissionRequired());
        this.explanation.setText(this.getExplanationText(timesheetList));
        this.suPrompt.setText(this.getSUPromptText());
        this.clockOnOffButton.setText(this.getClockOnOffText());
        this.suPrompt.setVisible(!LoginManager.getInstance().hasPermission(this.getPermissionRequired()));
        this.setTotalHoursLabel(timesheetList);
        this.timesheetScrollModel.removeAllObjects();
        this.timesheetScrollModel.setObjects(timesheetList);
        boolean isTimeSheetForCurrentUserAllowed = LoginManager.getInstance().hasPermission(this.getTimeSheetSecurityDecorator().getPermission());
        this.timesheetTotalLbl.setVisible(isTimeSheetForCurrentUserAllowed);
    }

    private String getExplanationText(List<FinanceTimesheet> timesheetList) {
        if (this.clockOnOrOffAction.equals((Object)ClockOnOffSetup.CLOCK_ON)) {
            return "<html><h2>" + Internationalization.getLiteralFor((String)"YOU_ARE_CURRENTLY") + " <font color=\"red\">" + Internationalization.getLiteralFor((String)"OFF") + "</font></h2>" + Internationalization.getLiteralFor((String)"PRESS_THE_CLOCK_ON_BUTTON_TO_BEGIN_YOUR_SHIFT") + "<br>" + Internationalization.getLiteralFor((String)"PLEASE_ENSURE_YOU_CLOCK_OFF_AGAIN_AT_THE_END_OF_YOUR_SHIFT") + "</html>";
        }
        StringBuilder expText = new StringBuilder();
        expText.append("<html><h2>" + Internationalization.getLiteralFor((String)"YOU_ARE_CURRENTLY_CLOCKED") + " <font color=\"green\">" + Internationalization.getLiteralFor((String)"ON") + "</font></h2>");
        if (!timesheetList.isEmpty()) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm");
            FinanceTimesheet lastTimeSheet = timesheetList.get(timesheetList.size() - 1);
            expText.append(Internationalization.getLiteralFor((String)"CLOCK_ON_TIME") + ": " + dateFormatter.format(lastTimeSheet.getTimeIn()) + "<br><br>");
            expText.append(Internationalization.getLiteralFor((String)"TOTAL_SHIFT_TIME") + ": " + DateTimeUtils.getHoursMinutesForPeriod((long)DateTimeUtils.getDifferenceInMillisecs((Date)lastTimeSheet.getTimeIn(), (Date)new Date())) + "<br>");
        }
        expText.append("<br><br>" + Internationalization.getLiteralFor((String)"PRESS_THE_CLOCK_OFF_BUTTON_TO_END_YOUR_SHIFT") + "<br>");
        return expText.toString();
    }

    private String getSUPromptText() {
        if (this.clockOnOrOffAction.equals((Object)ClockOnOffSetup.CLOCK_ON)) {
            return "<html><font color=\"red\">" + Internationalization.getLiteralFor((String)"PLEASE_GET_YOUR_MANAGER_TO_SWIPE_THEIR_CARD_TO_ENABLE_YOU_TO_CLOCK_ON_1") + "<br>" + Internationalization.getLiteralFor((String)"PLEASE_GET_YOUR_MANAGER_TO_SWIPE_THEIR_CARD_TO_ENABLE_YOU_TO_CLOCK_ON_2") + "</font></html>";
        }
        return "<html><font color=\"red\">" + Internationalization.getLiteralFor((String)"PLEASE_GET_YOUR_MANAGER_TO_SWIPE_THEIR_CARD_TO_ENABLE_YOU_TO_CLOCK_OFF_1") + "<br>" + Internationalization.getLiteralFor((String)"PLEASE_GET_YOUR_MANAGER_TO_SWIPE_THEIR_CARD_TO_ENABLE_YOU_TO_CLOCK_OFF_2") + "</font></html>";
    }

    private void setTotalHoursLabel(List<FinanceTimesheet> timesheetList) {
        long totalTime = 0L;
        if (!timesheetList.isEmpty()) {
            for (FinanceTimesheet timesheet : timesheetList) {
                if (timesheet.getTimeOut() == null) continue;
                totalTime += DateTimeUtils.getDifferenceInMillisecs((Date)timesheet.getTimeIn(), (Date)timesheet.getTimeOut());
            }
        }
        this.timesheetTotalLbl.setText(Internationalization.getLiteralFor((String)"TOTAL_TIME") + ": " + DateTimeUtils.getHoursMinutesForPeriod((long)totalTime) + " \n");
    }

    public static enum ClockOnOffSetup {
        CLOCK_ON,
        CLOCK_OFF;

    }
}

