/*
 * Decompiled with CFR 0.152.
 */
package waitermate.gui.screens.admin.clockonclockoff;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import com.digitalpersona.onetouch.DPFPSample;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import ordermate.OrderMate;
import ordermate.database.Lockable;
import ordermate.database.departments.Department;
import ordermate.database.finance.timesheet.FinanceTimesheetHelper;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.department.DepartmentQueries;
import ordermate.database.queries.sales.PhoneAccountQueries;
import ordermate.database.sales.Delivery;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.LoginManager;
import waitermate.gui.WaitermateGuiHandler;
import waitermate.gui.fingerprint.FingerprintDespatch;
import waitermate.gui.fingerprint.VerifyFingerprint;
import waitermate.gui.screens.admin.clockonclockoff.ClockOnClockOffPanel;
import waitermate.gui.screens.admin.clockonclockoff.DepartmentComboPanel;
import waitermate.gui.screens.admin.clockonclockoff.WaitermateFingerprintListener;
import waitermate.gui.screens.selectaccount.phone.drivers.AutoAssignDriverSelector;
import waitermate.gui.screens.selectaccount.phone.drivers.WMDeliveryGuiHelper;
import waitermate.gui.screens.selectaccount.phone.settle.SettleDeliveryAccounts;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.dialogs.Dialogs;

public class ClockOnClockOffScreen
extends AbstractScreen {
    public static final String RETURN_DRIVER = Internationalization.getLiteralFor((String)"RETURN_DRIVER");
    public static final String UNASSIGN_ORDERS = Internationalization.getLiteralFor((String)"UNASSIGN_ORDERS");
    private static ClockOnClockOffScreen instance;
    private DepartmentComboPanel deptPanel;
    private ClockOnClockOffPanel clockOnOffPanel;
    private NavBar nav;
    private User loggedInUser;
    private User modifyUser;
    private VerifyFingerprint verifyFingerprint;
    private Signal done;
    private final Signal clockOnVerified = Signals.createSignal(Boolean.class, (String)"verified");
    private final Signal clockOffVerified = Signals.createSignal(Boolean.class, (String)"verified");
    private final Signal gotFingerprint = Signals.createSignal(DPFPSample.class, (String)"sample");
    private final Signal printTimeSheetSig = Signals.createSignal();
    private final Signal printLastWeeksTimeSheetSig = Signals.createSignal();
    private final SettleDeliveryAccounts settle;
    private final WMDeliveryGuiHelper deliveryHelper;
    private Object fingerprintSync = new Object();
    private boolean isProcessing = false;
    private boolean requireFingerprint = true;
    private DPFPSample suppliedSample = null;

    protected ClockOnClockOffScreen() {
        this.clockOnOffPanel = new ClockOnClockOffPanel();
        this.deptPanel = new DepartmentComboPanel();
        this.nav = new NavBar();
        this.nav.addLeft((Component)this.nav.getBackButton());
        this.nav.addRight((Component)new StandardSecurityDecorator((JComponent)this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/print.png"), Internationalization.getLiteralFor((String)"PRINT_LAST_WEEK"), "printLastWeekTimeSheetBtn", this.printLastWeeksTimeSheetSig), AllPermissions.PRINT_TIMESHEET));
        this.nav.addRight((Component)new StandardSecurityDecorator((JComponent)this.nav.constructButton((Icon)IconLoader.get((String)"/waitermate/guikit/images/print.png"), Internationalization.getLiteralFor((String)"PRINT_CURRENT_WEEK"), "printTimeSheetBtn", this.printTimeSheetSig), AllPermissions.PRINT_TIMESHEET));
        this.nav.setText(Internationalization.getLiteralFor((String)"CLOCK_ON_CLOCK_OFF"));
        this.nav.back.connect((Object)this, "gotBack");
        this.printTimeSheetSig.connect((Object)this, "gotPrintTimeSheet");
        this.printLastWeeksTimeSheetSig.connect((Object)this, "gotPrintLastWeeksTimeSheet");
        this.clockOnOffPanel.clockOff.connect((Object)this, "gotClockOff");
        this.clockOnOffPanel.clockOn.connect((Object)this, "gotClockOn");
        NotificationManager.getInstance().newUserSignal.connect((Object)this, "autoClockOn");
        this.settle = new SettleDeliveryAccounts();
        this.settle.stopped.connect((Object)this, "gotFinishedSettle");
        this.deliveryHelper = new WMDeliveryGuiHelper();
        this.clockOnVerified.connect((Object)this, "gotClockOnVerified");
        this.clockOffVerified.connect((Object)this, "gotClockOffVerified");
        this.gotFingerprint.connect((Object)this, "gotFingerprintSample");
    }

    public static final ClockOnClockOffScreen getInstance() {
        if (instance == null) {
            instance = new ClockOnClockOffScreen();
        }
        return instance;
    }

    public void start(User loggedUser, User userToModify, Signal gotDone, boolean fullscreen, DPFPSample sample, boolean requireVerification) {
        if (this.isDisplaying()) {
            return;
        }
        this.suppliedSample = sample;
        this.requireFingerprint = requireVerification;
        this.loggedInUser = loggedUser;
        this.modifyUser = userToModify;
        this.done = gotDone;
        if (userToModify == null) {
            throw new IllegalArgumentException("Cannot clock a null User on or off.");
        }
        FingerprintDespatch.getInstance().setSignalToUse(this.gotFingerprint);
        this.display(fullscreen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        Object object = this.fingerprintSync;
        synchronized (object) {
            this.isProcessing = false;
        }
        this.suppliedSample = null;
        FingerprintDespatch.getInstance().dismissSignal(this.gotFingerprint);
        if (this.isDisplaying()) {
            this.setupClockOnOffPanel();
        }
    }

    public void autoClockOn(User user) {
        boolean doClockOn;
        if (SystemProperty.getInstance().isAutoClockOn() && !this.isDisplaying() && this.loggedInUser != user && !user.isClockedOn() && user.hasPayrollID() && user.hasPermission(AllPermissions.CLOCK_ON) && (doClockOn = Dialogs.displayChoiceDialog((String)Internationalization.getLiteralFor((String)"DO_YOU_WANT_TO_CLOCK_ON_NOW"), (String)Internationalization.getLiteralFor((String)"CLOCK_ON"), (boolean)true))) {
            this.loggedInUser = user;
            this.modifyUser = user;
            this.doClockOn(this.suppliedSample);
        }
    }

    private void doClockOn(DPFPSample fingerprintSample) {
        this.doVerifyFingerprint(this.clockOnVerified, fingerprintSample);
    }

    private void doClockOff(DPFPSample fingerprintSample) {
        this.doVerifyFingerprint(this.clockOffVerified, fingerprintSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doVerifyFingerprint(Signal verifiedSignal, DPFPSample sample) {
        Object object = this.fingerprintSync;
        synchronized (object) {
            if (this.isProcessing) {
                return;
            }
            this.isProcessing = true;
        }
        if (!this.requireFingerprint) {
            verifiedSignal.emit((Object)Boolean.TRUE);
            return;
        }
        if (this.verifyFingerprint == null && SystemProperty.getInstance().isEnforceBiometricClockon()) {
            this.verifyFingerprint = VerifyFingerprint.makeVerifier(new WaitermateGuiHandler());
        }
        if (this.verifyFingerprint != null) {
            this.verifyFingerprint.startVerifyFingerprint(verifiedSignal, this.modifyUser, sample);
        } else {
            verifiedSignal.emit((Object)Boolean.TRUE);
        }
    }

    public void clearVerifyFingerPrinter() {
        OrderMate.LOG.info("clearing the Verify Finger Printer");
        this.verifyFingerprint = null;
    }

    void gotClockOnVerified(Boolean verified) {
        if (verified.booleanValue()) {
            boolean okDriverFloat;
            Department deptToLoginTo = this.departmentCheck(this.modifyUser);
            if (deptToLoginTo != null && (okDriverFloat = this.checkForDriverFloat())) {
                this.modifyUser.clockOn(deptToLoginTo);
                this.modifyUser.save();
                LoginManager.getInstance().setUser(this.loggedInUser);
                NotificationManager.getInstance().userClockedOnOffSignal.emit((Object)this.loggedInUser);
                Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"YOU_HAVE_BEEN") + " <b>" + Internationalization.getLiteralFor((String)"_CLOCKED_ON") + "</b>, " + this.modifyUser.getName() + "</html>"), (String)Internationalization.getLiteralFor((String)"CLOCKED_ON"));
            }
        } else {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"YOUR_FINGERPRINT_COULD_NOT_BE_VERIFIED_YOU_HAVE") + " <b>" + Internationalization.getLiteralFor((String)"NOT_BEEN_CLOCKED_ON") + "</b>.</html>"), (String)Internationalization.getLiteralFor((String)"REJECTED_FINGERPRINT"));
        }
        this.finish();
    }

    private Department departmentCheck(User userToCheck) {
        Department toReturn = null;
        List usersDepartments = userToCheck.getDepartments();
        if (usersDepartments == null || usersDepartments.isEmpty()) {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"THE_USER_HAS_NO_DEPARTMENTS_WITH_A_PAYRATE"), (String)Internationalization.getLiteralFor((String)"ERROR"));
            OrderMate.LOG.warn("User must have at least 1 department to clock on to!! User: " + userToCheck.getName());
            return null;
        }
        if (usersDepartments.size() == 1) {
            toReturn = (Department)usersDepartments.get(0);
        } else {
            this.deptPanel.setDepartmentList(usersDepartments);
            this.deptPanel.setSelectedDepartment(0);
            Department prevDepartment = DepartmentQueries.getUserLastClockedOnDepartment((User)userToCheck);
            if (prevDepartment != null) {
                this.deptPanel.setSelectedDepartment(prevDepartment);
            }
            if (Dialogs.displayDialog((JComponent)this.deptPanel, (String)"Select Department", (boolean)true)) {
                toReturn = this.deptPanel.getSelectedDepartment();
            }
        }
        return toReturn;
    }

    private boolean checkForDriverFloat() {
        boolean toReturn = true;
        if (this.modifyUser.isDriver()) {
            double defaultAmount = BusinessInfo.getInstance().getDefaultFloatAmount().doubleValue();
            double floatAmount = Dialogs.getPriceDouble((String)(Internationalization.getLiteralFor((String)"ENTER_YOUR_FLOAT_AMOUNT") + ":"), (double)defaultAmount);
            if (floatAmount == Double.MIN_VALUE) {
                toReturn = false;
            } else {
                this.modifyUser.setFloatAmount(floatAmount);
            }
        }
        return toReturn;
    }

    void gotClockOn() {
        this.doClockOn(this.suppliedSample);
        this.suppliedSample = null;
    }

    void gotClockOff() {
        this.doClockOff(this.suppliedSample);
        this.suppliedSample = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gotClockOffVerified(Boolean verified) {
        if (verified.booleanValue()) {
            Object object = this.fingerprintSync;
            synchronized (object) {
                this.isProcessing = false;
            }
            if (!PhoneAccountQueries.getUndeliveredAccounts((User)this.modifyUser).isEmpty()) {
                this.returnThenSettle();
            } else if (!PhoneAccountQueries.getReturnedDeliveryAccounts((User)this.modifyUser).isEmpty()) {
                this.settleDeliveries();
            } else {
                Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"YOU_HAVE_BEEN") + " <b>" + Internationalization.getLiteralFor((String)"_CLOCKED_OFF") + "</b>, " + this.modifyUser.getName()), (String)Internationalization.getLiteralFor((String)"CLOCKED_OFF"));
                this.clockOffThenDone();
                AutoAssignDriverSelector.getInstance().checkAutoAssignedUser(this.modifyUser);
                NotificationManager.getInstance().userClockedOnOffSignal.emit((Object)this.loggedInUser);
            }
        } else {
            Dialogs.displayOkDialog((String)("<html>" + Internationalization.getLiteralFor((String)"YOUR_FINGERPRINT_DID_NOT_MATCH_ANY_ENROLED_PRINTS_YOU_HAVE") + " <b>" + Internationalization.getLiteralFor((String)"NOT_BEEN_CLOCKED_OFF") + "</b>.</html>"), (String)Internationalization.getLiteralFor((String)"REJECTED_FINGERPRINT"));
            this.finish();
        }
    }

    private void settleDeliveries() {
        Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"YOU_HAVE_UNSETLED_DELIVERIES_PLEASE_SETTLE_THEM_NOW"), (String)Internationalization.getLiteralFor((String)"UNSETTLED_DELIVERIES"));
        this.settle.start(this.modifyUser, this.isFullScreen());
    }

    private void returnThenSettle() {
        String title = Internationalization.getLiteralFor((String)"UNRETURNED_DELIVERIES");
        String message = Internationalization.getLiteralFor((String)"THIS_DRIVER_HAS_UNRETURNED_DELIVERIES_YOU_CAN_RETURN_AND_SETTLE_THIS_DELIVERIES_OR_ASSIGN_THE_TO_ANOTHER_DRIVER");
        List<BasicAction> options = Arrays.asList(new BasicAction[]{new ReturnDriver(), new UnassignOrders()});
        Dialogs.displayOptionsDialog((String)title, (String)message, options, (boolean)true);
    }

    private void clockOffThenDone() {
        this.modifyUser.clockOff();
        LoginManager.getInstance().setUser(this.loggedInUser);
        AutoAssignDriverSelector.getInstance().checkAutoAssignedUser(this.modifyUser);
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gotBack() {
        this.suppliedSample = null;
        FingerprintDespatch.getInstance().dismissSignal(this.gotFingerprint);
        LoginManager.getInstance().setUser(this.loggedInUser);
        Object object = this.fingerprintSync;
        synchronized (object) {
            this.isProcessing = false;
        }
        if (this.done != null) {
            this.done.emit();
        }
    }

    public JComponent getMainArea() {
        this.setupClockOnOffPanel();
        return this.clockOnOffPanel;
    }

    private void setupClockOnOffPanel() {
        ClockOnClockOffPanel.ClockOnOffSetup setupScreenFor = this.modifyUser != null && this.modifyUser.isClockedOn() ? ClockOnClockOffPanel.ClockOnOffSetup.CLOCK_OFF : ClockOnClockOffPanel.ClockOnOffSetup.CLOCK_ON;
        this.clockOnOffPanel.setupClockOnOrOffPanel(setupScreenFor, FinanceTimesheetHelper.getUserTimeSheetList((Date)DateTimeUtils.getStartDateForThisWeek(), (User)this.modifyUser));
    }

    public NavBar getNavBar() {
        return this.nav;
    }

    public void gotAssignOrder() {
        Delivery delivery = Delivery.getCurrentDelivery((User)this.modifyUser);
        if (delivery.lock(this.modifyUser)) {
            List removed = delivery.removeAllAccounts();
            delivery.delete();
            for (Lockable acc : removed) {
                acc.unlock();
            }
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"DELIVERIES_FOR") + " " + this.modifyUser.getName() + " " + Internationalization.getLiteralFor((String)"RETURNED")), (String)Internationalization.getLiteralFor((String)"DELIVERIES_REMOVED"));
            this.clockOffThenDone();
        } else {
            Dialogs.displayOkDialog((String)Internationalization.getLiteralFor((String)"DELIVERY_IS_LOCKED_BY_ANOTHER_USER_AND_CANT_BE_CHANGED"), (String)Internationalization.getLiteralFor((String)"DELIVERY_LOCKED"));
        }
    }

    public void gotReturnDriver() {
        Delivery delivery = Delivery.getCurrentDelivery((User)this.modifyUser);
        if (this.deliveryHelper.doReturn(delivery, this.loggedInUser)) {
            this.settle.start(this.modifyUser, this.isFullScreen());
        }
    }

    void gotFingerprintSample(DPFPSample sample) {
        if (sample != null) {
            User user = WaitermateFingerprintListener.getInstance().acquireUser(sample);
            if (user != null && !user.equals((Object)this.modifyUser)) {
                LoginManager.getInstance().setUser(user);
            } else if (this.modifyUser.equals((Object)user) && this.clockOnOffPanel.canClockOnOff()) {
                if (this.clockOnOffPanel.getClockOnOrOffAction().equals((Object)ClockOnClockOffPanel.ClockOnOffSetup.CLOCK_OFF)) {
                    this.doClockOff(sample);
                } else {
                    this.doClockOn(sample);
                }
            }
        }
    }

    private void gotPrintLastWeeksTimeSheet() {
        this.printTimeSheetForWeek(DateTimeUtils.getStartDateForLastWeek());
    }

    private void gotPrintTimeSheet() {
        this.printTimeSheetForWeek(DateTimeUtils.getStartDateForThisWeek());
    }

    private void printTimeSheetForWeek(Date weekBeginning) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
        if (!FinanceTimesheetHelper.printTimesheetForWeekBeginning((Date)weekBeginning, (User)this.modifyUser)) {
            Dialogs.displayOkDialog((String)(Internationalization.getLiteralFor((String)"NO_TIMESHEET_ENTRIES_FOR") + " " + this.modifyUser.getName() + ", " + Internationalization.getLiteralFor((String)"FOR_THE_WEEK_BEGINNING") + " " + dateFormatter.format(weekBeginning) + "."), (String)Internationalization.getLiteralFor((String)"PRINT_TIMESHEETS"));
        }
    }

    public void gotFinishedSettle() {
        AutoAssignDriverSelector.getInstance().checkAutoAssignedUser(this.modifyUser);
        if (!this.isFullScreen()) {
            this.display(this.isFullScreen());
        } else if (this.done != null) {
            this.gotBack();
        } else {
            this.display(false);
        }
    }

    protected static void setInstance(ClockOnClockOffScreen screen) {
        instance = screen;
    }

    private class ReturnDriver
    extends BasicAction {
        public ReturnDriver() {
            super(RETURN_DRIVER, (Icon)IconLoader.get((String)"/waitermate/images/deliveryreturned.png"));
        }

        public void actionPerformed(ActionEvent e) {
            ClockOnClockOffScreen.this.gotReturnDriver();
        }
    }

    private class UnassignOrders
    extends BasicAction {
        public UnassignOrders() {
            super(UNASSIGN_ORDERS, (Icon)IconLoader.get((String)"/waitermate/images/assigndelivery.png"));
        }

        public void actionPerformed(ActionEvent e) {
            ClockOnClockOffScreen.this.gotAssignOrder();
        }
    }
}

